/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxClassification;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxCollection;
import com.box.sdk.BoxComment;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFileUploadSession;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxLock;
import com.box.sdk.BoxMultipartRequest;
import com.box.sdk.BoxRedirectResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.BoxTask;
import com.box.sdk.BoxUser;
import com.box.sdk.BoxWatermark;
import com.box.sdk.BoxWebHook;
import com.box.sdk.LargeFileUpload;
import com.box.sdk.Metadata;
import com.box.sdk.ProgressListener;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.Representation;
import com.box.sdk.URLTemplate;
import com.box.sdk.http.HttpMethod;
import com.box.sdk.internal.utils.Parsers;
import com.box.sdk.sharedlink.BoxSharedLinkRequest;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BoxResourceType(value="file")
public class BoxFile
extends BoxItem {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "sha1", "name", "description", "size", "path_collection", "created_at", "modified_at", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "created_by", "modified_by", "owned_by", "shared_link", "parent", "item_status", "version_number", "comment_count", "permissions", "tags", "lock", "extension", "is_package", "file_version", "collections", "watermark_info", "metadata", "representations", "is_external_only", "expiring_embed_link", "allowed_invitee_roles", "has_collaborations"};
    public static final URLTemplate FILE_URL_TEMPLATE = new URLTemplate("files/%s");
    public static final URLTemplate CONTENT_URL_TEMPLATE = new URLTemplate("files/%s/content");
    public static final URLTemplate VERSIONS_URL_TEMPLATE = new URLTemplate("files/%s/versions");
    public static final URLTemplate COPY_URL_TEMPLATE = new URLTemplate("files/%s/copy");
    public static final URLTemplate ADD_COMMENT_URL_TEMPLATE = new URLTemplate("comments");
    public static final URLTemplate GET_COMMENTS_URL_TEMPLATE = new URLTemplate("files/%s/comments");
    public static final URLTemplate METADATA_URL_TEMPLATE = new URLTemplate("files/%s/metadata/%s/%s");
    public static final URLTemplate ADD_TASK_URL_TEMPLATE = new URLTemplate("tasks");
    public static final URLTemplate GET_TASKS_URL_TEMPLATE = new URLTemplate("files/%s/tasks");
    public static final URLTemplate GET_THUMBNAIL_PNG_TEMPLATE = new URLTemplate("files/%s/thumbnail.png");
    public static final URLTemplate GET_THUMBNAIL_JPG_TEMPLATE = new URLTemplate("files/%s/thumbnail.jpg");
    public static final URLTemplate UPLOAD_SESSION_URL_TEMPLATE = new URLTemplate("files/%s/upload_sessions");
    public static final URLTemplate UPLOAD_SESSION_STATUS_URL_TEMPLATE = new URLTemplate("files/upload_sessions/%s/status");
    public static final URLTemplate ABORT_UPLOAD_SESSION_URL_TEMPLATE = new URLTemplate("files/upload_sessions/%s");
    public static final URLTemplate ADD_COLLABORATION_URL = new URLTemplate("collaborations");
    public static final URLTemplate GET_ALL_FILE_COLLABORATIONS_URL = new URLTemplate("files/%s/collaborations");
    private static final int BUFFER_SIZE = 8192;
    private static final int GET_COLLABORATORS_PAGE_SIZE = 1000;

    public BoxFile(BoxAPIConnection api, String id) {
        super(api, id);
    }

    @Override
    protected URL getItemURL() {
        return FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
    }

    @Override
    @Deprecated
    public BoxSharedLink createSharedLink(BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions) {
        return this.createSharedLink(new BoxSharedLink(access, unshareDate, permissions));
    }

    @Deprecated
    public BoxSharedLink createSharedLink(BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions, String password) {
        return this.createSharedLink(new BoxSharedLink(access, unshareDate, permissions, password));
    }

    public BoxSharedLink createSharedLink(BoxSharedLinkRequest sharedLinkRequest) {
        return this.createSharedLink(sharedLinkRequest.asSharedLink());
    }

    private BoxSharedLink createSharedLink(BoxSharedLink sharedLink) {
        Info info = new Info();
        info.setSharedLink(sharedLink);
        this.updateInfo(info);
        return info.getSharedLink();
    }

    public BoxWebHook.Info addWebHook(URL address, BoxWebHook.Trigger ... triggers) {
        return BoxWebHook.create((BoxResource)this, address, triggers);
    }

    public BoxComment.Info addComment(String message) {
        BoxComment addedComment;
        JsonObject itemJSON = new JsonObject();
        itemJSON.add("type", "file");
        itemJSON.add("id", this.getID());
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("item", itemJSON);
        if (BoxComment.messageContainsMention(message)) {
            requestJSON.add("tagged_message", message);
        } else {
            requestJSON.add("message", message);
        }
        URL url = ADD_COMMENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
        BoxComment boxComment = addedComment = new BoxComment(this.getAPI(), responseJSON.get("id").asString());
        boxComment.getClass();
        return new BoxComment.Info(boxComment, responseJSON);
    }

    public BoxTask.Info addTask(BoxTask.Action action, String message, Date dueAt) {
        return this.addTask(action, message, dueAt, null);
    }

    public BoxTask.Info addTask(BoxTask.Action action, String message, Date dueAt, BoxTask.CompletionRule completionRule) {
        BoxTask addedTask;
        JsonObject itemJSON = new JsonObject();
        itemJSON.add("type", "file");
        itemJSON.add("id", this.getID());
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("item", itemJSON);
        requestJSON.add("action", action.toJSONString());
        if (message != null && !message.isEmpty()) {
            requestJSON.add("message", message);
        }
        if (dueAt != null) {
            requestJSON.add("due_at", BoxDateFormat.format(dueAt));
        }
        if (completionRule != null) {
            requestJSON.add("completion_rule", completionRule.toJSONString());
        }
        URL url = ADD_TASK_URL_TEMPLATE.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
        BoxTask boxTask = addedTask = new BoxTask(this.getAPI(), responseJSON.get("id").asString());
        boxTask.getClass();
        return new BoxTask.Info(boxTask, responseJSON);
    }

    public URL getDownloadURL() {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        request.setFollowRedirects(false);
        BoxRedirectResponse response = (BoxRedirectResponse)request.send();
        return response.getRedirectURL();
    }

    public void download(OutputStream output) {
        this.download(output, null);
    }

    public void download(OutputStream output, ProgressListener listener) {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxAPIResponse response = request.send();
        InputStream input = response.getBody(listener);
        byte[] buffer = new byte[8192];
        try {
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        finally {
            response.disconnect();
        }
    }

    public void downloadRange(OutputStream output, long offset) {
        this.downloadRange(output, offset, -1L);
    }

    public void downloadRange(OutputStream output, long rangeStart, long rangeEnd) {
        this.downloadRange(output, rangeStart, rangeEnd, null);
    }

    public void downloadRange(OutputStream output, long rangeStart, long rangeEnd, ProgressListener listener) {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        if (rangeEnd > 0L) {
            request.addHeader("Range", String.format("bytes=%s-%s", rangeStart, rangeEnd));
        } else {
            request.addHeader("Range", String.format("bytes=%s-", rangeStart));
        }
        BoxAPIResponse response = request.send();
        InputStream input = response.getBody(listener);
        byte[] buffer = new byte[8192];
        try {
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
        }
        finally {
            response.disconnect();
        }
    }

    @Override
    public Info copy(BoxFolder destination) {
        return this.copy(destination, null);
    }

    @Override
    public Info copy(BoxFolder destination, String newName) {
        BoxFile copiedFile;
        URL url = COPY_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject copyInfo = new JsonObject();
        copyInfo.add("parent", parent);
        if (newName != null) {
            copyInfo.add("name", newName);
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.setBody(copyInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
        BoxFile boxFile = copiedFile = new BoxFile(this.getAPI(), responseJSON.get("id").asString());
        boxFile.getClass();
        return boxFile.new Info(responseJSON);
    }

    public void delete() {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    @Override
    public BoxItem.Info move(BoxFolder destination) {
        return this.move(destination, null);
    }

    @Override
    public BoxItem.Info move(BoxFolder destination, String newName) {
        BoxFile movedFile;
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("parent", parent);
        if (newName != null) {
            updateInfo.add("name", newName);
        }
        request.setBody(updateInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
        BoxFile boxFile = movedFile = new BoxFile(this.getAPI(), responseJSON.get("id").asString());
        boxFile.getClass();
        return boxFile.new Info(responseJSON);
    }

    public void rename(String newName) {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("name", newName);
        request.setBody(updateInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        response.getJSON();
    }

    @Override
    public Info getInfo() {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    @Override
    public Info getInfo(String ... fields) {
        String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
        URL url = FILE_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    public Info getInfoWithRepresentations(String representationHints, String ... fields) {
        if (representationHints.matches("^(?:\\[[a-z0-9_]+(?:\\?[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*(?:&[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*)*)?(?:,[a-z0-9_]+(?:\\?[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*(?:&[a-z0-9_]+\\=[a-z0-9_]+(?:\\|[a-z0-9_]+)*)*)?)*\\])+$")) {
            HashSet<String> fieldsSet = new HashSet<String>(Arrays.asList(fields));
            fieldsSet.add("representations");
            String queryString = new QueryStringBuilder().appendParam("fields", fieldsSet.toArray(new String[fieldsSet.size()])).toString();
            URL url = FILE_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
            BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
            request.addHeader("X-Rep-Hints", representationHints);
            BoxJSONResponse response = (BoxJSONResponse)request.send();
            return new Info(response.getJSON());
        }
        throw new BoxAPIException("Represention hints is not valid. Refer documention on how to construct X-Rep-Hints Header");
    }

    public void getRepresentationContent(String representationHint, OutputStream output) {
        this.getRepresentationContent(representationHint, "", output);
    }

    public void getRepresentationContent(String representationHint, String assetPath, OutputStream output) {
        List<Representation> reps = this.getInfoWithRepresentations(representationHint, new String[0]).getRepresentations();
        if (reps.size() < 1) {
            throw new BoxAPIException("No matching representations found");
        }
        Representation representation = reps.get(0);
        String repState = representation.getStatus().getState();
        if (repState.equals("viewable") || repState.equals("success")) {
            this.makeRepresentationContentRequest(representation.getContent().getUrlTemplate(), assetPath, output);
        } else if (repState.equals("pending") || repState.equals("none")) {
            String repContentURLString = null;
            while (repContentURLString == null) {
                repContentURLString = this.pollRepInfo(representation.getInfo().getUrl());
            }
            this.makeRepresentationContentRequest(repContentURLString, assetPath, output);
        } else {
            if (repState.equals("error")) {
                throw new BoxAPIException("Representation had error status");
            }
            throw new BoxAPIException("Representation had unknown status");
        }
    }

    private String pollRepInfo(URL infoURL) {
        BoxAPIRequest infoRequest = new BoxAPIRequest(this.getAPI(), infoURL, HttpMethod.GET);
        BoxJSONResponse infoResponse = (BoxJSONResponse)infoRequest.send();
        JsonObject response = infoResponse.getJsonObject();
        Representation rep = new Representation(response);
        String repState = rep.getStatus().getState();
        if (repState.equals("viewable") || repState.equals("success")) {
            return rep.getContent().getUrlTemplate();
        }
        if (repState.equals("pending") || repState.equals("none")) {
            return null;
        }
        if (repState.equals("error")) {
            throw new BoxAPIException("Representation had error status");
        }
        throw new BoxAPIException("Representation had unknown status");
    }

    private void makeRepresentationContentRequest(String representationURLTemplate, String assetPath, OutputStream output) {
        try {
            URL repURL = new URL(representationURLTemplate.replace("{+asset_path}", assetPath));
            BoxAPIRequest repContentReq = new BoxAPIRequest(this.getAPI(), repURL, HttpMethod.GET);
            BoxAPIResponse contentResponse = repContentReq.send();
            InputStream input = contentResponse.getBody();
            byte[] buffer = new byte[8192];
            try {
                int n = input.read(buffer);
                while (n != -1) {
                    output.write(buffer, 0, n);
                    n = input.read(buffer);
                }
            }
            catch (IOException e) {
                throw new BoxAPIException("Couldn't connect to the Box API due to a network error.", e);
            }
            finally {
                contentResponse.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            throw new BoxAPIException("Could not generate representation content URL");
        }
    }

    public void updateInfo(Info info) {
        URL url = FILE_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
        info.update(jsonObject);
    }

    public Collection<BoxFileVersion> getVersions() {
        URL url = VERSIONS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
        JsonArray entries = jsonObject.get("entries").asArray();
        ArrayList<BoxFileVersion> versions = new ArrayList<BoxFileVersion>();
        for (JsonValue entry : entries) {
            versions.add(new BoxFileVersion(this.getAPI(), entry.asObject(), this.getID()));
        }
        return versions;
    }

    @Deprecated
    public void canUploadVersion(String name, long fileSize, String parentID) {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "OPTIONS");
        JsonObject parent = new JsonObject();
        parent.add("id", parentID);
        JsonObject preflightInfo = new JsonObject();
        preflightInfo.add("parent", parent);
        if (name != null) {
            preflightInfo.add("name", name);
        }
        preflightInfo.add("size", fileSize);
        request.setBody(preflightInfo.toString());
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public boolean canUploadVersion(String name) {
        return this.canUploadVersion(name, 0L);
    }

    public boolean canUploadVersion(String name, long fileSize) {
        URL url = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "OPTIONS");
        JsonObject preflightInfo = new JsonObject();
        if (name != null) {
            preflightInfo.add("name", name);
        }
        preflightInfo.add("size", fileSize);
        request.setBody(preflightInfo.toString());
        try {
            BoxAPIResponse response = request.send();
            return response.getResponseCode() == 200;
        }
        catch (BoxAPIException ex) {
            if (ex.getResponseCode() >= 400 && ex.getResponseCode() < 500) {
                return false;
            }
            throw ex;
        }
    }

    @Deprecated
    public void uploadVersion(InputStream fileContent) {
        this.uploadVersion(fileContent, null);
    }

    @Deprecated
    public void uploadVersion(InputStream fileContent, String fileContentSHA1) {
        this.uploadVersion(fileContent, fileContentSHA1, null);
    }

    @Deprecated
    public void uploadVersion(InputStream fileContent, String fileContentSHA1, Date modified) {
        this.uploadVersion(fileContent, fileContentSHA1, modified, 0L, null);
    }

    @Deprecated
    public void uploadVersion(InputStream fileContent, Date modified, long fileSize, ProgressListener listener) {
        this.uploadVersion(fileContent, null, modified, fileSize, listener);
    }

    @Deprecated
    public void uploadVersion(InputStream fileContent, String fileContentSHA1, Date modified, long fileSize, ProgressListener listener) {
        this.uploadNewVersion(fileContent, fileContentSHA1, modified, fileSize, listener);
    }

    public Info uploadNewVersion(InputStream fileContent) {
        return this.uploadNewVersion(fileContent, null);
    }

    public Info uploadNewVersion(InputStream fileContent, String fileContentSHA1) {
        return this.uploadNewVersion(fileContent, fileContentSHA1, null);
    }

    public Info uploadNewVersion(InputStream fileContent, String fileContentSHA1, Date modified) {
        return this.uploadNewVersion(fileContent, fileContentSHA1, modified, 0L, null);
    }

    public Info uploadNewVersion(InputStream fileContent, String fileContentSHA1, Date modified, String name) {
        return this.uploadNewVersion(fileContent, fileContentSHA1, modified, name, 0L, null);
    }

    public Info uploadNewVersion(InputStream fileContent, Date modified, long fileSize, ProgressListener listener) {
        return this.uploadNewVersion(fileContent, null, modified, fileSize, listener);
    }

    public Info uploadNewVersion(InputStream fileContent, String fileContentSHA1, Date modified, long fileSize, ProgressListener listener) {
        return this.uploadNewVersion(fileContent, fileContentSHA1, modified, null, fileSize, listener);
    }

    public Info uploadNewVersion(InputStream fileContent, String fileContentSHA1, Date modified, String name, long fileSize, ProgressListener listener) {
        URL uploadURL = CONTENT_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), this.getID());
        BoxMultipartRequest request = new BoxMultipartRequest(this.getAPI(), uploadURL);
        if (fileSize > 0L) {
            request.setFile(fileContent, "", fileSize);
        } else {
            request.setFile(fileContent, "");
        }
        if (fileContentSHA1 != null) {
            request.setContentSHA1(fileContentSHA1);
        }
        JsonObject attributesJSON = new JsonObject();
        if (modified != null) {
            attributesJSON.add("content_modified_at", BoxDateFormat.format(modified));
        }
        if (name != null) {
            attributesJSON.add("name", name);
        }
        request.putField("attributes", attributesJSON.toString());
        BoxJSONResponse response = listener == null ? (BoxJSONResponse)request.send() : (BoxJSONResponse)request.send(listener);
        String fileJSON = response.getJsonObject().get("entries").asArray().get(0).toString();
        return new Info(fileJSON);
    }

    public URL getPreviewLink() {
        Info info = this.getInfo("expiring_embed_link");
        return info.getPreviewLink();
    }

    @Deprecated
    public byte[] getThumbnail(ThumbnailFileType fileType, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        URLTemplate template;
        QueryStringBuilder builder = new QueryStringBuilder();
        builder.appendParam("min_width", minWidth);
        builder.appendParam("min_height", minHeight);
        builder.appendParam("max_width", maxWidth);
        builder.appendParam("max_height", maxHeight);
        if (fileType == ThumbnailFileType.PNG) {
            template = GET_THUMBNAIL_PNG_TEMPLATE;
        } else if (fileType == ThumbnailFileType.JPG) {
            template = GET_THUMBNAIL_JPG_TEMPLATE;
        } else {
            throw new BoxAPIException("Unsupported thumbnail file type");
        }
        URL url = template.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxAPIResponse response = request.send();
        ByteArrayOutputStream thumbOut = new ByteArrayOutputStream();
        InputStream body = response.getBody();
        byte[] buffer = new byte[8192];
        try {
            int n = body.read(buffer);
            while (n != -1) {
                thumbOut.write(buffer, 0, n);
                n = body.read(buffer);
            }
        }
        catch (IOException e) {
            throw new BoxAPIException("Error reading thumbnail bytes from response body", e);
        }
        finally {
            response.disconnect();
        }
        return thumbOut.toByteArray();
    }

    public List<BoxComment.Info> getComments() {
        URL url = GET_COMMENTS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
        int totalCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxComment.Info> comments = new ArrayList<BoxComment.Info>(totalCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue value : entries) {
            BoxComment comment;
            JsonObject commentJSON = value.asObject();
            BoxComment boxComment = comment = new BoxComment(this.getAPI(), commentJSON.get("id").asString());
            boxComment.getClass();
            BoxComment.Info info = new BoxComment.Info(boxComment, commentJSON);
            comments.add(info);
        }
        return comments;
    }

    public List<BoxTask.Info> getTasks(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = GET_TASKS_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
        int totalCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxTask.Info> tasks = new ArrayList<BoxTask.Info>(totalCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue value : entries) {
            BoxTask task;
            JsonObject taskJSON = value.asObject();
            BoxTask boxTask = task = new BoxTask(this.getAPI(), taskJSON.get("id").asString());
            boxTask.getClass();
            BoxTask.Info info = new BoxTask.Info(boxTask, taskJSON);
            tasks.add(info);
        }
        return tasks;
    }

    public Metadata createMetadata(Metadata metadata) {
        return this.createMetadata("properties", metadata);
    }

    public Metadata createMetadata(String typeName, Metadata metadata) {
        String scope = Metadata.scopeBasedOnType(typeName);
        return this.createMetadata(typeName, scope, metadata);
    }

    public Metadata createMetadata(String typeName, String scope, Metadata metadata) {
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), scope, typeName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "POST");
        request.addHeader("Content-Type", "application/json");
        request.setBody(metadata.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(Json.parse(response.getJSON()).asObject());
    }

    public Metadata setMetadata(String templateName, String scope, Metadata metadata) {
        Metadata metadataValue;
        try {
            metadataValue = this.createMetadata(templateName, scope, metadata);
        }
        catch (BoxAPIException e) {
            if (e.getResponseCode() == 409) {
                Metadata metadataToUpdate = new Metadata(scope, templateName);
                for (JsonValue value : metadata.getOperations()) {
                    if (value.asObject().get("value").isNumber()) {
                        metadataToUpdate.add(value.asObject().get("path").asString(), value.asObject().get("value").asDouble());
                        continue;
                    }
                    if (value.asObject().get("value").isString()) {
                        metadataToUpdate.add(value.asObject().get("path").asString(), value.asObject().get("value").asString());
                        continue;
                    }
                    if (!value.asObject().get("value").isArray()) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    for (JsonValue jsonValue : value.asObject().get("value").asArray()) {
                        list.add(jsonValue.asString());
                    }
                    metadataToUpdate.add(value.asObject().get("path").asString(), list);
                }
                metadataValue = this.updateMetadata(metadataToUpdate);
            }
            throw e;
        }
        return metadataValue;
    }

    public String addClassification(String classificationType) {
        Metadata metadata = new Metadata().add("/Box__Security__Classification__Key", classificationType);
        Metadata classification = this.createMetadata("securityClassification-6VMVochwUWo", "enterprise", metadata);
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String updateClassification(String classificationType) {
        Metadata metadata = new Metadata("enterprise", "securityClassification-6VMVochwUWo");
        metadata.add("/Box__Security__Classification__Key", classificationType);
        Metadata classification = this.updateMetadata(metadata);
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String setClassification(String classificationType) {
        Metadata classification;
        Metadata metadata = new Metadata().add("/Box__Security__Classification__Key", classificationType);
        try {
            classification = this.createMetadata("securityClassification-6VMVochwUWo", "enterprise", metadata);
        }
        catch (BoxAPIException e) {
            if (e.getResponseCode() == 409) {
                metadata = new Metadata("enterprise", "securityClassification-6VMVochwUWo");
                metadata.replace("/Box__Security__Classification__Key", classificationType);
                classification = this.updateMetadata(metadata);
            }
            throw e;
        }
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String getClassification() {
        Metadata metadata;
        try {
            metadata = this.getMetadata("securityClassification-6VMVochwUWo");
        }
        catch (BoxAPIException e) {
            JsonObject responseObject = Json.parse(e.getResponse()).asObject();
            String code = responseObject.get("code").asString();
            if (e.getResponseCode() == 404 && code.equals("instance_not_found")) {
                return null;
            }
            throw e;
        }
        return metadata.getString("/Box__Security__Classification__Key");
    }

    public void deleteClassification() {
        this.deleteMetadata("securityClassification-6VMVochwUWo", "enterprise");
    }

    public BoxLock lock() {
        return this.lock(null, false);
    }

    public BoxLock lock(boolean isDownloadPrevented) {
        return this.lock(null, isDownloadPrevented);
    }

    public BoxLock lock(Date expiresAt) {
        return this.lock(expiresAt, false);
    }

    public BoxLock lock(Date expiresAt, boolean isDownloadPrevented) {
        String queryString = new QueryStringBuilder().appendParam("fields", "lock").toString();
        URL url = FILE_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "PUT");
        JsonObject lockConfig = new JsonObject();
        lockConfig.add("type", "lock");
        if (expiresAt != null) {
            lockConfig.add("expires_at", BoxDateFormat.format(expiresAt));
        }
        lockConfig.add("is_download_prevented", isDownloadPrevented);
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("lock", lockConfig);
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = Json.parse(response.getJSON()).asObject();
        JsonValue lockValue = responseJSON.get("lock");
        JsonObject lockJSON = Json.parse(lockValue.toString()).asObject();
        return new BoxLock(lockJSON, this.getAPI());
    }

    public void unlock() {
        String queryString = new QueryStringBuilder().appendParam("fields", "lock").toString();
        URL url = FILE_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "PUT");
        JsonObject lockObject = new JsonObject();
        lockObject.add("lock", Json.NULL);
        request.setBody(lockObject.toString());
        request.send();
    }

    public Iterable<Metadata> getAllMetadata(String ... fields) {
        return Metadata.getAllMetadata(this, fields);
    }

    public Metadata getMetadata() {
        return this.getMetadata("properties");
    }

    public Metadata getMetadata(String typeName) {
        String scope = Metadata.scopeBasedOnType(typeName);
        return this.getMetadata(typeName, scope);
    }

    public Metadata getMetadata(String typeName, String scope) {
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), scope, typeName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(Json.parse(response.getJSON()).asObject());
    }

    public Metadata updateMetadata(Metadata metadata) {
        String scope = metadata.getScope().equals("global") ? "global" : (metadata.getScope().startsWith("enterprise") ? metadata.getScope() : "enterprise");
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), scope, metadata.getTemplateName());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "PUT");
        request.addHeader("Content-Type", "application/json-patch+json");
        request.setBody(metadata.getPatch());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(Json.parse(response.getJSON()).asObject());
    }

    public void deleteMetadata() {
        this.deleteMetadata("properties");
    }

    public void deleteMetadata(String typeName) {
        String scope = Metadata.scopeBasedOnType(typeName);
        this.deleteMetadata(typeName, scope);
    }

    public void deleteMetadata(String typeName, String scope) {
        URL url = METADATA_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID(), scope, typeName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        request.send();
    }

    public BoxWatermark getWatermark(String ... fields) {
        return this.getWatermark(FILE_URL_TEMPLATE, fields);
    }

    public BoxWatermark applyWatermark() {
        return this.applyWatermark(FILE_URL_TEMPLATE, "default");
    }

    public void removeWatermark() {
        this.removeWatermark(FILE_URL_TEMPLATE);
    }

    @Override
    public Info setCollections(BoxCollection ... collections) {
        JsonArray jsonArray = new JsonArray();
        for (BoxCollection collection : collections) {
            JsonObject collectionJSON = new JsonObject();
            collectionJSON.add("id", collection.getID());
            jsonArray.add(collectionJSON);
        }
        JsonObject infoJSON = new JsonObject();
        infoJSON.add("collections", jsonArray);
        String queryString = new QueryStringBuilder().appendParam("fields", ALL_FIELDS).toString();
        URL url = FILE_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(infoJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
        return new Info(jsonObject);
    }

    public BoxFileUploadSession.Info createUploadSession(long fileSize) {
        BoxFileUploadSession session;
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        request.addHeader("Content-Type", "application/json");
        JsonObject body = new JsonObject();
        body.add("file_size", fileSize);
        request.setBody(body.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = Json.parse(response.getJSON()).asObject();
        String sessionId = jsonObject.get("id").asString();
        BoxFileUploadSession boxFileUploadSession = session = new BoxFileUploadSession(this.getAPI(), sessionId);
        boxFileUploadSession.getClass();
        return boxFileUploadSession.new BoxFileUploadSession.Info(jsonObject);
    }

    public Info uploadLargeFile(InputStream inputStream, long fileSize) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), this.getID());
        return new LargeFileUpload().upload(this.getAPI(), inputStream, url, fileSize);
    }

    public Info uploadLargeFile(InputStream inputStream, long fileSize, Map<String, String> fileAttributes) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), this.getID());
        return new LargeFileUpload().upload(this.getAPI(), inputStream, url, fileSize, fileAttributes);
    }

    public Info uploadLargeFile(InputStream inputStream, long fileSize, int nParallelConnections, long timeOut, TimeUnit unit) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), this.getID());
        return new LargeFileUpload(nParallelConnections, timeOut, unit).upload(this.getAPI(), inputStream, url, fileSize);
    }

    public Info uploadLargeFile(InputStream inputStream, long fileSize, int nParallelConnections, long timeOut, TimeUnit unit, Map<String, String> fileAttributes) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), this.getID());
        return new LargeFileUpload(nParallelConnections, timeOut, unit).upload(this.getAPI(), inputStream, url, fileSize, fileAttributes);
    }

    private BoxCollaboration.Info collaborate(JsonObject accessibleByField, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        JsonObject itemField = new JsonObject();
        itemField.add("id", this.getID());
        itemField.add("type", "file");
        return BoxCollaboration.create(this.getAPI(), accessibleByField, itemField, role, notify, canViewPath);
    }

    public BoxCollaboration.Info collaborate(BoxCollaborator collaborator, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("id", collaborator.getID());
        if (collaborator instanceof BoxUser) {
            accessibleByField.add("type", "user");
        } else if (collaborator instanceof BoxGroup) {
            accessibleByField.add("type", "group");
        } else {
            throw new IllegalArgumentException("The given collaborator is of an unknown type.");
        }
        return this.collaborate(accessibleByField, role, notify, canViewPath);
    }

    public BoxCollaboration.Info collaborate(String email, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("login", email);
        accessibleByField.add("type", "user");
        return this.collaborate(accessibleByField, role, notify, canViewPath);
    }

    public BoxResourceIterable<BoxCollaboration.Info> getAllFileCollaborations(String ... fields) {
        return BoxCollaboration.getAllFileCollaborations(this.getAPI(), this.getID(), 1000, fields);
    }

    public class Info
    extends BoxItem.Info {
        private String sha1;
        private String versionNumber;
        private long commentCount;
        private EnumSet<Permission> permissions;
        private String extension;
        private boolean isPackage;
        private BoxFileVersion version;
        private URL previewLink;
        private BoxLock lock;
        private boolean isWatermarked;
        private boolean isExternallyOwned;
        private JsonObject metadata;
        private Map<String, Map<String, Metadata>> metadataMap;
        private List<Representation> representations;
        private List<String> allowedInviteeRoles;
        private Boolean hasCollaborations;
        private String uploaderDisplayName;
        private BoxClassification classification;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        public Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxFile getResource() {
            return BoxFile.this;
        }

        public String getSha1() {
            return this.sha1;
        }

        public BoxLock getLock() {
            return this.lock;
        }

        public String getVersionNumber() {
            return this.versionNumber;
        }

        public long getCommentCount() {
            return this.commentCount;
        }

        public EnumSet<Permission> getPermissions() {
            return this.permissions;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean getIsPackage() {
            return this.isPackage;
        }

        public BoxFileVersion getVersion() {
            return this.version;
        }

        public URL getPreviewLink() {
            return this.previewLink;
        }

        public boolean getIsWatermarked() {
            return this.isWatermarked;
        }

        public List<String> getAllowedInviteeRoles() {
            return this.allowedInviteeRoles;
        }

        public Boolean getHasCollaborations() {
            return this.hasCollaborations;
        }

        public Metadata getMetadata(String templateName, String scope) {
            try {
                return this.metadataMap.get(scope).get(templateName);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        public boolean getIsExternallyOwned() {
            return this.isExternallyOwned;
        }

        public List<Representation> getRepresentations() {
            return this.representations;
        }

        public String getUploaderDisplayName() {
            return this.uploaderDisplayName;
        }

        public BoxClassification getClassification() {
            return this.classification;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            block26: {
                super.parseJSONMember(member);
                String memberName = member.getName();
                JsonValue value = member.getValue();
                try {
                    if (memberName.equals("sha1")) {
                        this.sha1 = value.asString();
                        break block26;
                    }
                    if (memberName.equals("version_number")) {
                        this.versionNumber = value.asString();
                        break block26;
                    }
                    if (memberName.equals("comment_count")) {
                        this.commentCount = value.asLong();
                        break block26;
                    }
                    if (memberName.equals("permissions")) {
                        this.permissions = this.parsePermissions(value.asObject());
                        break block26;
                    }
                    if (memberName.equals("extension")) {
                        this.extension = value.asString();
                        break block26;
                    }
                    if (memberName.equals("is_package")) {
                        this.isPackage = value.asBoolean();
                        break block26;
                    }
                    if (memberName.equals("has_collaborations")) {
                        this.hasCollaborations = value.asBoolean();
                        break block26;
                    }
                    if (memberName.equals("is_externally_owned")) {
                        this.isExternallyOwned = value.asBoolean();
                        break block26;
                    }
                    if (memberName.equals("file_version")) {
                        this.version = this.parseFileVersion(value.asObject());
                        break block26;
                    }
                    if (memberName.equals("allowed_invitee_roles")) {
                        this.allowedInviteeRoles = this.parseAllowedInviteeRoles(value.asArray());
                        break block26;
                    }
                    if (memberName.equals("expiring_embed_link")) {
                        try {
                            String urlString = member.getValue().asObject().get("url").asString();
                            this.previewLink = new URL(urlString);
                            break block26;
                        }
                        catch (MalformedURLException e) {
                            throw new BoxAPIException("Couldn't parse expiring_embed_link/url for file", e);
                        }
                    }
                    if (memberName.equals("lock")) {
                        this.lock = value.isNull() ? null : new BoxLock(value.asObject(), BoxFile.this.getAPI());
                    } else if (memberName.equals("watermark_info")) {
                        JsonObject jsonObject = value.asObject();
                        this.isWatermarked = jsonObject.get("is_watermarked").asBoolean();
                    } else if (memberName.equals("metadata")) {
                        JsonObject jsonObject = value.asObject();
                        this.metadataMap = Parsers.parseAndPopulateMetadataMap(jsonObject);
                    } else if (memberName.equals("representations")) {
                        JsonObject jsonObject = value.asObject();
                        this.representations = Parsers.parseRepresentations(jsonObject);
                    } else if (memberName.equals("uploader_display_name")) {
                        this.uploaderDisplayName = value.asString();
                    } else if (memberName.equals("classification")) {
                        this.classification = value.isNull() ? null : new BoxClassification(value.asObject());
                    }
                }
                catch (Exception e) {
                    throw new BoxDeserializationException(memberName, value.toString(), e);
                }
            }
        }

        private EnumSet<Permission> parsePermissions(JsonObject jsonObject) {
            EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
            for (JsonObject.Member member : jsonObject) {
                JsonValue value = member.getValue();
                if (value.isNull() || !value.asBoolean()) continue;
                String memberName = member.getName();
                if (memberName.equals("can_download")) {
                    permissions.add(Permission.CAN_DOWNLOAD);
                    continue;
                }
                if (memberName.equals("can_upload")) {
                    permissions.add(Permission.CAN_UPLOAD);
                    continue;
                }
                if (memberName.equals("can_rename")) {
                    permissions.add(Permission.CAN_RENAME);
                    continue;
                }
                if (memberName.equals("can_delete")) {
                    permissions.add(Permission.CAN_DELETE);
                    continue;
                }
                if (memberName.equals("can_share")) {
                    permissions.add(Permission.CAN_SHARE);
                    continue;
                }
                if (memberName.equals("can_set_share_access")) {
                    permissions.add(Permission.CAN_SET_SHARE_ACCESS);
                    continue;
                }
                if (memberName.equals("can_preview")) {
                    permissions.add(Permission.CAN_PREVIEW);
                    continue;
                }
                if (!memberName.equals("can_comment")) continue;
                permissions.add(Permission.CAN_COMMENT);
            }
            return permissions;
        }

        private BoxFileVersion parseFileVersion(JsonObject jsonObject) {
            return new BoxFileVersion(BoxFile.this.getAPI(), jsonObject, BoxFile.this.getID());
        }

        private List<String> parseAllowedInviteeRoles(JsonArray jsonArray) {
            ArrayList<String> roles = new ArrayList<String>(jsonArray.size());
            for (JsonValue value : jsonArray) {
                roles.add(value.asString());
            }
            return roles;
        }
    }

    public static enum Permission {
        CAN_DOWNLOAD("can_download"),
        CAN_UPLOAD("can_upload"),
        CAN_RENAME("can_rename"),
        CAN_DELETE("can_delete"),
        CAN_SHARE("can_share"),
        CAN_SET_SHARE_ACCESS("can_set_share_access"),
        CAN_PREVIEW("can_preview"),
        CAN_COMMENT("can_comment"),
        CAN_ANNOTATE("can_annotate"),
        CAN_INVITE_COLLABORATOR("can_invite_collaborator"),
        CAN_VIEW_ANNOTATIONS_ALL("can_view_annotations_all"),
        CAN_VIEW_ANNOTATIONS_SELF("can_view_annotations_self");

        private final String jsonValue;

        private Permission(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Permission fromJSONValue(String jsonValue) {
            return Permission.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum ThumbnailFileType {
        PNG,
        JPG;

    }
}

