/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxRetentionPolicy;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;

@BoxResourceType(value="file_version_retention")
public class BoxFileVersionRetention
extends BoxResource {
    public static final URLTemplate RETENTION_URL_TEMPLATE = new URLTemplate("file_version_retentions/%s");
    public static final URLTemplate ALL_RETENTIONS_URL_TEMPLATE = new URLTemplate("file_version_retentions");
    private static final int DEFAULT_LIMIT = 100;

    public BoxFileVersionRetention(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Iterable<Info> getAll(BoxAPIConnection api, String ... fields) {
        return BoxFileVersionRetention.getRetentions(api, new QueryFilter(), fields);
    }

    public static Iterable<Info> getRetentions(final BoxAPIConnection api, QueryFilter filter, String ... fields) {
        filter.addFields(fields);
        return new BoxResourceIterable<Info>(api, ALL_RETENTIONS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), filter.toString(), new Object[0]), 100){

            @Override
            protected Info factory(JsonObject jsonObject) {
                BoxFileVersionRetention retention;
                BoxFileVersionRetention boxFileVersionRetention = retention = new BoxFileVersionRetention(api, jsonObject.get("id").asString());
                boxFileVersionRetention.getClass();
                return boxFileVersionRetention.new Info(jsonObject);
            }
        };
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = RETENTION_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        return new Info(responseJSON);
    }

    public class Info
    extends BoxResource.Info {
        private BoxFileVersion fileVersion;
        private BoxFile.Info file;
        private Date appliedAt;
        private Date dispositionAt;
        private BoxRetentionPolicy.Info winningPolicy;

        public Info() {
            super(BoxFileVersionRetention.this);
        }

        public Info(String json) {
            super((BoxResource)BoxFileVersionRetention.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxFileVersionRetention.this, jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxFileVersionRetention.this;
        }

        public BoxFileVersion getFileVersion() {
            return this.fileVersion;
        }

        public BoxFile.Info getFile() {
            return this.file;
        }

        public Date getAppliedAt() {
            return this.appliedAt;
        }

        public Date getDispositionAt() {
            return this.dispositionAt;
        }

        public BoxRetentionPolicy.Info getWinningPolicy() {
            return this.winningPolicy;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("winning_retention_policy")) {
                    JsonObject policyJSON = value.asObject();
                    if (this.winningPolicy == null) {
                        BoxRetentionPolicy policy;
                        String policyID = policyJSON.get("id").asString();
                        BoxRetentionPolicy boxRetentionPolicy = policy = new BoxRetentionPolicy(BoxFileVersionRetention.this.getAPI(), policyID);
                        boxRetentionPolicy.getClass();
                        this.winningPolicy = new BoxRetentionPolicy.Info(boxRetentionPolicy, policyJSON);
                    } else {
                        this.winningPolicy.update(policyJSON);
                    }
                } else if (memberName.equals("file")) {
                    JsonObject fileJSON = value.asObject();
                    if (this.file == null) {
                        BoxFile file;
                        String fileID = fileJSON.get("id").asString();
                        BoxFile boxFile = file = new BoxFile(BoxFileVersionRetention.this.getAPI(), fileID);
                        boxFile.getClass();
                        this.file = new BoxFile.Info(boxFile, fileJSON);
                    } else {
                        this.file.update(fileJSON);
                    }
                } else if (memberName.equals("file_version")) {
                    JsonObject versionJSON = value.asObject();
                    String fileVersionID = versionJSON.get("id").asString();
                    this.fileVersion = new BoxFileVersion(BoxFileVersionRetention.this.getAPI(), versionJSON, fileVersionID);
                } else if (memberName.equals("applied_at")) {
                    this.appliedAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("disposition_at")) {
                    this.dispositionAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }

    public static class QueryFilter
    extends QueryStringBuilder {
        private static final String PARAM_FILE_ID = "file_id";
        private static final String PARAM_FILE_VERSION_ID = "file_version_id";
        private static final String PARAM_POLICY_ID = "policy_id";
        private static final String PARAM_DISPOSITION_ACTION = "disposition_action";
        private static final String PARAM_DISPOSITION_BEFORE = "disposition_before";
        private static final String PARAM_DISPOSITION_AFTER = "disposition_after";
        private static final String PARAM_FIELDS = "fields";

        public QueryFilter addFileID(String id) {
            this.appendParam(PARAM_FILE_ID, id);
            return this;
        }

        public QueryFilter addFileVersionID(String id) {
            this.appendParam(PARAM_FILE_VERSION_ID, id);
            return this;
        }

        public QueryFilter addPolicyID(String id) {
            this.appendParam(PARAM_POLICY_ID, id);
            return this;
        }

        public QueryFilter addDispositionAction(String action) {
            this.appendParam(PARAM_DISPOSITION_ACTION, action);
            return this;
        }

        public QueryFilter addDispositionBefore(Date date) {
            this.appendParam(PARAM_DISPOSITION_BEFORE, BoxDateFormat.format(date));
            return this;
        }

        public QueryFilter addDispositionAfter(Date date) {
            this.appendParam(PARAM_DISPOSITION_AFTER, BoxDateFormat.format(date));
            return this;
        }

        public QueryFilter addFields(String ... fields) {
            if (fields.length > 0) {
                this.appendParam(PARAM_FIELDS, fields);
            }
            return this;
        }
    }
}

