/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborationIterator;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxGroupIterator;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxGroupMembershipIterator;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@BoxResourceType(value="group")
public class BoxGroup
extends BoxCollaborator {
    public static final URLTemplate GROUPS_URL_TEMPLATE = new URLTemplate("groups");
    public static final URLTemplate GROUP_URL_TEMPLATE = new URLTemplate("groups/%s");
    public static final URLTemplate MEMBERSHIPS_URL_TEMPLATE = new URLTemplate("groups/%s/memberships");
    public static final URLTemplate ADD_MEMBERSHIP_URL_TEMPLATE = new URLTemplate("group_memberships");
    public static final URLTemplate COLLABORATIONS_URL_TEMPLATE = new URLTemplate("groups/%s/collaborations");

    public BoxGroup(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createGroup(BoxAPIConnection api, String name) {
        return BoxGroup.createGroup(api, name, null, null, null, null, null);
    }

    public static Info createGroup(BoxAPIConnection api, String name, String provenance, String externalSyncIdentifier, String description, String invitabilityLevel, String memberViewabilityLevel) {
        BoxGroup group;
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("name", name);
        if (provenance != null) {
            requestJSON.add("provenance", provenance);
        }
        if (externalSyncIdentifier != null) {
            requestJSON.add("external_sync_identifier", externalSyncIdentifier);
        }
        if (description != null) {
            requestJSON.add("description", description);
        }
        if (invitabilityLevel != null) {
            requestJSON.add("invitability_level", invitabilityLevel);
        }
        if (memberViewabilityLevel != null) {
            requestJSON.add("member_viewability_level", memberViewabilityLevel);
        }
        URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxGroup boxGroup = group = new BoxGroup(api, responseJSON.get("id").asString());
        boxGroup.getClass();
        return boxGroup.new Info(responseJSON);
    }

    public static Iterable<Info> getAllGroups(final BoxAPIConnection api) {
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                URL url = GROUPS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
                return new BoxGroupIterator(api, url);
            }
        };
    }

    public static Iterable<Info> getAllGroups(final BoxAPIConnection api, String ... fields) {
        final QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                URL url = GROUPS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
                return new BoxGroupIterator(api, url);
            }
        };
    }

    public static Iterable<Info> getAllGroupsByName(BoxAPIConnection api, String name) {
        return BoxGroup.getAllGroupsByName(api, name, null);
    }

    public static Iterable<Info> getAllGroupsByName(final BoxAPIConnection api, String name, String ... fields) {
        final QueryStringBuilder builder = new QueryStringBuilder();
        if (name == null || name.trim().isEmpty()) {
            throw new BoxAPIException("Searching groups by name requires a non NULL or non empty name");
        }
        builder.appendParam("filter_term", name);
        if (fields != null && fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                URL url = GROUPS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
                return new BoxGroupIterator(api, url);
            }
        };
    }

    public Info getInfo() {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        return new Info(responseJSON);
    }

    public Info getInfo(String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        URL url = GROUP_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        return new Info(responseJSON);
    }

    public Collection<BoxGroupMembership.Info> getMemberships() {
        final BoxAPIConnection api = this.getAPI();
        final String groupID = this.getID();
        Iterable<BoxGroupMembership.Info> iter = new Iterable<BoxGroupMembership.Info>(){

            @Override
            public Iterator<BoxGroupMembership.Info> iterator() {
                URL url = MEMBERSHIPS_URL_TEMPLATE.build(api.getBaseURL(), groupID);
                return new BoxGroupMembershipIterator(api, url);
            }
        };
        ArrayList<BoxGroupMembership.Info> memberships = new ArrayList<BoxGroupMembership.Info>();
        for (BoxGroupMembership.Info membership : iter) {
            memberships.add(membership);
        }
        return memberships;
    }

    public Iterable<BoxGroupMembership.Info> getAllMemberships(String ... fields) {
        final QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new Iterable<BoxGroupMembership.Info>(){

            @Override
            public Iterator<BoxGroupMembership.Info> iterator() {
                URL url = MEMBERSHIPS_URL_TEMPLATE.buildWithQuery(BoxGroup.this.getAPI().getBaseURL(), builder.toString(), BoxGroup.this.getID());
                return new BoxGroupMembershipIterator(BoxGroup.this.getAPI(), url);
            }
        };
    }

    public BoxGroupMembership.Info addMembership(BoxUser user) {
        return this.addMembership(user, (BoxGroupMembership.Role)null, null);
    }

    @Deprecated
    public BoxGroupMembership.Info addMembership(BoxUser user, BoxGroupMembership.Role role) {
        return this.addMembership(user, role, null);
    }

    public BoxGroupMembership.Info addMembership(BoxUser user, BoxGroupMembership.GroupRole role) {
        return this.addMembership(user, role, null);
    }

    @Deprecated
    public BoxGroupMembership.Info addMembership(BoxUser user, BoxGroupMembership.Role role, Map<BoxGroupMembership.Permission, Boolean> configurablePermissions) {
        BoxGroupMembership membership;
        BoxAPIConnection api = this.getAPI();
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("user", new JsonObject().add("id", user.getID()));
        requestJSON.add("group", new JsonObject().add("id", this.getID()));
        if (role != null) {
            requestJSON.add("role", role.toJSONString());
        }
        if (configurablePermissions != null) {
            JsonObject configurablePermissionJson = new JsonObject();
            for (BoxGroupMembership.Permission attrKey : configurablePermissions.keySet()) {
                configurablePermissionJson.set(attrKey.toJSONValue(), configurablePermissions.get((Object)attrKey));
            }
            requestJSON.add("configurable_permissions", configurablePermissionJson);
        }
        URL url = ADD_MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, responseJSON.get("id").asString());
        boxGroupMembership.getClass();
        return new BoxGroupMembership.Info(boxGroupMembership, responseJSON);
    }

    public BoxGroupMembership.Info addMembership(BoxUser user, BoxGroupMembership.GroupRole role, Map<BoxGroupMembership.Permission, Boolean> configurablePermissions) {
        BoxGroupMembership membership;
        BoxAPIConnection api = this.getAPI();
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("user", new JsonObject().add("id", user.getID()));
        requestJSON.add("group", new JsonObject().add("id", this.getID()));
        if (role != null) {
            requestJSON.add("role", role.toJSONString());
        }
        if (configurablePermissions != null) {
            JsonObject configurablePermissionJson = new JsonObject();
            for (BoxGroupMembership.Permission attrKey : configurablePermissions.keySet()) {
                configurablePermissionJson.set(attrKey.toJSONValue(), configurablePermissions.get((Object)attrKey));
            }
            requestJSON.add("configurable_permissions", configurablePermissionJson);
        }
        URL url = ADD_MEMBERSHIP_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, responseJSON.get("id").asString());
        boxGroupMembership.getClass();
        return new BoxGroupMembership.Info(boxGroupMembership, responseJSON);
    }

    public Collection<BoxCollaboration.Info> getCollaborations() {
        BoxAPIConnection api = this.getAPI();
        URL url = COLLABORATIONS_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxCollaboration.Info> collaborations = new ArrayList<BoxCollaboration.Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxCollaboration collaboration;
            JsonObject entryObject = entry.asObject();
            BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, entryObject.get("id").asString());
            boxCollaboration.getClass();
            BoxCollaboration.Info info = boxCollaboration.new BoxCollaboration.Info(entryObject);
            collaborations.add(info);
        }
        return collaborations;
    }

    public Iterable<BoxCollaboration.Info> getAllCollaborations(String ... fields) {
        final BoxAPIConnection api = this.getAPI();
        final QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new Iterable<BoxCollaboration.Info>(){

            @Override
            public Iterator<BoxCollaboration.Info> iterator() {
                URL url = COLLABORATIONS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), BoxGroup.this.getID());
                return new BoxCollaborationIterator(api, url);
            }
        };
    }

    public void delete() {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public void updateInfo(Info info) {
        URL url = GROUP_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        info.update(jsonObject);
    }

    public class Info
    extends BoxCollaborator.Info {
        private String provenance;
        private String externalSyncIdentifier;
        private String description;
        private String invitabilityLevel;
        private String memberViewabilityLevel;

        public Info() {
            super(BoxGroup.this);
        }

        public Info(String json) {
            super((BoxCollaborator)BoxGroup.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxCollaborator)BoxGroup.this, jsonObject);
        }

        @Override
        public BoxGroup getResource() {
            return BoxGroup.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("description")) {
                    this.description = value.asString();
                } else if (memberName.equals("external_sync_identifier")) {
                    this.externalSyncIdentifier = value.asString();
                } else if (memberName.equals("invitability_level")) {
                    this.invitabilityLevel = value.asString();
                } else if (memberName.equals("member_viewability_level")) {
                    this.memberViewabilityLevel = value.asString();
                } else if (memberName.equals("provenance")) {
                    this.provenance = value.asString();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
            this.addPendingChange("description", description);
        }

        public String getExternalSyncIdentifier() {
            return this.externalSyncIdentifier;
        }

        public void setExternalSyncIdentifier(String externalSyncIdentifier) {
            this.externalSyncIdentifier = externalSyncIdentifier;
            this.addPendingChange("external_sync_identifier", externalSyncIdentifier);
        }

        public String getInvitabilityLevel() {
            return this.invitabilityLevel;
        }

        public void setInvitabilityLevel(String invitabilityLevel) {
            this.invitabilityLevel = invitabilityLevel;
            this.addPendingChange("invitability_level", invitabilityLevel);
        }

        public String getMemberViewabilityLevel() {
            return this.memberViewabilityLevel;
        }

        public void setMemberViewabilityLevel(String memberViewabilityLevel) {
            this.memberViewabilityLevel = memberViewabilityLevel;
            this.addPendingChange("member_viewability_level", memberViewabilityLevel);
        }

        public String getProvenance() {
            return this.provenance;
        }

        public void setProvenance(String provenance) {
            this.provenance = provenance;
            this.addPendingChange("provenance", provenance);
        }
    }
}

