/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxEnterprise;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUser;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.Date;

@BoxResourceType(value="invite")
public class BoxInvite
extends BoxResource {
    public static final URLTemplate INVITE_CREATION_URL_TEMPLATE = new URLTemplate("invites");
    public static final URLTemplate INVITE_URL_TEMPLATE = new URLTemplate("invites/%s");

    public BoxInvite(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info inviteUserToEnterprise(BoxAPIConnection api, String userLogin, String enterpriseID) {
        BoxInvite invite;
        URL url = INVITE_CREATION_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        JsonObject body = new JsonObject();
        JsonObject enterprise = new JsonObject();
        enterprise.add("id", enterpriseID);
        body.add("enterprise", enterprise);
        JsonObject actionableBy = new JsonObject();
        actionableBy.add("login", userLogin);
        body.add("actionable_by", actionableBy);
        request.setBody(body);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxInvite boxInvite = invite = new BoxInvite(api, responseJSON.get("id").asString());
        boxInvite.getClass();
        return boxInvite.new Info(responseJSON);
    }

    public Info getInfo() {
        BoxAPIConnection api = this.getAPI();
        URL url = INVITE_URL_TEMPLATE.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom(response.getJSON());
        return new Info(jsonObject);
    }

    public class Info
    extends BoxResource.Info {
        private BoxEnterprise invitedTo;
        private BoxUser.Info actionableBy;
        private BoxUser.Info invitedBy;
        private Date createdAt;
        private Date modifiedAt;
        private String status;

        public Info() {
            super(BoxInvite.this);
        }

        public Info(String json) {
            super((BoxResource)BoxInvite.this, json);
        }

        Info(JsonObject jsonObject) {
            super((BoxResource)BoxInvite.this, jsonObject);
        }

        public BoxEnterprise getInvitedTo() {
            return this.invitedTo;
        }

        public BoxUser.Info getActionableBy() {
            return this.actionableBy;
        }

        public BoxUser.Info getInvitedBy() {
            return this.invitedBy;
        }

        public String getStatus() {
            return this.status;
        }

        public Date getCreatedAt() {
            return this.createdAt;
        }

        public Date getModifiedAt() {
            return this.modifiedAt;
        }

        @Override
        public BoxInvite getResource() {
            return BoxInvite.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("invited_to")) {
                    BoxEnterprise enterprise;
                    JsonObject enterpriseJSON = value.asObject();
                    this.invitedTo = enterprise = new BoxEnterprise(enterpriseJSON);
                } else if (memberName.equals("actionable_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.actionableBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxInvite.this.getAPI(), userID);
                        boxUser.getClass();
                        this.actionableBy = new BoxUser.Info(boxUser, userJSON);
                    } else {
                        this.actionableBy.update(userJSON);
                    }
                } else if (memberName.equals("invited_by")) {
                    JsonObject userJSON = value.asObject();
                    if (this.invitedBy == null) {
                        BoxUser user;
                        String userID = userJSON.get("id").asString();
                        BoxUser boxUser = user = new BoxUser(BoxInvite.this.getAPI(), userID);
                        boxUser.getClass();
                        this.invitedBy = new BoxUser.Info(boxUser, userJSON);
                    } else {
                        this.invitedBy.update(userJSON);
                    }
                } else if (memberName.equals("status")) {
                    this.status = value.asString();
                } else if (memberName.equals("created_at")) {
                    this.createdAt = BoxDateFormat.parse(value.asString());
                } else if (memberName.equals("modified_at")) {
                    this.modifiedAt = BoxDateFormat.parse(value.asString());
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

