/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxDeserializationException;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.http.HttpMethod;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;

@BoxResourceType(value="storage_policy_assignment")
public class BoxStoragePolicyAssignment
extends BoxResource {
    public static final URLTemplate STORAGE_POLICY_ASSIGNMENT_URL_TEMPLATE = new URLTemplate("storage_policy_assignments");
    public static final URLTemplate STORAGE_POLICY_ASSIGNMENT_WITH_ID_URL_TEMPLATE = new URLTemplate("storage_policy_assignments/%s");

    public BoxStoragePolicyAssignment(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info create(BoxAPIConnection api, String policyID, String userID) {
        BoxStoragePolicyAssignment storagePolicyAssignment;
        URL url = STORAGE_POLICY_ASSIGNMENT_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, HttpMethod.POST);
        JsonObject requestJSON = new JsonObject().add("storage_policy", new JsonObject().add("type", "storage_policy").add("id", policyID)).add("assigned_to", new JsonObject().add("type", "user").add("id", userID));
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        BoxStoragePolicyAssignment boxStoragePolicyAssignment = storagePolicyAssignment = new BoxStoragePolicyAssignment(api, responseJSON.get("id").asString());
        boxStoragePolicyAssignment.getClass();
        return boxStoragePolicyAssignment.new Info(responseJSON);
    }

    public static Info getAssignmentForTarget(BoxAPIConnection api, String resolvedForType, String resolvedForID) {
        BoxStoragePolicyAssignment storagePolicyAssignment;
        QueryStringBuilder builder = new QueryStringBuilder();
        builder.appendParam("resolved_for_type", resolvedForType).appendParam("resolved_for_id", resolvedForID);
        URL url = STORAGE_POLICY_ASSIGNMENT_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(api, url, HttpMethod.GET);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        BoxStoragePolicyAssignment boxStoragePolicyAssignment = storagePolicyAssignment = new BoxStoragePolicyAssignment(api, response.getJsonObject().get("entries").asArray().get(0).asObject().get("id").asString());
        boxStoragePolicyAssignment.getClass();
        Info info = boxStoragePolicyAssignment.new Info(response.getJsonObject().get("entries").asArray().get(0).asObject());
        return info;
    }

    public static Info assign(BoxAPIConnection api, String storagePolicyID, String userID) {
        Info assignmentInfo = null;
        assignmentInfo = BoxStoragePolicyAssignment.getAssignmentForTarget(api, "user", userID);
        if (assignmentInfo.getStoragePolicyID().equals(storagePolicyID)) {
            return assignmentInfo;
        }
        if (assignmentInfo.getAssignedToType().equals("enterprise")) {
            return BoxStoragePolicyAssignment.create(api, storagePolicyID, userID);
        }
        assignmentInfo.setStoragePolicyID(storagePolicyID);
        BoxStoragePolicyAssignment assignment = new BoxStoragePolicyAssignment(api, assignmentInfo.getID());
        assignment.updateInfo(assignmentInfo);
        return assignmentInfo;
    }

    public void updateInfo(Info info) {
        URL url = STORAGE_POLICY_ASSIGNMENT_WITH_ID_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom(response.getJSON());
        info.update(responseJSON);
    }

    public Info getInfo() {
        URL url = STORAGE_POLICY_ASSIGNMENT_WITH_ID_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, HttpMethod.GET);
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(JsonObject.readFrom(response.getJSON()));
    }

    public void delete() {
        URL url = STORAGE_POLICY_ASSIGNMENT_WITH_ID_URL_TEMPLATE.buildAlpha(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, HttpMethod.DELETE);
        request.send();
    }

    public class Info
    extends BoxResource.Info {
        private String storagePolicyID;
        private String storagePolicyType;
        private String assignedToID;
        private String assignedToType;

        public Info() {
        }

        public Info(String json) {
            super(json);
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxResource getResource() {
            return BoxStoragePolicyAssignment.this;
        }

        public String getAssignedToType() {
            return this.assignedToType;
        }

        public String getAssignedToID() {
            return this.assignedToID;
        }

        public String getStoragePolicyID() {
            return this.storagePolicyID;
        }

        public void setStoragePolicyID(String storagePolicyID) {
            this.storagePolicyID = storagePolicyID;
            JsonObject storagePolicyObject = new JsonObject();
            storagePolicyObject.add("type", "storage_policy");
            storagePolicyObject.add("id", storagePolicyID);
            this.addPendingChange("storage_policy", storagePolicyObject);
        }

        public String getStoragePolicyType() {
            return this.storagePolicyType;
        }

        @Override
        void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            try {
                if (memberName.equals("assigned_to")) {
                    JsonObject assignmentJSON = value.asObject();
                    this.assignedToType = assignmentJSON.get("type").asString();
                    this.assignedToID = assignmentJSON.get("id").asString();
                } else if (memberName.equals("storage_policy")) {
                    JsonObject storagePolicyJSON = value.asObject();
                    this.storagePolicyID = storagePolicyJSON.get("id").asString();
                    this.storagePolicyType = storagePolicyJSON.get("type").asString();
                }
            }
            catch (Exception e) {
                throw new BoxDeserializationException(memberName, value.toString(), e);
            }
        }
    }
}

