/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.FileUploadParams;
import com.box.sdk.Metadata;
import com.box.sdk.ProgressListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxFilesManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxFilesManager.class);
    private BoxAPIConnection boxConnection;

    public BoxFilesManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public BoxFile.Info getFileInfo(String fileId, String ... fields) {
        try {
            LOG.debug("Getting info for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (fields == null || fields.length == 0) {
                return file.getInfo();
            }
            return file.getInfo(fields);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile updateFileInfo(String fileId, BoxFile.Info info) {
        try {
            LOG.debug("Updating info for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (info == null) {
                throw new IllegalArgumentException("Parameter 'info' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            file.updateInfo(info);
            return file;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile uploadFile(String parentFolderId, InputStream content, String fileName, Date created, Date modified, Long size, Boolean check, ProgressListener listener) {
        try {
            LOG.debug("Uploading file with name '{}}' to parent_folder(id={}})", (Object)fileName, (Object)parentFolderId);
            if (parentFolderId == null) {
                throw new IllegalArgumentException("Parameter 'parentFolderId' can not be null");
            }
            if (content == null) {
                throw new IllegalArgumentException("Parameter 'content' can not be null");
            }
            if (fileName == null) {
                throw new IllegalArgumentException("Parameter 'fileName' can not be null");
            }
            BoxFile boxFile = null;
            boolean uploadNewFile = true;
            if (check != null && check.booleanValue()) {
                BoxFolder folder = null;
                try {
                    folder = new BoxFolder(this.boxConnection, parentFolderId);
                    folder.canUpload(fileName, 0L);
                }
                catch (BoxAPIResponseException boxException) {
                    if (409 == boxException.getResponseCode()) {
                        long end;
                        long elapsed;
                        long init = System.currentTimeMillis();
                        int delayLimit = 5;
                        boolean exists = false;
                        BoxResource.Info existingFile = null;
                        if (folder != null) {
                            for (BoxItem.Info itemInfo : folder.getChildren("name", BoxFolder.SortDirection.ASC, "name", "type")) {
                                exists = "file".equals(itemInfo.getType()) && fileName.equals(itemInfo.getName());
                                if (!exists) continue;
                                existingFile = itemInfo;
                                break;
                            }
                        }
                        if ((elapsed = ((end = System.currentTimeMillis()) - init) / 1000L) > (long)delayLimit) {
                            LOG.warn("The upload operation, checks if the file exists by using the Box list folder, however it took {} seconds to verify, try to reduce the size of the folder items for faster results.", (Object)elapsed);
                        }
                        if (exists) {
                            boxFile = this.uploadNewFileVersion(existingFile.getID(), content, modified, size, listener);
                            uploadNewFile = false;
                        }
                    }
                    throw boxException;
                }
            }
            if (uploadNewFile) {
                BoxFolder parentFolder = new BoxFolder(this.boxConnection, parentFolderId);
                FileUploadParams uploadParams = new FileUploadParams();
                uploadParams.setName(fileName);
                uploadParams.setContent(content);
                if (created != null) {
                    uploadParams.setCreated(created);
                }
                if (modified != null) {
                    uploadParams.setModified(modified);
                }
                if (size != null) {
                    uploadParams.setSize(size);
                }
                if (listener != null) {
                    uploadParams.setProgressListener(listener);
                }
                boxFile = parentFolder.uploadFile(uploadParams).getResource();
            }
            return boxFile;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile uploadNewFileVersion(String fileId, InputStream fileContent, Date modified, Long fileSize, ProgressListener listener) {
        try {
            LOG.debug("Uploading new version of file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (fileContent == null) {
                throw new IllegalArgumentException("Parameter 'fileContent' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (modified != null) {
                if (fileSize != null) {
                    file.uploadNewVersion(fileContent, modified, fileSize, listener);
                } else {
                    file.uploadNewVersion(fileContent, modified, 0L, listener);
                }
            } else {
                file.uploadNewVersion(fileContent);
            }
            return file;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Collection<BoxFileVersion> getFileVersions(String fileId) {
        try {
            LOG.debug("Getting versions of file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getVersions();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public OutputStream downloadFile(String fileId, OutputStream output, Long rangeStart, Long rangeEnd, ProgressListener listener) {
        try {
            LOG.debug("Downloading file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (output == null) {
                throw new IllegalArgumentException("Parameter 'output' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (listener != null) {
                if (rangeStart != null && rangeEnd != null) {
                    file.downloadRange(output, rangeStart, rangeEnd, listener);
                } else {
                    file.download(output, listener);
                }
            } else if (rangeStart != null && rangeEnd != null) {
                file.downloadRange(output, rangeStart, rangeEnd);
            } else {
                file.download(output);
            }
            return output;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public OutputStream downloadPreviousFileVersion(String fileId, Integer version, OutputStream output, ProgressListener listener) {
        try {
            LOG.debug("Downloading file(id={}, version={})", (Object)fileId, (Object)version);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Parameter 'version' can not be null");
            }
            if (output == null) {
                throw new IllegalArgumentException("Parameter 'output' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            List fileVersions = (List)file.getVersions();
            BoxFileVersion fileVersion = (BoxFileVersion)fileVersions.get(version);
            if (listener != null) {
                fileVersion.download(output, listener);
            } else {
                fileVersion.download(output);
            }
            return output;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFileVersion promoteFileVersion(String fileId, Integer version) {
        try {
            LOG.debug("Promoting file(id={}, version={})", (Object)fileId, (Object)version);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Parameter 'version' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            List fileVersions = (List)file.getVersions();
            BoxFileVersion fileVersion = (BoxFileVersion)fileVersions.get(version);
            fileVersion.promote();
            return fileVersion;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile copyFile(String fileId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Copying file(id={}) to destination_folder(id={}) {}", new Object[]{fileId, destinationFolderId, newName == null ? "" : " with new name '" + newName + "'"});
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (destinationFolderId == null) {
                throw new IllegalArgumentException("Parameter 'destinationFolderId' can not be null");
            }
            BoxFile fileToCopy = new BoxFile(this.boxConnection, fileId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return fileToCopy.copy(destinationFolder).getResource();
            }
            return fileToCopy.copy(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile moveFile(String fileId, String destinationFolderId, String newName) {
        try {
            LOG.debug("Moving file(id={}) to destination_folder(id={}) {}", new Object[]{fileId, destinationFolderId, newName == null ? "" : " with new name '" + newName + "'"});
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (destinationFolderId == null) {
                throw new IllegalArgumentException("Parameter 'destinationFolderId' can not be null");
            }
            BoxFile fileToMove = new BoxFile(this.boxConnection, fileId);
            BoxFolder destinationFolder = new BoxFolder(this.boxConnection, destinationFolderId);
            if (newName == null) {
                return (BoxFile)fileToMove.move(destinationFolder).getResource();
            }
            return (BoxFile)fileToMove.move(destinationFolder, newName).getResource();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxFile renameFile(String fileId, String newFileName) {
        try {
            LOG.debug("Renaming file(id={}) to '{}'", (Object)fileId, (Object)newFileName);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (newFileName == null) {
                throw new IllegalArgumentException("Parameter 'newName' can not be null");
            }
            BoxFile fileToRename = new BoxFile(this.boxConnection, fileId);
            fileToRename.rename(newFileName);
            return fileToRename;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteFile(String fileId) {
        try {
            LOG.debug("Deleting file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            file.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteFileVersion(String fileId, Integer version) {
        try {
            LOG.debug("Deleting file(id={}, version={})", (Object)fileId, (Object)version);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (version == null) {
                throw new IllegalArgumentException("Parameter 'version' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            List versions = (List)file.getVersions();
            BoxFileVersion fileVersion = (BoxFileVersion)versions.get(version);
            fileVersion.delete();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public BoxSharedLink createFileSharedLink(String fileId, BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions) {
        try {
            LOG.debug("Creating shared link for file(id={}) with access={} {}", new Object[]{fileId, access, unshareDate == null ? "" : " unsharedDate=" + DateFormat.getDateTimeInstance().format(unshareDate) + " permissions=" + permissions});
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (access == null) {
                throw new IllegalArgumentException("Parameter 'access' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.createSharedLink(access, unshareDate, permissions);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public URL getDownloadURL(String fileId) {
        try {
            LOG.debug("Getting download URL for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getDownloadURL();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public URL getFilePreviewLink(String fileId) {
        try {
            LOG.debug("Getting preview link for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getPreviewLink();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public byte[] getFileThumbnail(String fileId, BoxFile.ThumbnailFileType fileType, Integer minWidth, Integer minHeight, Integer maxWidth, Integer maxHeight) {
        try {
            LOG.debug("Getting thumbnail for file(id={}) fileType={} minWidth={} minHeight={} maxWidth={} maxHeight={}", new Object[]{fileId, fileType, minWidth, minHeight, maxWidth, maxHeight});
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (fileType == null) {
                throw new IllegalArgumentException("Parameter 'fileType' can not be null");
            }
            if (minWidth == null) {
                throw new IllegalArgumentException("Parameter 'minWidth' can not be null");
            }
            if (minHeight == null) {
                throw new IllegalArgumentException("Parameter 'minHeight' can not be null");
            }
            if (maxWidth == null) {
                throw new IllegalArgumentException("Parameter 'maxWidth' can not be null");
            }
            if (maxHeight == null) {
                throw new IllegalArgumentException("Parameter 'maxHeight' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.getThumbnail(fileType, minWidth, minHeight, maxWidth, maxHeight);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Metadata createFileMetadata(String fileId, Metadata metadata, String typeName) {
        try {
            LOG.debug("Creating metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (metadata == null) {
                throw new IllegalArgumentException("Parameter 'metadata' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (typeName != null) {
                return file.createMetadata(typeName, metadata);
            }
            return file.createMetadata(metadata);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Metadata getFileMetadata(String fileId, String typeName) {
        try {
            LOG.debug("Get metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            if (typeName != null) {
                return file.getMetadata(typeName);
            }
            return file.getMetadata();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public Metadata updateFileMetadata(String fileId, Metadata metadata) {
        try {
            LOG.debug("Updating metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            if (metadata == null) {
                throw new IllegalArgumentException("Parameter 'metadata' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            return file.updateMetadata(metadata);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void deleteFileMetadata(String fileId) {
        try {
            LOG.debug("Deleting metadata for file(id={})", (Object)fileId);
            if (fileId == null) {
                throw new IllegalArgumentException("Parameter 'fileId' can not be null");
            }
            BoxFile file = new BoxFile(this.boxConnection, fileId);
            file.deleteMetadata();
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }

    public void checkUpload(String fileName, String parentFolderId, Long size) {
        try {
            LOG.debug("Preflight check file with name '{}' to parent_folder(id={})", (Object)fileName, (Object)parentFolderId);
            if (parentFolderId == null) {
                throw new IllegalArgumentException("Parameter 'parentFolderId' can not be null");
            }
            if (fileName == null) {
                throw new IllegalArgumentException("Parameter 'fileName' can not be null");
            }
            if (size == null) {
                throw new IllegalArgumentException("Parameter 'size' can not be null");
            }
            BoxFolder parentFolder = new BoxFolder(this.boxConnection, parentFolderId);
            parentFolder.canUpload(fileName, size);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

