/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.api;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxSearch;
import com.box.sdk.BoxSearchParameters;
import com.box.sdk.PartialCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxSearchManager {
    private static final Logger LOG = LoggerFactory.getLogger(BoxSearchManager.class);
    private static final int SEARCH_MAX_LIMIT = 200;
    private BoxAPIConnection boxConnection;

    public BoxSearchManager(BoxAPIConnection boxConnection) {
        this.boxConnection = boxConnection;
    }

    public Collection<BoxItem> searchFolder(String folderId, String query) {
        try {
            PartialCollection<BoxItem.Info> partialResult;
            LOG.debug("Searching folder(id={}) with query={}", (Object)folderId, (Object)query);
            if (folderId == null) {
                throw new IllegalArgumentException("Parameter 'folderId' can not be null");
            }
            if (query == null) {
                throw new IllegalArgumentException("Parameter 'query' can not be null");
            }
            BoxSearchParameters bsp = new BoxSearchParameters();
            bsp.setAncestorFolderIds(Collections.singletonList(folderId));
            bsp.setQuery(query);
            LinkedList<BoxItem> result = new LinkedList<BoxItem>();
            BoxSearch bs = new BoxSearch(this.boxConnection);
            int offset = 0;
            do {
                partialResult = bs.searchRange(offset, 200L, bsp);
                offset += partialResult.size();
                partialResult.stream().map(i -> (BoxItem)i.getResource()).forEachOrdered(result::add);
            } while ((long)partialResult.size() == partialResult.limit());
            return result;
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API returned the error code %d%n%n%s", e.getResponseCode(), e.getResponse()), e);
        }
    }
}

