/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileVersion;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.Metadata;
import com.box.sdk.ProgressListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.camel.component.box.api.BoxFilesManager;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

public enum BoxFilesManagerApiMethod implements ApiMethod
{
    CHECK_UPLOAD(Void.TYPE, "checkUpload", ApiMethodArg.arg("fileName", String.class), ApiMethodArg.arg("parentFolderId", String.class), ApiMethodArg.arg("size", Long.class)),
    COPY_FILE(BoxFile.class, "copyFile", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("destinationFolderId", String.class), ApiMethodArg.arg("newName", String.class)),
    CREATE_FILE_METADATA(Metadata.class, "createFileMetadata", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("metadata", Metadata.class), ApiMethodArg.arg("typeName", String.class)),
    CREATE_FILE_SHARED_LINK(BoxSharedLink.class, "createFileSharedLink", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("access", BoxSharedLink.Access.class), ApiMethodArg.arg("unshareDate", Date.class), ApiMethodArg.arg("permissions", BoxSharedLink.Permissions.class)),
    DELETE_FILE(Void.TYPE, "deleteFile", ApiMethodArg.arg("fileId", String.class)),
    DELETE_FILE_METADATA(Void.TYPE, "deleteFileMetadata", ApiMethodArg.arg("fileId", String.class)),
    DELETE_FILE_VERSION(Void.TYPE, "deleteFileVersion", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("version", Integer.class)),
    DOWNLOAD_FILE(OutputStream.class, "downloadFile", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("output", OutputStream.class), ApiMethodArg.arg("rangeStart", Long.class), ApiMethodArg.arg("rangeEnd", Long.class), ApiMethodArg.arg("listener", ProgressListener.class)),
    DOWNLOAD_PREVIOUS_FILE_VERSION(OutputStream.class, "downloadPreviousFileVersion", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("version", Integer.class), ApiMethodArg.arg("output", OutputStream.class), ApiMethodArg.arg("listener", ProgressListener.class)),
    GET_DOWNLOAD_URL(URL.class, "getDownloadURL", ApiMethodArg.arg("fileId", String.class)),
    GET_FILE_INFO(BoxFile.Info.class, "getFileInfo", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("fields", new String[0].getClass())),
    GET_FILE_METADATA(Metadata.class, "getFileMetadata", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("typeName", String.class)),
    GET_FILE_PREVIEW_LINK(URL.class, "getFilePreviewLink", ApiMethodArg.arg("fileId", String.class)),
    GET_FILE_THUMBNAIL(byte[].class, "getFileThumbnail", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("fileType", BoxFile.ThumbnailFileType.class), ApiMethodArg.arg("minWidth", Integer.class), ApiMethodArg.arg("minHeight", Integer.class), ApiMethodArg.arg("maxWidth", Integer.class), ApiMethodArg.arg("maxHeight", Integer.class)),
    GET_FILE_VERSIONS(Collection.class, "getFileVersions", ApiMethodArg.arg("fileId", String.class)),
    MOVE_FILE(BoxFile.class, "moveFile", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("destinationFolderId", String.class), ApiMethodArg.arg("newName", String.class)),
    PROMOTE_FILE_VERSION(BoxFileVersion.class, "promoteFileVersion", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("version", Integer.class)),
    RENAME_FILE(BoxFile.class, "renameFile", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("newFileName", String.class)),
    UPDATE_FILE_INFO(BoxFile.class, "updateFileInfo", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("info", BoxFile.Info.class)),
    UPDATE_FILE_METADATA(Metadata.class, "updateFileMetadata", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("metadata", Metadata.class)),
    UPLOAD_FILE(BoxFile.class, "uploadFile", ApiMethodArg.arg("parentFolderId", String.class), ApiMethodArg.arg("content", InputStream.class), ApiMethodArg.arg("fileName", String.class), ApiMethodArg.arg("created", Date.class), ApiMethodArg.arg("modified", Date.class), ApiMethodArg.arg("size", Long.class), ApiMethodArg.arg("check", Boolean.class), ApiMethodArg.arg("listener", ProgressListener.class)),
    UPLOAD_NEW_FILE_VERSION(BoxFile.class, "uploadNewFileVersion", ApiMethodArg.arg("fileId", String.class), ApiMethodArg.arg("fileContent", InputStream.class), ApiMethodArg.arg("modified", Date.class), ApiMethodArg.arg("fileSize", Long.class), ApiMethodArg.arg("listener", ProgressListener.class));

    private final ApiMethod apiMethod;

    private BoxFilesManagerApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(BoxFilesManager.class, resultType, name, args);
    }

    @Override
    public String getName() {
        return this.apiMethod.getName();
    }

    @Override
    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    @Override
    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    @Override
    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    @Override
    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

