/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import java.io.InputStream;
import java.net.URL;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;

final class EHCacheUtil {
    private static boolean useCreateNewMethod;

    private EHCacheUtil() {
    }

    static CacheManager createCacheManager() throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance();
        }
        return CacheManager.create();
    }

    static CacheManager createCacheManager(String configurationFileName) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance(configurationFileName);
        }
        return CacheManager.create(configurationFileName);
    }

    static CacheManager createCacheManager(URL configurationFileURL) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance(configurationFileURL);
        }
        return CacheManager.create(configurationFileURL);
    }

    static CacheManager createCacheManager(InputStream inputStream) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance(inputStream);
        }
        return CacheManager.create(inputStream);
    }

    static CacheManager createCacheManager(Configuration conf) throws CacheException {
        if (useCreateNewMethod) {
            return CacheManager.newInstance(conf);
        }
        return CacheManager.create(conf);
    }

    static {
        try {
            CacheManager.class.getMethod("newInstance", null);
            useCreateNewMethod = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

