/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.camel.Exchange;
import org.apache.camel.component.cache.CacheConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEventListener
implements net.sf.ehcache.event.CacheEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(CacheEventListener.class);
    CacheConsumer cacheConsumer;

    public CacheEventListener() {
    }

    public CacheEventListener(CacheConsumer cacheConsumer) {
        this.cacheConsumer = cacheConsumer;
    }

    @Override
    public void notifyElementEvicted(Ehcache cache, Element element) {
        LOG.debug("Element {} is being evicted from cache {}", (Object)element, (Object)cache.getName());
    }

    @Override
    public void notifyElementExpired(Ehcache cache, Element element) {
        LOG.debug("Element {} has expired in cache {}", (Object)element, (Object)cache.getName());
    }

    @Override
    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        LOG.debug("Element {} has just been added/put in cache {}", (Object)element, (Object)cache.getName());
        this.dispatchExchange(cache, element, "ADD");
    }

    @Override
    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        LOG.debug("Element {} has just been removed from cache {}", (Object)element, (Object)cache.getName());
        this.dispatchExchange(cache, element, "DELETE");
    }

    @Override
    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        LOG.debug("Element {} has just been updated in cache {}", (Object)element, (Object)cache.getName());
        this.dispatchExchange(cache, element, "UPDATE");
    }

    @Override
    public void notifyRemoveAll(Ehcache cache) {
        LOG.debug("Cache {} is being emptied and all elements removed", (Object)cache.getName());
        this.dispatchExchange(cache, null, "DELETEALL");
    }

    private void dispatchExchange(Ehcache cache, Element element, String operation) {
        LOG.debug("Consumer Dispatching the Exchange containing the Element {} in cache {}", (Object)element, (Object)cache.getName());
        Exchange exchange = element == null ? this.cacheConsumer.getEndpoint().createCacheExchange(operation, "", "") : this.cacheConsumer.getEndpoint().createCacheExchange(operation, (String)element.getObjectKey(), element.getObjectValue());
        try {
            this.cacheConsumer.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new CacheException("Error in consumer while dispatching exchange containing key " + (element != null ? element.getObjectKey() : null) + " for further processing", e);
        }
    }

    public CacheConsumer getCacheConsumer() {
        return this.cacheConsumer;
    }

    public void setCacheConsumer(CacheConsumer cacheConsumer) {
        this.cacheConsumer = cacheConsumer;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

