/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.EvictionType;
import org.apache.camel.util.ObjectHelper;

public final class CaffeineHelper {
    private CaffeineHelper() {
    }

    public static void defineBuilder(Caffeine<?, ?> builder, CaffeineConfiguration configuration) {
        if (configuration.getEvictionType() == EvictionType.SIZE_BASED) {
            if (configuration.getInitialCapacity() != null) {
                builder.initialCapacity(configuration.getInitialCapacity());
            }
            if (configuration.getMaximumSize() != null) {
                builder.maximumSize(configuration.getMaximumSize().intValue());
            }
        } else if (configuration.getEvictionType() == EvictionType.TIME_BASED) {
            builder.expireAfterAccess(configuration.getExpireAfterAccessTime(), TimeUnit.SECONDS);
            builder.expireAfterWrite(configuration.getExpireAfterWriteTime(), TimeUnit.SECONDS);
        }
        if (configuration.isStatsEnabled()) {
            if (ObjectHelper.isEmpty(configuration.getStatsCounter())) {
                builder.recordStats();
            } else {
                builder.recordStats(configuration::getStatsCounter);
            }
        }
        if (ObjectHelper.isNotEmpty(configuration.getRemovalListener())) {
            builder.removalListener(configuration.getRemovalListener());
        }
    }
}

