/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.load;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.CaffeineHelper;
import org.apache.camel.component.caffeine.load.CaffeineLoadCacheEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="caffeine-loadcache")
public class CaffeineLoadCacheComponent
extends DefaultComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaffeineLoadCacheComponent.class);
    private final Map<String, LoadingCache<?, ?>> caches = new ConcurrentHashMap();
    @Metadata(label="advanced")
    private CaffeineConfiguration configuration = new CaffeineConfiguration();

    public CaffeineLoadCacheComponent() {
    }

    public CaffeineLoadCacheComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CaffeineConfiguration configuration = this.configuration.copy();
        CaffeineLoadCacheEndpoint endpoint = new CaffeineLoadCacheEndpoint(uri, this, remaining, configuration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    protected LoadingCache<?, ?> getOrCreateCache(String name, CaffeineConfiguration configuration) {
        return this.caches.computeIfAbsent(name, key -> {
            Caffeine<Object, Object> builder = Caffeine.newBuilder();
            CaffeineHelper.defineBuilder(builder, configuration);
            return builder.build(configuration.getCacheLoader());
        });
    }

    public CaffeineConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CaffeineConfiguration configuration) {
        this.configuration = configuration;
    }
}

