/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.processor.idempotent;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.service.ServiceSupport;

@ManagedResource(description="Caffeine based message id repository")
public class CaffeineIdempotentRepository
extends ServiceSupport
implements IdempotentRepository {
    private String cacheName;
    private Cache<String, Boolean> cache;

    public CaffeineIdempotentRepository() {
        this(CaffeineIdempotentRepository.class.getSimpleName());
    }

    public CaffeineIdempotentRepository(String repositoryName) {
        this.cacheName = repositoryName;
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    @ManagedOperation(description="Adds the key to the store")
    public boolean add(String key) {
        if (this.cache.asMap().containsKey(key)) {
            return false;
        }
        this.cache.put(key, true);
        return true;
    }

    @Override
    public boolean confirm(String key) {
        return this.cache.asMap().containsKey(key);
    }

    @Override
    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(String key) {
        return this.cache.asMap().containsKey(key);
    }

    @Override
    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(String key) {
        this.cache.invalidate(key);
        return true;
    }

    @Override
    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.cache == null) {
            Caffeine<Object, Object> builder = Caffeine.newBuilder();
            this.cache = builder.build();
        }
    }

    protected Cache getCache() {
        return this.cache;
    }

    @Override
    protected void doStop() throws Exception {
    }
}

