/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.caffeine.resume;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.camel.resume.cache.ResumeCache;

public class CaffeineCache<K>
implements ResumeCache<K> {
    private final Cache<K, Object> cache;
    private final long cacheSize;

    public CaffeineCache(long cacheSize) {
        this(Caffeine.newBuilder().maximumSize(cacheSize).build(), cacheSize);
    }

    public CaffeineCache(Cache<K, Object> cache, long cacheSize) {
        this.cache = cache;
        this.cacheSize = cacheSize;
    }

    @Override
    public boolean contains(K key, Object entry) {
        assert (key != null);
        Object cachedEntry = this.cache.getIfPresent(key);
        return entry.equals(cachedEntry);
    }

    @Override
    public void add(K key, Object offsetValue) {
        this.cache.put(key, offsetValue);
    }

    @Override
    public Object get(K key) {
        Object entry = this.cache.getIfPresent(key);
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(entry);
    }

    @Override
    public <T> T get(K key, Class<T> clazz) {
        Object entry = this.cache.getIfPresent(key);
        if (entry != null) {
            return clazz.cast(entry);
        }
        return null;
    }

    @Override
    public Object computeIfAbsent(K key, Function<? super K, ? super Object> mapping) {
        Object entry = this.cache.getIfPresent(key);
        if (entry == null) {
            entry = mapping.apply(key);
            this.cache.put(key, entry);
        }
        return entry;
    }

    @Override
    public Object computeIfPresent(K key, BiFunction<? super K, ? super Object, ? super Object> remapping) {
        Object entry = this.cache.getIfPresent(key);
        if (entry != null) {
            entry = remapping.apply(key, entry);
            this.cache.put(key, entry);
        }
        return entry;
    }

    @Override
    public boolean isFull() {
        return this.cache.estimatedSize() >= this.cacheSize;
    }

    @Override
    public long capacity() {
        return this.cacheSize;
    }

    @Override
    public void forEach(BiFunction<? super K, ? super Object, Boolean> action) {
        ConcurrentMap<K, Object> kObjectConcurrentMap = this.cache.asMap();
        for (Map.Entry entry : kObjectConcurrentMap.entrySet()) {
            boolean invalidate = action.apply(entry.getKey(), entry.getValue());
            if (!invalidate) continue;
            this.cache.invalidate(entry.getKey());
        }
    }
}

