/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleJSONParser;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KeyspaceMetadata {
    public static final String KS_NAME = "keyspace_name";
    private static final String DURABLE_WRITES = "durable_writes";
    private static final String STRATEGY_CLASS = "strategy_class";
    private static final String STRATEGY_OPTIONS = "strategy_options";
    private final String name;
    private final boolean durableWrites;
    private final ReplicationStrategy strategy;
    private final Map<String, String> replication;
    private final Map<String, TableMetadata> tables = new ConcurrentHashMap<String, TableMetadata>();
    private final Map<String, UserType> userTypes = new ConcurrentHashMap<String, UserType>();

    private KeyspaceMetadata(String name, boolean durableWrites, Map<String, String> replication) {
        this.name = name;
        this.durableWrites = durableWrites;
        this.replication = replication;
        this.strategy = ReplicationStrategy.create(replication);
    }

    static KeyspaceMetadata build(Row row, List<Row> udtRows) {
        String name = row.getString(KS_NAME);
        boolean durableWrites = row.getBool(DURABLE_WRITES);
        HashMap<String, String> replicationOptions = new HashMap<String, String>();
        replicationOptions.put("class", row.getString(STRATEGY_CLASS));
        replicationOptions.putAll(SimpleJSONParser.parseStringMap(row.getString(STRATEGY_OPTIONS)));
        KeyspaceMetadata ksm = new KeyspaceMetadata(name, durableWrites, replicationOptions);
        if (udtRows == null) {
            return ksm;
        }
        ksm.addUserTypes(udtRows);
        return ksm;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDurableWrites() {
        return this.durableWrites;
    }

    public Map<String, String> getReplication() {
        return Collections.unmodifiableMap(this.replication);
    }

    public TableMetadata getTable(String name) {
        return this.tables.get(Metadata.handleId(name));
    }

    void removeTable(String table) {
        this.tables.remove(table);
    }

    public Collection<TableMetadata> getTables() {
        return Collections.unmodifiableCollection(this.tables.values());
    }

    public UserType getUserType(String name) {
        return this.userTypes.get(Metadata.handleId(name));
    }

    public Collection<UserType> getUserTypes() {
        return Collections.unmodifiableCollection(this.userTypes.values());
    }

    void addUserTypes(List<Row> udtRows) {
        for (Row r : udtRows) {
            UserType def = UserType.build(r);
            this.userTypes.put(def.getTypeName(), def);
        }
    }

    void removeUserType(String userType) {
        this.userTypes.remove(userType);
    }

    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.asCQLQuery()).append('\n');
        for (UserType udt : this.userTypes.values()) {
            sb.append('\n').append(udt.exportAsString()).append('\n');
        }
        for (TableMetadata tm : this.tables.values()) {
            sb.append('\n').append(tm.exportAsString()).append('\n');
        }
        return sb.toString();
    }

    public String asCQLQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE KEYSPACE ").append(Metadata.escapeId(this.name)).append(" WITH ");
        sb.append("REPLICATION = { 'class' : '").append(this.replication.get("class")).append('\'');
        for (Map.Entry<String, String> entry : this.replication.entrySet()) {
            if (entry.getKey().equals("class")) continue;
            sb.append(", '").append(entry.getKey()).append("': '").append(entry.getValue()).append('\'');
        }
        sb.append(" } AND DURABLE_WRITES = ").append(this.durableWrites);
        sb.append(';');
        return sb.toString();
    }

    public String toString() {
        return this.asCQLQuery();
    }

    void add(TableMetadata tm) {
        this.tables.put(tm.getName(), tm);
    }

    ReplicationStrategy replicationStrategy() {
        return this.strategy;
    }
}

