/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ReplicationStrategy;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metadata {
    private static final Logger logger = LoggerFactory.getLogger(Metadata.class);
    private final Cluster.Manager cluster;
    volatile String clusterName;
    volatile String partitioner;
    private final ConcurrentMap<InetSocketAddress, Host> hosts = new ConcurrentHashMap<InetSocketAddress, Host>();
    private final ConcurrentMap<String, KeyspaceMetadata> keyspaces = new ConcurrentHashMap<String, KeyspaceMetadata>();
    volatile TokenMap tokenMap;
    private static final Pattern cqlId = Pattern.compile("\\w+");
    private static final Pattern lowercaseId = Pattern.compile("[a-z][a-z0-9_]*");

    Metadata(Cluster.Manager cluster) {
        this.cluster = cluster;
    }

    synchronized void rebuildSchema(String keyspaceName, String tableName, String udtName, ResultSet ks, ResultSet udts, ResultSet cfs, ResultSet cols, VersionNumber cassandraVersion) {
        KeyspaceMetadata ksm;
        List<Row> l;
        String ksName;
        HashMap<String, ArrayList<Row>> cfDefs = new HashMap<String, ArrayList<Row>>();
        HashMap<String, ArrayList<Row>> udtDefs = new HashMap<String, ArrayList<Row>>();
        HashMap colsDefs = new HashMap();
        if (cfs != null) {
            for (Row row : cfs) {
                ksName = row.getString("keyspace_name");
                l = (ArrayList<Row>)cfDefs.get(ksName);
                if (l == null) {
                    l = new ArrayList<Row>();
                    cfDefs.put(ksName, (ArrayList<Row>)l);
                }
                l.add(row);
            }
        }
        if (udts != null) {
            for (Row row : udts) {
                ksName = row.getString("keyspace_name");
                l = (List)udtDefs.get(ksName);
                if (l == null) {
                    l = new ArrayList();
                    udtDefs.put(ksName, (ArrayList<Row>)l);
                }
                l.add(row);
            }
        }
        if (cols != null) {
            for (Row row : cols) {
                HashMap<String, ColumnMetadata.Raw> l2;
                ksName = row.getString("keyspace_name");
                String cfName = row.getString("columnfamily_name");
                HashMap colsByCf = (HashMap)colsDefs.get(ksName);
                if (colsByCf == null) {
                    colsByCf = new HashMap();
                    colsDefs.put(ksName, colsByCf);
                }
                if ((l2 = (HashMap<String, ColumnMetadata.Raw>)colsByCf.get(cfName)) == null) {
                    l2 = new HashMap<String, ColumnMetadata.Raw>();
                    colsByCf.put(cfName, l2);
                }
                ColumnMetadata.Raw c = ColumnMetadata.Raw.fromRow(row, cassandraVersion);
                l2.put(c.name, c);
            }
        }
        if (tableName == null && udtName == null) {
            assert (ks != null);
            HashSet<String> addedKs = new HashSet<String>();
            for (Row ksRow : ks) {
                String ksName2 = ksRow.getString("keyspace_name");
                KeyspaceMetadata ksm2 = KeyspaceMetadata.build(ksRow, (List)udtDefs.get(ksName2));
                if (cfDefs.containsKey(ksName2)) {
                    this.buildTableMetadata(ksm2, (List)cfDefs.get(ksName2), (Map)colsDefs.get(ksName2), cassandraVersion);
                }
                addedKs.add(ksName2);
                this.keyspaces.put(ksName2, ksm2);
            }
            if (keyspaceName == null) {
                Iterator iter = this.keyspaces.keySet().iterator();
                while (iter.hasNext()) {
                    if (addedKs.contains(iter.next())) continue;
                    iter.remove();
                }
            }
        } else if (tableName != null) {
            assert (keyspaceName != null);
            ksm = (KeyspaceMetadata)this.keyspaces.get(keyspaceName);
            if (ksm == null) {
                logger.error(String.format("Asked to rebuild table %s.%s but I don't know keyspace %s", keyspaceName, tableName, keyspaceName));
                this.cluster.submitSchemaRefresh(null, null, null);
                return;
            }
            if (cfDefs.containsKey(keyspaceName)) {
                this.buildTableMetadata(ksm, (List)cfDefs.get(keyspaceName), (Map)colsDefs.get(keyspaceName), cassandraVersion);
            }
        } else {
            assert (keyspaceName != null);
            ksm = (KeyspaceMetadata)this.keyspaces.get(keyspaceName);
            if (ksm == null) {
                logger.error(String.format("Asked to rebuild type %s.%s but I don't know keyspace %s", keyspaceName, udtName, keyspaceName));
                this.cluster.submitSchemaRefresh(null, null, null);
                return;
            }
            if (udtDefs.containsKey(keyspaceName)) {
                ksm.addUserTypes((List)udtDefs.get(keyspaceName));
            }
        }
    }

    private void buildTableMetadata(KeyspaceMetadata ksm, List<Row> cfRows, Map<String, Map<String, ColumnMetadata.Raw>> colsDefs, VersionNumber cassandraVersion) {
        for (Row cfRow : cfRows) {
            String cfName = cfRow.getString("columnfamily_name");
            try {
                Map<String, ColumnMetadata.Raw> cols;
                Map<String, ColumnMetadata.Raw> map = cols = colsDefs == null ? null : colsDefs.get(cfName);
                if (cols == null || cols.isEmpty()) {
                    if (cassandraVersion.getMajor() >= 2) continue;
                    cols = Collections.emptyMap();
                }
                TableMetadata.build(ksm, cfRow, cols, cassandraVersion);
            }
            catch (RuntimeException e) {
                logger.error(String.format("Error parsing schema for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\") will be missing or incomplete", ksm.getName(), cfName, ksm.getName(), cfName), (Throwable)e);
            }
        }
    }

    synchronized void rebuildTokenMap(String partitioner, Map<Host, Collection<String>> allTokens) {
        Token.Factory factory;
        if (allTokens.isEmpty()) {
            return;
        }
        Object object = partitioner == null ? (this.tokenMap == null ? null : this.tokenMap.factory) : (factory = Token.getFactory(partitioner));
        if (factory == null) {
            return;
        }
        this.tokenMap = TokenMap.build(factory, allTokens, this.keyspaces.values());
    }

    Host add(InetSocketAddress address) {
        Host newHost = new Host(address, this.cluster.convictionPolicyFactory, this.cluster);
        Host previous = this.hosts.putIfAbsent(address, newHost);
        return previous == null ? newHost : null;
    }

    boolean remove(Host host) {
        return this.hosts.remove(host.getSocketAddress()) != null;
    }

    Host getHost(InetSocketAddress address) {
        return (Host)this.hosts.get(address);
    }

    Collection<Host> allHosts() {
        return this.hosts.values();
    }

    static String handleId(String id) {
        if (id == null) {
            return null;
        }
        if (cqlId.matcher(id).matches()) {
            return id.toLowerCase();
        }
        if (id.charAt(0) == '\"' && id.charAt(id.length() - 1) == '\"') {
            return id.substring(1, id.length() - 1);
        }
        return id;
    }

    static String escapeId(String ident) {
        return lowercaseId.matcher(ident).matches() ? ident : Metadata.quote(ident);
    }

    public static String quote(String id) {
        return '\"' + id + '\"';
    }

    public Set<TokenRange> getTokenRanges() {
        TokenMap current = this.tokenMap;
        return current == null ? Collections.emptySet() : current.tokenRanges;
    }

    public Set<TokenRange> getTokenRanges(String keyspace, Host host) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Map dcRanges = (Map)current.hostsToRanges.get(keyspace);
        if (dcRanges == null) {
            return Collections.emptySet();
        }
        Set ranges = (Set)dcRanges.get(host);
        return ranges == null ? Collections.emptySet() : ranges;
    }

    public Set<Host> getReplicas(String keyspace, ByteBuffer partitionKey) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Set hosts = current.getReplicas(keyspace, current.factory.hash(partitionKey));
        return hosts == null ? Collections.emptySet() : hosts;
    }

    public Set<Host> getReplicas(String keyspace, TokenRange range) {
        keyspace = Metadata.handleId(keyspace);
        TokenMap current = this.tokenMap;
        if (current == null) {
            return Collections.emptySet();
        }
        Set hosts = current.getReplicas(keyspace, range.getEnd());
        return hosts == null ? Collections.emptySet() : hosts;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getPartitioner() {
        return this.partitioner;
    }

    public Set<Host> getAllHosts() {
        return new HashSet<Host>(this.allHosts());
    }

    public KeyspaceMetadata getKeyspace(String keyspace) {
        return (KeyspaceMetadata)this.keyspaces.get(Metadata.handleId(keyspace));
    }

    KeyspaceMetadata getKeyspaceInternal(String keyspace) {
        return (KeyspaceMetadata)this.keyspaces.get(keyspace);
    }

    void removeKeyspace(String keyspace) {
        this.keyspaces.remove(keyspace);
        if (this.tokenMap != null) {
            this.tokenMap.tokenToHosts.remove(keyspace);
        }
    }

    public List<KeyspaceMetadata> getKeyspaces() {
        return new ArrayList<KeyspaceMetadata>(this.keyspaces.values());
    }

    public String exportSchemaAsString() {
        StringBuilder sb = new StringBuilder();
        for (KeyspaceMetadata ksm : this.keyspaces.values()) {
            sb.append(ksm.exportAsString()).append('\n');
        }
        return sb.toString();
    }

    public Token newToken(String tokenStr) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            throw new DriverInternalError("Token factory not set. This should only happen at initialization time");
        }
        return current.factory.fromString(tokenStr);
    }

    public TokenRange newTokenRange(Token start, Token end) {
        TokenMap current = this.tokenMap;
        if (current == null) {
            throw new DriverInternalError("Token factory not set. This should only happen at initialization time");
        }
        return new TokenRange(start, end, current.factory);
    }

    Token.Factory tokenFactory() {
        TokenMap current = this.tokenMap;
        return current == null ? null : current.factory;
    }

    static class TokenMap {
        private final Token.Factory factory;
        private final Map<String, Map<Token, Set<Host>>> tokenToHosts;
        private final Map<String, Map<Host, Set<TokenRange>>> hostsToRanges;
        private final List<Token> ring;
        private final Set<TokenRange> tokenRanges;
        final Set<Host> hosts;

        private TokenMap(Token.Factory factory, Map<Host, Set<Token>> primaryToTokens, Map<String, Map<Token, Set<Host>>> tokenToHosts, Map<String, Map<Host, Set<TokenRange>>> hostsToRanges, List<Token> ring, Set<TokenRange> tokenRanges, Set<Host> hosts) {
            this.factory = factory;
            this.tokenToHosts = tokenToHosts;
            this.hostsToRanges = hostsToRanges;
            this.ring = ring;
            this.tokenRanges = tokenRanges;
            this.hosts = hosts;
            for (Map.Entry<Host, Set<Token>> entry : primaryToTokens.entrySet()) {
                Host host = entry.getKey();
                host.setTokens(ImmutableSet.copyOf((Collection)entry.getValue()));
            }
        }

        public static TokenMap build(Token.Factory factory, Map<Host, Collection<String>> allTokens, Collection<KeyspaceMetadata> keyspaces) {
            Set<Host> hosts = allTokens.keySet();
            HashMap<Token, Host> tokenToPrimary = new HashMap<Token, Host>();
            HashMap<Host, Set<Token>> primaryToTokens = new HashMap<Host, Set<Token>>();
            TreeSet<Token> allSorted = new TreeSet<Token>();
            for (Map.Entry<Host, Collection<String>> entry : allTokens.entrySet()) {
                Host host = entry.getKey();
                for (String tokenStr : entry.getValue()) {
                    try {
                        Token t = factory.fromString(tokenStr);
                        allSorted.add(t);
                        tokenToPrimary.put(t, host);
                        HashSet<Token> hostTokens = (HashSet<Token>)primaryToTokens.get(host);
                        if (hostTokens == null) {
                            hostTokens = new HashSet<Token>();
                            primaryToTokens.put(host, hostTokens);
                        }
                        hostTokens.add(t);
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
            ArrayList<Token> ring = new ArrayList<Token>(allSorted);
            Set<TokenRange> tokenRanges = TokenMap.makeTokenRanges(ring, factory);
            HashMap<String, Map<Token, Set<Host>>> tokenToHosts = new HashMap<String, Map<Token, Set<Host>>>();
            HashMap<String, Map<Host, Set<TokenRange>>> hostsToRanges = new HashMap<String, Map<Host, Set<TokenRange>>>();
            for (KeyspaceMetadata keyspace : keyspaces) {
                Map<Host, Set<TokenRange>> ksRanges;
                ReplicationStrategy strategy = keyspace.replicationStrategy();
                Map<Token, Set<Host>> ksTokens = strategy == null ? TokenMap.makeNonReplicatedMap(tokenToPrimary) : strategy.computeTokenToReplicaMap(tokenToPrimary, ring);
                tokenToHosts.put(keyspace.getName(), ksTokens);
                if (ring.size() == 1) {
                    ImmutableMap.Builder<Host, Set<TokenRange>> builder = ImmutableMap.builder();
                    for (Host host : allTokens.keySet()) {
                        builder.put(host, tokenRanges);
                    }
                    ksRanges = builder.build();
                } else {
                    ksRanges = TokenMap.computeHostsToRangesMap(tokenRanges, ksTokens, hosts.size());
                }
                hostsToRanges.put(keyspace.getName(), ksRanges);
            }
            return new TokenMap(factory, primaryToTokens, tokenToHosts, hostsToRanges, ring, tokenRanges, hosts);
        }

        private Set<Host> getReplicas(String keyspace, Token token) {
            Map<Token, Set<Host>> keyspaceHosts = this.tokenToHosts.get(keyspace);
            if (keyspaceHosts == null) {
                return Collections.emptySet();
            }
            Set<Host> hosts = keyspaceHosts.get(token);
            if (hosts != null) {
                return hosts;
            }
            int i = Collections.binarySearch(this.ring, token);
            if (i < 0 && (i = -i - 1) >= this.ring.size()) {
                i = 0;
            }
            return keyspaceHosts.get(this.ring.get(i));
        }

        private static Map<Token, Set<Host>> makeNonReplicatedMap(Map<Token, Host> input) {
            HashMap<Token, Set<Host>> output = new HashMap<Token, Set<Host>>(input.size());
            for (Map.Entry<Token, Host> entry : input.entrySet()) {
                output.put(entry.getKey(), ImmutableSet.of(entry.getValue()));
            }
            return output;
        }

        private static Set<TokenRange> makeTokenRanges(List<Token> ring, Token.Factory factory) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ring.size() == 1) {
                builder.add(new TokenRange(factory.minToken(), factory.minToken(), factory));
            } else {
                for (int i = 0; i < ring.size(); ++i) {
                    Token start = ring.get(i);
                    Token end = ring.get((i + 1) % ring.size());
                    builder.add(new TokenRange(start, end, factory));
                }
            }
            return builder.build();
        }

        private static Map<Host, Set<TokenRange>> computeHostsToRangesMap(Set<TokenRange> tokenRanges, Map<Token, Set<Host>> ksTokens, int hostCount) {
            HashMap builders = Maps.newHashMapWithExpectedSize(hostCount);
            for (TokenRange range : tokenRanges) {
                Set<Host> replicas = ksTokens.get(range.getEnd());
                for (Host host : replicas) {
                    ImmutableSet.Builder hostRanges = (ImmutableSet.Builder)builders.get(host);
                    if (hostRanges == null) {
                        hostRanges = ImmutableSet.builder();
                        builders.put(host, hostRanges);
                    }
                    hostRanges.add(range);
                }
            }
            HashMap<Host, Set<TokenRange>> ksRanges = Maps.newHashMapWithExpectedSize(hostCount);
            for (Map.Entry entry : builders.entrySet()) {
                ksRanges.put((Host)entry.getKey(), (Set<TokenRange>)((Object)((ImmutableSet.Builder)entry.getValue()).build()));
            }
            return ksRanges;
        }
    }
}

