/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.SessionManager;
import java.util.HashSet;

public class Metrics {
    private final Cluster.Manager manager;
    private final MetricRegistry registry = new MetricRegistry();
    private final JmxReporter jmxReporter;
    private final Errors errors = new Errors();
    private final Timer requests = this.registry.timer("requests");
    private final Gauge<Integer> knownHosts = this.registry.register("known-hosts", new Gauge<Integer>(){

        @Override
        public Integer getValue() {
            return ((Metrics)Metrics.this).manager.metadata.allHosts().size();
        }
    });
    private final Gauge<Integer> connectedTo = this.registry.register("connected-to", new Gauge<Integer>(){

        @Override
        public Integer getValue() {
            HashSet s = new HashSet();
            for (SessionManager session : ((Metrics)Metrics.this).manager.sessions) {
                s.addAll(session.pools.keySet());
            }
            return s.size();
        }
    });
    private final Gauge<Integer> openConnections = this.registry.register("open-connections", new Gauge<Integer>(){

        @Override
        public Integer getValue() {
            int value = ((Metrics)Metrics.this).manager.controlConnection.isOpen() ? 1 : 0;
            for (SessionManager session : ((Metrics)Metrics.this).manager.sessions) {
                for (HostConnectionPool pool : session.pools.values()) {
                    value += pool.opened();
                }
            }
            return value;
        }
    });

    Metrics(Cluster.Manager manager) {
        this.manager = manager;
        if (manager.configuration.getMetricsOptions().isJMXReportingEnabled()) {
            this.jmxReporter = JmxReporter.forRegistry(this.registry).inDomain(manager.clusterName + "-metrics").build();
            this.jmxReporter.start();
        } else {
            this.jmxReporter = null;
        }
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public Timer getRequestsTimer() {
        return this.requests;
    }

    public Errors getErrorMetrics() {
        return this.errors;
    }

    public Gauge<Integer> getKnownHosts() {
        return this.knownHosts;
    }

    public Gauge<Integer> getConnectedToHosts() {
        return this.connectedTo;
    }

    public Gauge<Integer> getOpenConnections() {
        return this.openConnections;
    }

    void shutdown() {
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
        }
    }

    public class Errors {
        private final Counter connectionErrors;
        private final Counter writeTimeouts;
        private final Counter readTimeouts;
        private final Counter unavailables;
        private final Counter otherErrors;
        private final Counter retries;
        private final Counter retriesOnWriteTimeout;
        private final Counter retriesOnReadTimeout;
        private final Counter retriesOnUnavailable;
        private final Counter ignores;
        private final Counter ignoresOnWriteTimeout;
        private final Counter ignoresOnReadTimeout;
        private final Counter ignoresOnUnavailable;

        public Errors() {
            this.connectionErrors = Metrics.this.registry.counter("connection-errors");
            this.writeTimeouts = Metrics.this.registry.counter("write-timeouts");
            this.readTimeouts = Metrics.this.registry.counter("read-timeouts");
            this.unavailables = Metrics.this.registry.counter("unavailables");
            this.otherErrors = Metrics.this.registry.counter("other-errors");
            this.retries = Metrics.this.registry.counter("retries");
            this.retriesOnWriteTimeout = Metrics.this.registry.counter("retries-on-write-timeout");
            this.retriesOnReadTimeout = Metrics.this.registry.counter("retries-on-read-timeout");
            this.retriesOnUnavailable = Metrics.this.registry.counter("retries-on-unavailable");
            this.ignores = Metrics.this.registry.counter("ignores");
            this.ignoresOnWriteTimeout = Metrics.this.registry.counter("ignores-on-write-timeout");
            this.ignoresOnReadTimeout = Metrics.this.registry.counter("ignores-on-read-timeout");
            this.ignoresOnUnavailable = Metrics.this.registry.counter("ignores-on-unavailable");
        }

        public Counter getConnectionErrors() {
            return this.connectionErrors;
        }

        public Counter getWriteTimeouts() {
            return this.writeTimeouts;
        }

        public Counter getReadTimeouts() {
            return this.readTimeouts;
        }

        public Counter getUnavailables() {
            return this.unavailables;
        }

        public Counter getOthers() {
            return this.otherErrors;
        }

        public Counter getRetries() {
            return this.retries;
        }

        public Counter getRetriesOnReadTimeout() {
            return this.retriesOnReadTimeout;
        }

        public Counter getRetriesOnWriteTimeout() {
            return this.retriesOnWriteTimeout;
        }

        public Counter getRetriesOnUnavailable() {
            return this.retriesOnUnavailable;
        }

        public Counter getIgnores() {
            return this.ignores;
        }

        public Counter getIgnoresOnReadTimeout() {
            return this.ignoresOnReadTimeout;
        }

        public Counter getIgnoresOnWriteTimeout() {
            return this.ignoresOnWriteTimeout;
        }

        public Counter getIgnoresOnUnavailable() {
            return this.ignoresOnUnavailable;
        }
    }
}

