/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DefaultPreparedStatement;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.OperationTimedOutException;
import com.datastax.driver.core.PooledConnection;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Striped;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionManager
extends AbstractSession {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    final Cluster cluster;
    final ConcurrentMap<Host, HostConnectionPool> pools;
    final HostConnectionPool.PoolState poolsState;
    final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
    private final Striped<Lock> poolCreationLocks = Striped.lazyWeakLock(5);
    private volatile boolean isInit;
    private volatile boolean isClosing;

    SessionManager(Cluster cluster) {
        this.cluster = cluster;
        this.pools = new ConcurrentHashMap<Host, HostConnectionPool>();
        this.poolsState = new HostConnectionPool.PoolState();
    }

    @Override
    public synchronized Session init() {
        if (this.isInit) {
            return this;
        }
        this.cluster.init();
        Collection<Host> hosts = this.cluster.getMetadata().allHosts();
        if (this.cluster.manager.sessions.size() == 1) {
            this.createPoolsInParallel(hosts);
        } else {
            this.createPoolsSequentially(hosts);
        }
        this.isInit = true;
        this.updateCreatedPools(this.executor());
        return this;
    }

    private void createPoolsInParallel(Collection<Host> hosts) {
        ArrayList<ListenableFuture<Boolean>> futures = new ArrayList<ListenableFuture<Boolean>>(hosts.size());
        for (Host host : hosts) {
            if (host.state == Host.State.DOWN) continue;
            futures.add(this.maybeAddPool(host, this.executor()));
        }
        ListenableFuture f = Futures.allAsList(futures);
        try {
            f.get();
        }
        catch (ExecutionException e) {
            throw new DriverInternalError(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void createPoolsSequentially(Collection<Host> hosts) {
        for (Host host : this.cluster.getMetadata().allHosts()) {
            try {
                if (host.state == Host.State.DOWN) continue;
                this.maybeAddPool(host, this.executor()).get();
            }
            catch (ExecutionException e) {
                throw new DriverInternalError(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public String getLoggedKeyspace() {
        return this.poolsState.keyspace;
    }

    @Override
    public ResultSetFuture executeAsync(Statement statement) {
        return this.executeQuery(this.makeRequestMessage(statement, null), statement);
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        Connection.Future future = new Connection.Future(new Requests.Prepare(query));
        this.execute(future, Statement.DEFAULT);
        return this.toPreparedStatement(query, future);
    }

    @Override
    public CloseFuture closeAsync() {
        CloseFuture future = this.closeFuture.get();
        if (future != null) {
            return future;
        }
        this.isClosing = true;
        this.cluster.manager.removeSession(this);
        ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>(this.pools.size());
        for (HostConnectionPool pool : this.pools.values()) {
            futures.add(pool.closeAsync());
        }
        future = new CloseFuture.Forwarding(futures);
        return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
    }

    @Override
    public boolean isClosed() {
        return this.closeFuture.get() != null;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public Session.State getState() {
        return new State(this);
    }

    private ListenableFuture<PreparedStatement> toPreparedStatement(final String query, final Connection.Future future) {
        return Futures.transform(future, new Function<Message.Response, PreparedStatement>(){

            @Override
            public PreparedStatement apply(Message.Response response) {
                switch (response.type) {
                    case RESULT: {
                        Responses.Result rm = (Responses.Result)response;
                        switch (rm.kind) {
                            case PREPARED: {
                                Responses.Result.Prepared pmsg = (Responses.Result.Prepared)rm;
                                PreparedStatement stmt = DefaultPreparedStatement.fromMessage(pmsg, SessionManager.this.cluster.getMetadata(), SessionManager.this.cluster.getConfiguration().getProtocolOptions().getProtocolVersionEnum(), query, SessionManager.this.poolsState.keyspace);
                                stmt = SessionManager.this.cluster.manager.addPrepared(stmt);
                                try {
                                    SessionManager.this.prepare(stmt.getQueryString(), future.getAddress());
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                                return stmt;
                            }
                        }
                        throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{rm.kind}));
                    }
                    case ERROR: {
                        throw ((Responses.Error)response).asException(future.getAddress());
                    }
                }
                throw new DriverInternalError(String.format("%s response received when prepared statement was expected", new Object[]{response.type}));
            }
        }, (Executor)this.executor());
    }

    Connection.Factory connectionFactory() {
        return this.cluster.manager.connectionFactory;
    }

    Configuration configuration() {
        return this.cluster.manager.configuration;
    }

    LoadBalancingPolicy loadBalancingPolicy() {
        return this.cluster.manager.loadBalancingPolicy();
    }

    ReconnectionPolicy reconnectionPolicy() {
        return this.cluster.manager.reconnectionPolicy();
    }

    ListeningExecutorService executor() {
        return this.cluster.manager.executor;
    }

    ListeningExecutorService blockingExecutor() {
        return this.cluster.manager.blockingExecutor;
    }

    ListenableFuture<Boolean> forceRenewPool(final Host host, ListeningExecutorService executor) {
        final HostDistance distance = this.cluster.manager.loadBalancingPolicy().distance(host);
        if (distance == HostDistance.IGNORED) {
            return Futures.immediateFuture(true);
        }
        return executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    if (SessionManager.this.isClosing) {
                        return true;
                    }
                    HostConnectionPool newPool = HostConnectionPool.newInstance(host, distance, SessionManager.this, SessionManager.this.cluster.getConfiguration().getProtocolOptions().getProtocolVersionEnum());
                    HostConnectionPool previous = SessionManager.this.pools.put(host, newPool);
                    if (previous == null) {
                        logger.debug("Added connection pool for {}", (Object)host);
                    } else {
                        logger.debug("Renewed connection pool for {}", (Object)host);
                        previous.closeAsync();
                    }
                    if (SessionManager.this.isClosing) {
                        newPool.closeAsync();
                    }
                    return true;
                }
                catch (Exception e) {
                    logger.error("Error creating pool to " + host, (Throwable)e);
                    return false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replacePool(Host host, HostDistance distance, HostConnectionPool condition) throws ConnectionException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
        if (this.isClosing) {
            return true;
        }
        Lock l = this.poolCreationLocks.get(host);
        l.lock();
        try {
            HostConnectionPool previous = (HostConnectionPool)this.pools.get(host);
            if (previous != condition) {
                boolean bl = false;
                return bl;
            }
            HostConnectionPool newPool = HostConnectionPool.newInstance(host, distance, this, this.cluster.getConfiguration().getProtocolOptions().getProtocolVersionEnum());
            previous = this.pools.put(host, newPool);
            if (previous != null && !previous.isClosed()) {
                logger.warn("Replacing a pool that wasn't closed. Closing it now, but this was not expected.");
                previous.closeAsync();
            }
            if (this.isClosing) {
                newPool.closeAsync();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    ListenableFuture<Boolean> maybeAddPool(final Host host, ListeningExecutorService executor) {
        final HostDistance distance = this.cluster.manager.loadBalancingPolicy().distance(host);
        if (distance == HostDistance.IGNORED) {
            return Futures.immediateFuture(true);
        }
        HostConnectionPool previous = (HostConnectionPool)this.pools.get(host);
        if (previous != null && !previous.isClosed()) {
            return Futures.immediateFuture(true);
        }
        return executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    HostConnectionPool previous;
                    do {
                        if ((previous = (HostConnectionPool)SessionManager.this.pools.get(host)) == null || previous.isClosed()) continue;
                        return true;
                    } while (!SessionManager.this.replacePool(host, distance, previous));
                    logger.debug("Added connection pool for {}", (Object)host);
                    return true;
                }
                catch (UnsupportedProtocolVersionException e) {
                    SessionManager.this.cluster.manager.logUnsupportedVersionProtocol(host, e.unsupportedVersion);
                    SessionManager.this.cluster.manager.triggerOnDown(host, false);
                    return false;
                }
                catch (ClusterNameMismatchException e) {
                    SessionManager.this.cluster.manager.logClusterNameMismatch(host, e.expectedClusterName, e.actualClusterName);
                    SessionManager.this.cluster.manager.triggerOnDown(host, false);
                    return false;
                }
                catch (Exception e) {
                    logger.error("Error creating pool to " + host, (Throwable)e);
                    return false;
                }
            }
        });
    }

    CloseFuture removePool(Host host) {
        HostConnectionPool pool = (HostConnectionPool)this.pools.remove(host);
        return pool == null ? CloseFuture.immediateFuture() : pool.closeAsync();
    }

    void updateCreatedPools(ListeningExecutorService executor) {
        if (!this.isInit) {
            return;
        }
        try {
            ArrayList<Host> toRemove = new ArrayList<Host>();
            ArrayList<ListenableFuture<Boolean>> poolCreationFutures = new ArrayList<ListenableFuture<Boolean>>();
            for (Host h : this.cluster.getMetadata().allHosts()) {
                HostDistance dist = this.loadBalancingPolicy().distance(h);
                HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
                if (pool == null) {
                    if (dist == HostDistance.IGNORED || h.state != Host.State.UP) continue;
                    poolCreationFutures.add(this.maybeAddPool(h, executor));
                    continue;
                }
                if (dist == pool.hostDistance) continue;
                if (dist == HostDistance.IGNORED) {
                    toRemove.add(h);
                    continue;
                }
                pool.hostDistance = dist;
                pool.ensureCoreConnections();
            }
            Futures.allAsList(poolCreationFutures).get();
            ArrayList<CloseFuture> poolRemovalFutures = new ArrayList<CloseFuture>(toRemove.size());
            for (Host h : toRemove) {
                poolRemovalFutures.add(this.removePool(h));
            }
            Futures.allAsList(poolRemovalFutures).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error("Unexpected error while refreshing connection pools", e.getCause());
        }
    }

    void updateCreatedPools(Host h, ListeningExecutorService executor) {
        HostDistance dist = this.loadBalancingPolicy().distance(h);
        HostConnectionPool pool = (HostConnectionPool)this.pools.get(h);
        try {
            if (pool == null) {
                if (dist != HostDistance.IGNORED && h.state == Host.State.UP) {
                    this.maybeAddPool(h, executor).get();
                }
            } else if (dist != pool.hostDistance) {
                if (dist == HostDistance.IGNORED) {
                    this.removePool(h).get();
                } else {
                    pool.hostDistance = dist;
                    pool.ensureCoreConnections();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error("Unexpected error while refreshing connection pools", e.getCause());
        }
    }

    void onDown(Host host) throws InterruptedException, ExecutionException {
        this.removePool(host).force().get();
        this.updateCreatedPools(MoreExecutors.sameThreadExecutor());
    }

    void onSuspected(Host host) {
    }

    void onRemove(Host host) throws InterruptedException, ExecutionException {
        this.onDown(host);
    }

    void setKeyspace(String keyspace) {
        long timeout = this.configuration().getSocketOptions().getConnectTimeoutMillis();
        try {
            ResultSetFuture future = this.executeQuery(new Requests.Query("use " + keyspace), Statement.DEFAULT);
            Uninterruptibles.getUninterruptibly(future, timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new DriverInternalError(String.format("No responses after %d milliseconds while setting current keyspace. This should not happen, unless you have setup a very low connection timeout.", timeout));
        }
        catch (ExecutionException e) {
            throw DefaultResultSetFuture.extractCauseFromExecutionException(e);
        }
    }

    Message.Request makeRequestMessage(Statement statement, ByteBuffer pagingState) {
        if (!this.isInit) {
            this.init();
        }
        ProtocolVersion version = this.cluster.manager.protocolVersion();
        ConsistencyLevel consistency = statement.getConsistencyLevel();
        if (consistency == null) {
            consistency = this.configuration().getQueryOptions().getConsistencyLevel();
        }
        ConsistencyLevel serialConsistency = statement.getSerialConsistencyLevel();
        if (version.compareTo(ProtocolVersion.V3) < 0 && statement instanceof BatchStatement) {
            if (serialConsistency != null) {
                throw new UnsupportedFeatureException(version, "Serial consistency on batch statements is not supported");
            }
        } else if (serialConsistency == null) {
            serialConsistency = this.configuration().getQueryOptions().getSerialConsistencyLevel();
        }
        long defaultTimestamp = Long.MIN_VALUE;
        if (this.cluster.manager.protocolVersion().compareTo(ProtocolVersion.V3) >= 0 && (defaultTimestamp = statement.getDefaultTimestamp()) == Long.MIN_VALUE) {
            defaultTimestamp = this.cluster.getConfiguration().getPolicies().getTimestampGenerator().next();
        }
        return this.makeRequestMessage(statement, consistency, serialConsistency, pagingState, defaultTimestamp);
    }

    Message.Request makeRequestMessage(Statement statement, ConsistencyLevel cl, ConsistencyLevel scl, ByteBuffer pagingState, long defaultTimestamp) {
        ProtocolVersion protoVersion = this.cluster.manager.protocolVersion();
        int fetchSize = statement.getFetchSize();
        if (protoVersion == ProtocolVersion.V1) {
            assert (pagingState == null);
            if (fetchSize <= 0) {
                fetchSize = -1;
            } else if (fetchSize != Integer.MAX_VALUE) {
                throw new UnsupportedFeatureException(protoVersion, "Paging is not supported");
            }
        } else if (fetchSize <= 0) {
            fetchSize = this.configuration().getQueryOptions().getFetchSize();
        }
        if (fetchSize == Integer.MAX_VALUE) {
            fetchSize = -1;
        }
        if (statement instanceof RegularStatement) {
            RegularStatement rs = (RegularStatement)statement;
            if (protoVersion == ProtocolVersion.V1 && rs instanceof BuiltStatement) {
                ((BuiltStatement)rs).setForceNoValues(true);
            }
            ByteBuffer[] rawValues = rs.getValues(protoVersion);
            if (protoVersion == ProtocolVersion.V1 && rawValues != null) {
                throw new UnsupportedFeatureException(protoVersion, "Binary values are not supported");
            }
            List<ByteBuffer> values = rawValues == null ? Collections.emptyList() : Arrays.asList(rawValues);
            String qString = rs.getQueryString();
            Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(cl, values, false, fetchSize, pagingState, scl, defaultTimestamp);
            return new Requests.Query(qString, options);
        }
        if (statement instanceof BoundStatement) {
            BoundStatement bs = (BoundStatement)statement;
            bs.ensureAllSet();
            boolean skipMetadata = protoVersion != ProtocolVersion.V1 && bs.statement.getPreparedId().resultSetMetadata != null;
            Requests.QueryProtocolOptions options = new Requests.QueryProtocolOptions(cl, Arrays.asList(bs.wrapper.values), skipMetadata, fetchSize, pagingState, scl, defaultTimestamp);
            return new Requests.Execute(bs.statement.getPreparedId().id, options);
        }
        assert (statement instanceof BatchStatement) : statement;
        assert (pagingState == null);
        if (protoVersion == ProtocolVersion.V1) {
            throw new UnsupportedFeatureException(protoVersion, "Protocol level batching is not supported");
        }
        BatchStatement bs = (BatchStatement)statement;
        bs.ensureAllSet();
        BatchStatement.IdAndValues idAndVals = bs.getIdAndValues(protoVersion);
        Requests.BatchProtocolOptions options = new Requests.BatchProtocolOptions(cl, scl, defaultTimestamp);
        return new Requests.Batch(bs.batchType, idAndVals.ids, idAndVals.values, options);
    }

    void execute(RequestHandler.Callback callback, Statement statement) {
        if (!this.isInit) {
            this.init();
        }
        new RequestHandler(this, callback, statement).sendRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepare(String query, InetSocketAddress toExclude) throws InterruptedException {
        Iterator i$ = this.pools.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = i$.next();
            if (((Host)entry.getKey()).getSocketAddress().equals(toExclude)) continue;
            PooledConnection c = null;
            boolean timedOut = false;
            try {
                c = ((HostConnectionPool)entry.getValue()).borrowConnection(200L, TimeUnit.MILLISECONDS);
                c.write(new Requests.Prepare(query)).get();
                continue;
            }
            catch (ConnectionException e) {
                continue;
            }
            catch (BusyConnectionException e) {
                continue;
            }
            catch (TimeoutException e) {
                continue;
            }
            catch (ExecutionException e) {
                logger.error(String.format("Unexpected error while preparing query (%s) on %s", query, entry.getKey()), (Throwable)e);
                timedOut = e.getCause() instanceof OperationTimedOutException;
                continue;
            }
            finally {
                if (c == null || timedOut) continue;
                c.release();
                continue;
            }
            break;
        }
        return;
    }

    ResultSetFuture executeQuery(Message.Request msg, Statement statement) {
        if (statement.isTracing()) {
            msg.setTracingRequested();
        }
        DefaultResultSetFuture future = new DefaultResultSetFuture(this, this.configuration().getProtocolOptions().getProtocolVersionEnum(), msg);
        this.execute(future, statement);
        return future;
    }

    private static class State
    implements Session.State {
        private final SessionManager session;
        private final List<Host> connectedHosts;
        private final int[] openConnections;
        private final int[] inFlightQueries;

        private State(SessionManager session) {
            this.session = session;
            this.connectedHosts = ImmutableList.copyOf(session.pools.keySet());
            this.openConnections = new int[this.connectedHosts.size()];
            this.inFlightQueries = new int[this.connectedHosts.size()];
            int i = 0;
            for (Host h : this.connectedHosts) {
                HostConnectionPool p = (HostConnectionPool)session.pools.get(h);
                if (p == null) {
                    this.openConnections[i] = 0;
                    this.inFlightQueries[i] = 0;
                    continue;
                }
                this.openConnections[i] = p.opened();
                this.inFlightQueries[i] = p.inFlightQueriesCount();
                ++i;
            }
        }

        private int getIdx(Host h) {
            for (int i = 0; i < this.connectedHosts.size(); ++i) {
                if (h != this.connectedHosts.get(i)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Session getSession() {
            return this.session;
        }

        @Override
        public Collection<Host> getConnectedHosts() {
            return this.connectedHosts;
        }

        @Override
        public int getOpenConnections(Host host) {
            int i = this.getIdx(host);
            return i < 0 ? 0 : this.openConnections[i];
        }

        @Override
        public int getInFlightQueries(Host host) {
            int i = this.getIdx(host);
            return i < 0 ? 0 : this.inFlightQueries[i];
        }
    }
}

