/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PooledConnection;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SingleConnectionPool
extends HostConnectionPool {
    private static final Logger logger = LoggerFactory.getLogger(SingleConnectionPool.class);
    private static final int MIN_AVAILABLE_STREAMS = 24576;
    volatile AtomicReference<PooledConnection> connectionRef = new AtomicReference();
    private final AtomicBoolean open = new AtomicBoolean();
    private final Set<Connection> trash = new CopyOnWriteArraySet<Connection>();
    private volatile int waiter = 0;
    private final Lock waitLock = new ReentrantLock(true);
    private final Condition hasAvailableConnection = this.waitLock.newCondition();
    private final Runnable newConnectionTask;
    private final AtomicBoolean scheduledForCreation = new AtomicBoolean();

    public SingleConnectionPool(Host host, HostDistance hostDistance, SessionManager manager) throws ConnectionException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
        super(host, hostDistance, manager);
        this.newConnectionTask = new Runnable(){

            @Override
            public void run() {
                SingleConnectionPool.this.addConnectionIfNeeded();
                SingleConnectionPool.this.scheduledForCreation.set(false);
            }
        };
        try {
            this.connectionRef.set(manager.connectionFactory().open(this));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.open.set(true);
        logger.trace("Created connection pool to host {}", (Object)host);
    }

    private PoolingOptions options() {
        return this.manager.configuration().getPoolingOptions();
    }

    @Override
    public PooledConnection borrowConnection(long timeout, TimeUnit unit) throws ConnectionException, TimeoutException {
        if (this.isClosed()) {
            throw new ConnectionException(this.host.getSocketAddress(), "Pool is shutdown");
        }
        PooledConnection connection = this.connectionRef.get();
        if (connection == null) {
            if (this.scheduledForCreation.compareAndSet(false, true)) {
                this.manager.blockingExecutor().submit(this.newConnectionTask);
            }
            connection = this.waitForConnection(timeout, unit);
        } else {
            int inFlight;
            do {
                if ((inFlight = connection.inFlight.get()) < Math.min(connection.maxAvailableStreams(), this.options().getMaxSimultaneousRequestsPerHostThreshold(this.hostDistance))) continue;
                connection = this.waitForConnection(timeout, unit);
                break;
            } while (!connection.inFlight.compareAndSet(inFlight, inFlight + 1));
        }
        connection.setKeyspace(this.manager.poolsState.keyspace);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAvailableConnection(long timeout, TimeUnit unit) throws InterruptedException {
        this.waitLock.lock();
        ++this.waiter;
        try {
            this.hasAvailableConnection.await(timeout, unit);
        }
        finally {
            --this.waiter;
            this.waitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalAvailableConnection() {
        if (this.waiter == 0) {
            return;
        }
        this.waitLock.lock();
        try {
            this.hasAvailableConnection.signal();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalAllAvailableConnection() {
        if (this.waiter == 0) {
            return;
        }
        this.waitLock.lock();
        try {
            this.hasAvailableConnection.signalAll();
        }
        finally {
            this.waitLock.unlock();
        }
    }

    private PooledConnection waitForConnection(long timeout, TimeUnit unit) throws ConnectionException, TimeoutException {
        if (timeout == 0L) {
            throw new TimeoutException();
        }
        long start = System.nanoTime();
        long remaining = timeout;
        do {
            int inFlight;
            try {
                this.awaitAvailableConnection(remaining, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                timeout = 0L;
            }
            if (this.isClosed()) {
                throw new ConnectionException(this.host.getSocketAddress(), "Pool is shutdown");
            }
            PooledConnection connection = this.connectionRef.get();
            if (connection == null) continue;
            while ((inFlight = connection.inFlight.get()) < Math.min(connection.maxAvailableStreams(), this.options().getMaxSimultaneousRequestsPerHostThreshold(this.hostDistance))) {
                if (!connection.inFlight.compareAndSet(inFlight, inFlight + 1)) continue;
                return connection;
            }
        } while ((remaining = timeout - Cluster.timeSince(start, unit)) > 0L);
        throw new TimeoutException();
    }

    @Override
    public void returnConnection(PooledConnection connection) {
        if (this.isClosed()) {
            this.close(connection);
            return;
        }
        if (connection.isDefunct()) {
            return;
        }
        int inFlight = connection.inFlight.decrementAndGet();
        if (this.trash.contains(connection)) {
            if (inFlight == 0 && this.trash.remove(connection)) {
                this.close(connection);
            }
        } else if (connection.maxAvailableStreams() < 24576) {
            this.replaceConnection(connection);
        } else {
            this.signalAvailableConnection();
        }
    }

    private void replaceConnection(PooledConnection connection) {
        if (connection.markForTrash.compareAndSet(false, true)) {
            this.open.set(false);
        }
        this.maybeSpawnNewConnection();
        this.doTrashConnection(connection);
    }

    private void doTrashConnection(PooledConnection connection) {
        this.trash.add(connection);
        this.connectionRef.compareAndSet(connection, null);
        if (connection.inFlight.get() == 0 && this.trash.remove(connection)) {
            this.close(connection);
        }
    }

    private boolean addConnectionIfNeeded() {
        if (!this.open.compareAndSet(false, true)) {
            return false;
        }
        if (this.isClosed()) {
            this.open.set(false);
            return false;
        }
        try {
            this.connectionRef.set(this.manager.connectionFactory().open(this));
            this.signalAvailableConnection();
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.open.set(false);
            return false;
        }
        catch (ConnectionException e) {
            this.open.set(false);
            logger.debug("Connection error to {} while creating additional connection", (Object)this.host);
            return false;
        }
        catch (AuthenticationException e) {
            this.open.set(false);
            logger.error("Authentication error while creating additional connection (error is: {})", (Object)e.getMessage());
            return false;
        }
        catch (UnsupportedProtocolVersionException e) {
            this.open.set(false);
            logger.error("UnsupportedProtocolVersionException error while creating additional connection (error is: {})", (Object)e.getMessage());
            return false;
        }
        catch (ClusterNameMismatchException e) {
            this.open.set(false);
            logger.error("ClusterNameMismatchException error while creating additional connection (error is: {})", (Object)e.getMessage());
            return false;
        }
    }

    private void maybeSpawnNewConnection() {
        if (!this.scheduledForCreation.compareAndSet(false, true)) {
            return;
        }
        logger.debug("Creating new connection on busy pool to {}", (Object)this.host);
        this.manager.blockingExecutor().submit(this.newConnectionTask);
    }

    @Override
    public void replaceDefunctConnection(PooledConnection connection) {
        if (connection.markForTrash.compareAndSet(false, true)) {
            this.open.set(false);
        }
        this.connectionRef.compareAndSet(connection, null);
        connection.closeAsync();
        this.manager.blockingExecutor().submit(new Runnable(){

            @Override
            public void run() {
                SingleConnectionPool.this.addConnectionIfNeeded();
            }
        });
    }

    private void close(Connection connection) {
        connection.closeAsync();
    }

    @Override
    protected CloseFuture makeCloseFuture() {
        this.signalAllAvailableConnection();
        CloseFuture.Forwarding future = new CloseFuture.Forwarding(this.discardConnection());
        return future;
    }

    private List<CloseFuture> discardConnection() {
        ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>();
        final PooledConnection connection = this.connectionRef.get();
        if (connection != null) {
            CloseFuture future = connection.closeAsync();
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    if (connection.markForTrash.compareAndSet(false, true)) {
                        SingleConnectionPool.this.open.set(false);
                    }
                }
            }, MoreExecutors.sameThreadExecutor());
            futures.add(future);
        }
        return futures;
    }

    @Override
    public void ensureCoreConnections() {
        if (this.isClosed()) {
            return;
        }
        if (this.open.compareAndSet(false, true) && this.scheduledForCreation.compareAndSet(false, true)) {
            this.manager.blockingExecutor().submit(this.newConnectionTask);
        }
    }

    @Override
    public int opened() {
        return this.open.get() ? 1 : 0;
    }

    @Override
    public int inFlightQueriesCount() {
        PooledConnection connection = this.connectionRef.get();
        return connection == null ? 0 : connection.inFlight.get();
    }
}

