/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.cassandra.CassandraAggregationException;
import org.apache.camel.processor.aggregate.cassandra.CassandraCamelCodec;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.utils.cassandra.CassandraSessionHolder;
import org.apache.camel.utils.cassandra.CassandraUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraAggregationRepository
extends ServiceSupport
implements RecoverableAggregationRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraAggregationRepository.class);
    private CassandraSessionHolder sessionHolder;
    private String table = "CAMEL_AGGREGATION";
    private String exchangeIdColumn = "EXCHANGE_ID";
    private String exchangeColumn = "EXCHANGE";
    private Object[] prefixPKValues = new Object[0];
    private String[] pkColumns = new String[]{"KEY"};
    private final CassandraCamelCodec exchangeCodec = new CassandraCamelCodec();
    private Integer ttl;
    private ConsistencyLevel writeConsistencyLevel;
    private ConsistencyLevel readConsistencyLevel;
    private PreparedStatement insertStatement;
    private PreparedStatement selectStatement;
    private PreparedStatement deleteStatement;
    private PreparedStatement selectKeyIdStatement;
    private PreparedStatement deleteIfIdStatement;
    private long recoveryIntervalInMillis = 5000L;
    private boolean useRecovery = true;
    private String deadLetterUri;
    private int maximumRedeliveries;
    private boolean allowSerializedHeaders;

    public CassandraAggregationRepository() {
    }

    public CassandraAggregationRepository(Session session) {
        this.sessionHolder = new CassandraSessionHolder(session);
    }

    public CassandraAggregationRepository(Cluster cluster, String keyspace) {
        this.sessionHolder = new CassandraSessionHolder(cluster, keyspace);
    }

    protected Object[] getPKValues(String key) {
        return CassandraUtils.append(this.prefixPKValues, key);
    }

    private String getKeyColumn() {
        return this.pkColumns[this.pkColumns.length - 1];
    }

    private String[] getAllColumns() {
        return CassandraUtils.append(this.pkColumns, this.exchangeIdColumn, this.exchangeColumn);
    }

    protected void doStart() throws Exception {
        this.sessionHolder.start();
        this.initInsertStatement();
        this.initSelectStatement();
        this.initDeleteStatement();
        this.initSelectKeyIdStatement();
        this.initDeleteIfIdStatement();
    }

    protected void doStop() throws Exception {
        this.sessionHolder.stop();
    }

    private void initInsertStatement() {
        Insert insert = CassandraUtils.generateInsert(this.table, this.getAllColumns(), false, this.ttl);
        insert = CassandraUtils.applyConsistencyLevel(insert, this.writeConsistencyLevel);
        LOGGER.debug("Generated Insert {}", (Object)insert);
        this.insertStatement = this.getSession().prepare(insert);
    }

    public Exchange add(CamelContext camelContext, String key, Exchange exchange) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Inserting key {} exchange {}", (Object)idValues, (Object)exchange);
        try {
            ByteBuffer marshalledExchange = this.exchangeCodec.marshallExchange(camelContext, exchange, this.allowSerializedHeaders);
            Object[] cqlParams = CassandraUtils.concat(idValues, new Object[]{exchange.getExchangeId(), marshalledExchange});
            this.getSession().execute(this.insertStatement.bind(cqlParams));
            return exchange;
        }
        catch (IOException iOException) {
            throw new CassandraAggregationException("Failed to write exchange", exchange, iOException);
        }
    }

    protected void initSelectStatement() {
        Select select = CassandraUtils.generateSelect(this.table, this.getAllColumns(), this.pkColumns);
        select = CassandraUtils.applyConsistencyLevel(select, this.readConsistencyLevel);
        LOGGER.debug("Generated Select {}", (Object)select);
        this.selectStatement = this.getSession().prepare(select);
    }

    public Exchange get(CamelContext camelContext, String key) {
        Object[] pkValues = this.getPKValues(key);
        LOGGER.debug("Selecting key {} ", pkValues);
        Row row = this.getSession().execute(this.selectStatement.bind(pkValues)).one();
        Exchange exchange = null;
        if (row != null) {
            try {
                exchange = this.exchangeCodec.unmarshallExchange(camelContext, row.getBytes(this.exchangeColumn));
            }
            catch (IOException iOException) {
                throw new CassandraAggregationException("Failed to read exchange", exchange, iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CassandraAggregationException("Failed to read exchange", exchange, classNotFoundException);
            }
        }
        return exchange;
    }

    private void initDeleteIfIdStatement() {
        Delete delete = CassandraUtils.generateDelete(this.table, this.pkColumns, false);
        Delete.Conditions deleteIf = delete.onlyIf(QueryBuilder.eq(this.exchangeIdColumn, QueryBuilder.bindMarker()));
        deleteIf = CassandraUtils.applyConsistencyLevel(deleteIf, this.writeConsistencyLevel);
        LOGGER.debug("Generated Delete If Id {}", (Object)deleteIf);
        this.deleteIfIdStatement = this.getSession().prepare(deleteIf);
    }

    public void confirm(CamelContext camelContext, String exchangeId) {
        String keyColumn = this.getKeyColumn();
        LOGGER.debug("Selecting Ids");
        List<Row> rows = this.selectKeyIds();
        for (Row row : rows) {
            if (!row.getString(this.exchangeIdColumn).equals(exchangeId)) continue;
            String key = row.getString(keyColumn);
            Object[] cqlParams = CassandraUtils.append(this.getPKValues(key), exchangeId);
            LOGGER.debug("Deleting If Id {} ", cqlParams);
            this.getSession().execute(this.deleteIfIdStatement.bind(cqlParams));
        }
    }

    private void initDeleteStatement() {
        Delete delete = CassandraUtils.generateDelete(this.table, this.pkColumns, false);
        delete = CassandraUtils.applyConsistencyLevel(delete, this.writeConsistencyLevel);
        LOGGER.debug("Generated Delete {}", (Object)delete);
        this.deleteStatement = this.getSession().prepare(delete);
    }

    public void remove(CamelContext camelContext, String key, Exchange exchange) {
        Object[] idValues = this.getPKValues(key);
        LOGGER.debug("Deleting key {}", (Object)idValues);
        this.getSession().execute(this.deleteStatement.bind(idValues));
    }

    private void initSelectKeyIdStatement() {
        Select select = CassandraUtils.generateSelect(this.table, new String[]{this.getKeyColumn(), this.exchangeIdColumn}, this.pkColumns, this.pkColumns.length - 1);
        select = CassandraUtils.applyConsistencyLevel(select, this.readConsistencyLevel);
        LOGGER.debug("Generated Select keys {}", (Object)select);
        this.selectKeyIdStatement = this.getSession().prepare(select);
    }

    protected List<Row> selectKeyIds() {
        LOGGER.debug("Selecting keys {}", this.getPrefixPKValues());
        return this.getSession().execute(this.selectKeyIdStatement.bind(this.getPrefixPKValues())).all();
    }

    public Set<String> getKeys() {
        List<Row> rows = this.selectKeyIds();
        HashSet<String> keys = new HashSet<String>(rows.size());
        String keyColumnName = this.getKeyColumn();
        for (Row row : rows) {
            keys.add(row.getString(keyColumnName));
        }
        return keys;
    }

    public Set<String> scan(CamelContext camelContext) {
        List<Row> rows = this.selectKeyIds();
        HashSet<String> exchangeIds = new HashSet<String>(rows.size());
        for (Row row : rows) {
            exchangeIds.add(row.getString(this.exchangeIdColumn));
        }
        return exchangeIds;
    }

    public Exchange recover(CamelContext camelContext, String exchangeId) {
        List<Row> rows = this.selectKeyIds();
        String keyColumnName = this.getKeyColumn();
        String lKey = null;
        for (Row row : rows) {
            String lExchangeId = row.getString(this.exchangeIdColumn);
            if (!lExchangeId.equals(exchangeId)) continue;
            lKey = row.getString(keyColumnName);
            break;
        }
        return lKey == null ? null : this.get(camelContext, lKey);
    }

    public Session getSession() {
        return this.sessionHolder.getSession();
    }

    public void setSession(Session session) {
        this.sessionHolder = new CassandraSessionHolder(session);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public Object[] getPrefixPKValues() {
        return this.prefixPKValues;
    }

    public void setPrefixPKValues(Object ... prefixPKValues) {
        this.prefixPKValues = prefixPKValues;
    }

    public String[] getPKColumns() {
        return this.pkColumns;
    }

    public void setPKColumns(String ... pkColumns) {
        this.pkColumns = pkColumns;
    }

    public String getExchangeIdColumn() {
        return this.exchangeIdColumn;
    }

    public void setExchangeIdColumn(String exchangeIdColumn) {
        this.exchangeIdColumn = exchangeIdColumn;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel;
    }

    public void setWriteConsistencyLevel(ConsistencyLevel writeConsistencyLevel) {
        this.writeConsistencyLevel = writeConsistencyLevel;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel;
    }

    public void setReadConsistencyLevel(ConsistencyLevel readConsistencyLevel) {
        this.readConsistencyLevel = readConsistencyLevel;
    }

    public String getExchangeColumn() {
        return this.exchangeColumn;
    }

    public void setExchangeColumn(String exchangeColumnName) {
        this.exchangeColumn = exchangeColumnName;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public long getRecoveryIntervalInMillis() {
        return this.recoveryIntervalInMillis;
    }

    public void setRecoveryIntervalInMillis(long recoveryIntervalInMillis) {
        this.recoveryIntervalInMillis = recoveryIntervalInMillis;
    }

    public void setRecoveryInterval(long interval, TimeUnit timeUnit) {
        this.recoveryIntervalInMillis = timeUnit.toMillis(interval);
    }

    public void setRecoveryInterval(long recoveryIntervalInMillis) {
        this.recoveryIntervalInMillis = recoveryIntervalInMillis;
    }

    public boolean isUseRecovery() {
        return this.useRecovery;
    }

    public void setUseRecovery(boolean useRecovery) {
        this.useRecovery = useRecovery;
    }

    public String getDeadLetterUri() {
        return this.deadLetterUri;
    }

    public void setDeadLetterUri(String deadLetterUri) {
        this.deadLetterUri = deadLetterUri;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }
}

