/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.castor;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLContext;

public abstract class AbstractCastorDataFormat
extends ServiceSupport
implements DataFormat,
CamelContextAware {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private CamelContext camelContext;
    private String encoding = "UTF-8";
    private String mappingFile;
    private String[] classNames;
    private String[] packages;
    private boolean validation;
    private volatile XMLContext xmlContext;

    public AbstractCastorDataFormat() {
    }

    public AbstractCastorDataFormat(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
    }

    public void marshal(Exchange exchange, Object body, OutputStream outputStream) throws Exception {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.encoding);
        Marshaller marshaller = this.createMarshaller(exchange);
        marshaller.setWriter(writer);
        marshaller.marshal(body);
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        InputStreamReader reader = new InputStreamReader(inputStream, this.encoding);
        return this.createUnmarshaller(exchange).unmarshal(reader);
    }

    protected XMLContext createXMLContext(ClassResolver resolver, ClassLoader contextClassLoader) throws Exception {
        XMLContext xmlContext = new XMLContext();
        if (ObjectHelper.isNotEmpty((Object)this.getMappingFile())) {
            Mapping xmlMap = contextClassLoader != null ? new Mapping(contextClassLoader) : new Mapping();
            xmlMap.loadMapping(resolver.loadResourceAsURL(this.getMappingFile()));
            xmlContext.addMapping(xmlMap);
        }
        if (this.getPackages() != null) {
            xmlContext.addPackages(this.getPackages());
        }
        if (this.getClassNames() != null) {
            for (String name : this.getClassNames()) {
                Class clazz = resolver.resolveClass(name);
                xmlContext.addClass(clazz);
            }
        }
        return xmlContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Unmarshaller createUnmarshaller(Exchange exchange) throws Exception {
        Unmarshaller answer = this.xmlContext.createUnmarshaller();
        answer.setValidation(this.isValidation());
        return answer;
    }

    public Marshaller createMarshaller(Exchange exchange) throws Exception {
        Marshaller answer = this.xmlContext.createMarshaller();
        answer.setValidation(this.isValidation());
        return answer;
    }

    public void setXmlContext(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public void setClassNames(String[] classNames) {
        this.classNames = classNames;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.validation = validation;
    }

    protected void doStart() throws Exception {
        if (this.xmlContext == null) {
            this.xmlContext = this.createXMLContext(this.getCamelContext().getClassResolver(), this.getCamelContext().getApplicationContextClassLoader());
        }
    }

    protected void doStop() throws Exception {
    }
}

