/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.exolab.castor.xml.BaseSax2EventFromStaxProducer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class Sax2EventFromStaxEventProducer
extends BaseSax2EventFromStaxProducer {
    private XMLEventReader eventReader;
    private XMLEvent event;

    public Sax2EventFromStaxEventProducer(XMLEventReader eventReader) {
        this.eventReader = eventReader;
    }

    public void start() throws SAXException {
        int depth = 0;
        try {
            while (this.eventReader.hasNext()) {
                this.event = this.eventReader.nextEvent();
                depth = this.handleEventType(this.event.getEventType(), depth);
                if (depth > 0) continue;
                break;
            }
        }
        catch (XMLStreamException e) {
            this.getErrorHandler().warning(new SAXParseException(e.getMessage(), this.getSAXLocator(e.getLocation()), null));
        }
    }

    QName getQName() {
        if (this.event.isEndElement()) {
            return this.event.asEndElement().getName();
        }
        if (this.event.isStartElement()) {
            return this.event.asStartElement().getName();
        }
        return null;
    }

    char[] getCharacters() {
        Characters characters = this.event.asCharacters();
        return characters.getData().toCharArray();
    }

    void doStartPrefixMapping() throws SAXException {
        StartElement startElement = this.event.asStartElement();
        Iterator nsIt = startElement.getNamespaces();
        LinkedList<String> prefixList = new LinkedList<String>();
        while (nsIt.hasNext()) {
            Namespace ns = (Namespace)nsIt.next();
            String prefix = this.getNonEmpty(ns.getPrefix());
            this.getContentHandler().startPrefixMapping(prefix, ns.getNamespaceURI());
            prefixList.add(prefix);
        }
        this.getPrefixes().push(prefixList);
    }

    void doEndPrefixMapping() throws SAXException {
        List<String> prefixList = this.getPrefixes().pop();
        for (String prefix : prefixList) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    Attributes getAttributes() {
        StartElement startElement = this.event.asStartElement();
        AttributesImpl atts = new AttributesImpl();
        Iterator it = startElement.getAttributes();
        while (it.hasNext()) {
            Attribute attribute = (Attribute)it.next();
            String uri = attribute.getName().getNamespaceURI();
            String localName = attribute.getName().getLocalPart();
            String prefix = attribute.getName().getPrefix();
            String qName = this.getQName(prefix, localName);
            String type = attribute.getDTDType();
            String value = attribute.getValue();
            atts.addAttribute(uri, localName, qName, type, value);
        }
        return atts;
    }

    Location getLocation() {
        return this.event.getLocation();
    }
}

