/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.SAX2EventAndErrorProducer;
import org.exolab.castor.xml.Sax2EventFromStaxEventProducer;
import org.exolab.castor.xml.Sax2EventFromStaxStreamProducer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSax2EventFromStaxProducer
implements SAX2EventAndErrorProducer {
    private static final Log LOG = LogFactory.getLog(BaseSax2EventFromStaxProducer.class);
    private Stack<List<String>> prefixes = new Stack();
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;

    public static SAX2EventAndErrorProducer createSax2EventFromStax(XMLStreamReader streamReader) {
        return new Sax2EventFromStaxStreamProducer(streamReader);
    }

    public static SAX2EventAndErrorProducer createSax2EventFromStax(XMLEventReader eventReader) {
        return new Sax2EventFromStaxEventProducer(eventReader);
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Stack<List<String>> getPrefixes() {
        return this.prefixes;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    int handleEventType(int eventType, int depth) throws SAXException {
        switch (eventType) {
            case 1: {
                this.handleStartElement();
                return ++depth;
            }
            case 2: {
                this.handleEndElement();
                return --depth;
            }
            case 7: {
                this.handleStartDocument();
                return ++depth;
            }
            case 8: {
                this.handleEndDocument();
                return --depth;
            }
            case 4: {
                this.handleCharacters();
                return depth;
            }
            case 6: {
                this.handleSpace();
                return depth;
            }
        }
        return depth;
    }

    void handleStartDocument() throws SAXException {
        LOG.info("< handleStartDocument >");
        this.handleDocumentLocator();
        this.contentHandler.startDocument();
    }

    void handleEndDocument() throws SAXException {
        LOG.info("< handleEndDocument >");
        this.contentHandler.endDocument();
    }

    void handleStartElement() throws SAXException {
        LOG.info("< handleStartElement >");
        QName qName = this.getQName();
        String localName = qName.getLocalPart();
        String uri = qName.getNamespaceURI();
        String prefix = qName.getPrefix();
        String qNameString = this.getQName(prefix, localName);
        Attributes atts = this.getAttributes();
        this.doStartPrefixMapping();
        this.contentHandler.startElement(uri, localName, qNameString, atts);
    }

    void handleEndElement() throws SAXException {
        LOG.info("< handleEndElement >");
        QName qName = this.getQName();
        String localName = qName.getLocalPart();
        String uri = qName.getNamespaceURI();
        String prefix = qName.getPrefix();
        String qNameString = this.getQName(prefix, localName);
        this.contentHandler.endElement(uri, localName, qNameString);
        this.doEndPrefixMapping();
    }

    void handleSpace() throws SAXException {
    }

    void handleCharacters() throws SAXException {
        LOG.info("< handleCharacters >");
        char[] chars = this.getCharacters();
        if (this.isIgnorableWhitespace(chars, 0, chars.length)) {
            this.contentHandler.ignorableWhitespace(chars, 0, chars.length);
        } else {
            this.contentHandler.characters(chars, 0, chars.length);
        }
    }

    String getQName(String prefix, String localPart) {
        return this.getNonEmpty(prefix).length() >= 1 ? prefix + ":" + localPart : localPart;
    }

    boolean isIgnorableWhitespace(char[] chars, int start, int length) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(chars, start, length);
        String string = buffer.toString();
        return string.trim().length() == 0;
    }

    String getNonEmpty(String string) {
        return string == null ? "" : string;
    }

    abstract Location getLocation();

    abstract char[] getCharacters();

    abstract void doStartPrefixMapping() throws SAXException;

    abstract void doEndPrefixMapping() throws SAXException;

    abstract Attributes getAttributes();

    abstract QName getQName();

    private void handleDocumentLocator() {
        Locator locator = this.getSAXLocator(this.getLocation());
        this.contentHandler.setDocumentLocator(locator);
    }

    protected Locator getSAXLocator(Location location) {
        return new Locator(){

            public String getSystemId() {
                return BaseSax2EventFromStaxProducer.this.getLocation().getSystemId();
            }

            public String getPublicId() {
                return BaseSax2EventFromStaxProducer.this.getLocation().getPublicId();
            }

            public int getLineNumber() {
                return BaseSax2EventFromStaxProducer.this.getLocation().getLineNumber();
            }

            public int getColumnNumber() {
                return BaseSax2EventFromStaxProducer.this.getLocation().getColumnNumber();
            }
        };
    }
}

