/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.parsing.primitive.objects;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveBigDecimal;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveBigInteger;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveBoolean;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveByte;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveChar;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveDouble;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveEnum;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveFloat;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveInteger;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveLong;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveObject;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveShort;
import org.exolab.castor.xml.parsing.primitive.objects.PrimitiveString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveObjectFactory {
    private Map<Class<?>, Class<? extends PrimitiveObject>> typeHandlers = new HashMap();
    private final Log logger = LogFactory.getLog(this.getClass());
    private static PrimitiveObjectFactory primitiveObjectFactory;

    public static synchronized PrimitiveObjectFactory getInstance() {
        if (primitiveObjectFactory == null) {
            primitiveObjectFactory = new PrimitiveObjectFactory();
        }
        return primitiveObjectFactory;
    }

    private PrimitiveObjectFactory() {
        this.typeHandlers.put(String.class, PrimitiveString.class);
        this.typeHandlers.put(Enum.class, PrimitiveEnum.class);
        this.typeHandlers.put(Integer.TYPE, PrimitiveInteger.class);
        this.typeHandlers.put(Integer.class, PrimitiveInteger.class);
        this.typeHandlers.put(Boolean.TYPE, PrimitiveBoolean.class);
        this.typeHandlers.put(Boolean.class, PrimitiveBoolean.class);
        this.typeHandlers.put(Double.TYPE, PrimitiveDouble.class);
        this.typeHandlers.put(Double.class, PrimitiveDouble.class);
        this.typeHandlers.put(Long.TYPE, PrimitiveLong.class);
        this.typeHandlers.put(Long.class, PrimitiveLong.class);
        this.typeHandlers.put(Character.TYPE, PrimitiveChar.class);
        this.typeHandlers.put(Character.class, PrimitiveChar.class);
        this.typeHandlers.put(Short.TYPE, PrimitiveShort.class);
        this.typeHandlers.put(Short.class, PrimitiveShort.class);
        this.typeHandlers.put(Float.TYPE, PrimitiveFloat.class);
        this.typeHandlers.put(Float.class, PrimitiveFloat.class);
        this.typeHandlers.put(Byte.TYPE, PrimitiveByte.class);
        this.typeHandlers.put(Byte.class, PrimitiveByte.class);
        this.typeHandlers.put(BigInteger.class, PrimitiveBigInteger.class);
        this.typeHandlers.put(BigDecimal.class, PrimitiveBigDecimal.class);
    }

    public Object getObject(Class<?> type, String value) {
        PrimitiveObject handler = this.lookupHandler(type);
        if (handler == null) {
            handler = this.getDefaultHandler();
        }
        if (type != String.class) {
            value = this.trimNumericValues(value);
        }
        return handler.getObject(type, value);
    }

    private PrimitiveObject lookupHandler(Class<?> type) {
        PrimitiveObject instance = null;
        if (type == null) {
            return null;
        }
        Class<? extends PrimitiveObject> result = this.typeHandlers.get(type);
        if (result == null) {
            result = this.typeHandlers.get(type.getSuperclass());
        }
        if (result != null) {
            try {
                instance = result.newInstance();
            }
            catch (InstantiationException e) {
                this.logger.error("Problem instantiating an instance of " + result.getName());
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                this.logger.error("Problem accessing default constructor of " + result.getName());
                e.printStackTrace();
            }
        }
        return instance;
    }

    private String trimNumericValues(String value) {
        if (value == null) {
            return null;
        }
        return value.trim();
    }

    private PrimitiveObject getDefaultHandler() {
        return new PrimitiveObject();
    }
}

