/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util.resolvers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.xml.ResolverException;
import org.exolab.castor.xml.util.resolvers.AbstractResolverPackageCommand;
import org.exolab.castor.xml.util.resolvers.ResolveHelpers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByCDR
extends AbstractResolverPackageCommand {
    private static final Log LOG = LogFactory.getLog(ByCDR.class);
    private List<String> _loadedPackages = new ArrayList<String>();

    private Properties getProperties(URL url) throws IOException {
        Properties cdrList = new Properties();
        InputStream stream = url.openStream();
        cdrList.load(stream);
        stream.close();
        return cdrList;
    }

    @Override
    protected Map<String, ClassDescriptor> internalResolve(String packageName, ClassLoader classLoader, Map properties) throws ResolverException {
        URL url;
        HashMap<String, ClassDescriptor> results = new HashMap<String, ClassDescriptor>();
        if (!this.isEmptyPackageName(packageName) && this._loadedPackages.contains(packageName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Package: " + packageName + " has already been loaded.");
            }
            return results;
        }
        if (!this.isEmptyPackageName(packageName)) {
            this._loadedPackages.add(packageName);
        }
        if ((url = classLoader.getResource(ResolveHelpers.getQualifiedFileName(".castor.cdr", packageName))) == null) {
            return results;
        }
        try {
            Properties cdrList = this.getProperties(url);
            for (Object clazz : cdrList.keySet()) {
                String clazzName = (String)clazz;
                String descriptorClassName = (String)cdrList.get(clazzName);
                try {
                    Class<?> descriptorClass = classLoader.loadClass(descriptorClassName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found descriptor: " + descriptorClass);
                    }
                    if (descriptorClass != null) {
                        ClassDescriptor instance = (ClassDescriptor)descriptorClass.newInstance();
                        results.put(clazzName, instance);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Loading of descriptor class: " + descriptorClassName + " for class: " + clazzName + " has failed - continue without");
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Ignored problem at loading of: " + descriptorClassName + " with exception: " + e);
                }
            }
        }
        catch (IOException iox) {
            String message = "Failed to load package: " + packageName + " with exception: " + iox;
            LOG.warn(message);
            throw new ResolverException(message);
        }
        return results;
    }
}

