/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cm;

import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.cm.CMConfiguration;
import org.apache.camel.component.cm.CMEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(CMComponent.class);
    private Validator validator;

    public CMComponent() {
        super(CMEndpoint.class);
    }

    public CMComponent(CamelContext context) {
        super(context, CMEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CMConfiguration config = new CMConfiguration();
        this.setProperties(config, parameters);
        LOG.debug("Validating uri based configuration");
        Set<ConstraintViolation<CMConfiguration>> constraintViolations = this.getValidator().validate(config, new Class[0]);
        if (constraintViolations.size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (ConstraintViolation<CMConfiguration> cv : constraintViolations) {
                msg.append(String.format("- Invalid value for %s: %s", cv.getPropertyPath().toString(), cv.getMessage()));
            }
            throw new ResolveEndpointFailedException(uri, msg.toString());
        }
        CMEndpoint endpoint = new CMEndpoint(uri, this);
        endpoint.setConfiguration(config);
        endpoint.setHost(remaining);
        return endpoint;
    }

    public Validator getValidator() {
        if (this.validator == null) {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            this.validator = factory.getValidator();
        }
        return this.validator;
    }
}

