/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.data.PropertyData;

public final class CMISHelper {
    private CMISHelper() {
    }

    public static Map<String, Object> filterCMISProperties(Map<String, Object> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (!entry.getKey().startsWith("cmis:")) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, Object> objectProperties(CmisObject cmisObject) {
        List<Property<?>> propertyList = cmisObject.getProperties();
        return CMISHelper.propertyDataToMap(propertyList);
    }

    public static Map<String, Object> propertyDataToMap(List<? extends PropertyData<?>> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (PropertyData<?> propertyData : properties) {
            result.put(propertyData.getId(), propertyData.getFirstValue());
        }
        return result;
    }

    public static boolean isFolder(CmisObject cmisObject) {
        return "cmis:folder".equals(CMISHelper.getObjectTypeId(cmisObject));
    }

    public static boolean isDocument(CmisObject cmisObject) {
        return "cmis:document".equals(CMISHelper.getObjectTypeId(cmisObject));
    }

    public static Object getObjectTypeId(CmisObject child) {
        return child.getPropertyValue("cmis:objectTypeId");
    }
}

