/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cmis;

import java.io.InputStream;
import java.util.Map;
import org.apache.camel.component.cmis.CMISConsumer;
import org.apache.camel.component.cmis.CMISHelper;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveTreeWalker {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveTreeWalker.class);
    private final CMISConsumer cmisConsumer;
    private final boolean readContent;
    private final int readCount;
    private final int pageSize;
    private int totalPolled;

    public RecursiveTreeWalker(CMISConsumer cmisConsumer, boolean readContent, int readCount, int pageSize) {
        this.cmisConsumer = cmisConsumer;
        this.readContent = readContent;
        this.readCount = readCount;
        this.pageSize = pageSize;
    }

    int processFolderRecursively(Folder folder) throws Exception {
        this.processFolderNode(folder);
        OperationContext operationContext = this.cmisConsumer.createOperationContext();
        operationContext.setMaxItemsPerPage(this.pageSize);
        int count = 0;
        int pageNumber = 0;
        boolean finished = false;
        ItemIterable<CmisObject> itemIterable = folder.getChildren(operationContext);
        while (!finished) {
            ItemIterable<CmisObject> currentPage = itemIterable.skipTo(count).getPage();
            LOG.debug("Processing page {}", (Object)pageNumber);
            for (CmisObject child : currentPage) {
                if (CMISHelper.isFolder(child)) {
                    Folder childFolder = (Folder)child;
                    this.processFolderRecursively(childFolder);
                } else {
                    this.processNonFolderNode(child, folder);
                }
                ++count;
                if (this.totalPolled != this.readCount) continue;
                finished = true;
                break;
            }
            ++pageNumber;
            if (currentPage.getHasMoreItems()) continue;
            finished = true;
        }
        return this.totalPolled;
    }

    private void processNonFolderNode(CmisObject cmisObject, Folder parentFolder) throws Exception {
        ContentStream contentStream;
        InputStream inputStream = null;
        Map<String, Object> properties = CMISHelper.objectProperties(cmisObject);
        properties.put("CamelCMISFolderPath", parentFolder.getPath());
        if (CMISHelper.isDocument(cmisObject) && this.readContent && (contentStream = ((Document)cmisObject).getContentStream()) != null) {
            inputStream = contentStream.getStream();
        }
        this.sendNode(properties, inputStream);
    }

    private void processFolderNode(Folder folder) throws Exception {
        this.sendNode(CMISHelper.objectProperties(folder), null);
    }

    private void sendNode(Map<String, Object> properties, InputStream inputStream) throws Exception {
        this.totalPolled += this.cmisConsumer.sendExchangeWithPropsAndBody(properties, inputStream);
    }
}

