/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthenticationProvider
extends StandardAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthAuthenticationProvider.class);
    private static final long serialVersionUID = 1L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Token token = null;
    private long defaultTokenLifetime = 3600L;
    private List<TokenListener> tokenListeners;

    @Override
    public void setSession(BindingSession session) {
        super.setSession(session);
        if (this.token == null) {
            String accessToken = null;
            if (session.get("org.apache.chemistry.opencmis.oauth.accessToken") instanceof String) {
                accessToken = (String)session.get("org.apache.chemistry.opencmis.oauth.accessToken");
            }
            String refreshToken = null;
            if (session.get("org.apache.chemistry.opencmis.oauth.refreshToken") instanceof String) {
                refreshToken = (String)session.get("org.apache.chemistry.opencmis.oauth.refreshToken");
            }
            long expirationTimestamp = 0L;
            if (session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp") instanceof String) {
                try {
                    expirationTimestamp = Long.parseLong((String)session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp"));
                }
                catch (NumberFormatException nfe) {}
            } else if (session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp") instanceof Number) {
                expirationTimestamp = ((Number)session.get("org.apache.chemistry.opencmis.oauth.expirationTimestamp")).longValue();
            }
            if (session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime") instanceof String) {
                try {
                    this.defaultTokenLifetime = Long.parseLong((String)session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime"));
                }
                catch (NumberFormatException nfe) {}
            } else if (session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime") instanceof Number) {
                this.defaultTokenLifetime = ((Number)session.get("org.apache.chemistry.opencmis.oauth.defaultTokenLifetime")).longValue();
            }
            this.token = new Token(accessToken, refreshToken, expirationTimestamp);
            this.fireTokenListner(this.token);
        }
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders(String url) {
        Map<String, List<String>> headers = super.getHTTPHeaders(url);
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
        }
        headers.put("Authorization", Collections.singletonList("Bearer " + this.getAccessToken()));
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getToken() {
        this.lock.readLock().lock();
        try {
            Token token = this.token;
            return token;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTokenListener(TokenListener listner) {
        if (listner == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.tokenListeners == null) {
                this.tokenListeners = new ArrayList<TokenListener>();
            }
            this.tokenListeners.add(listner);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTokenListener(TokenListener listner) {
        if (listner == null) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.tokenListeners != null) {
                this.tokenListeners.remove(listner);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void fireTokenListner(Token token) {
        if (this.tokenListeners == null) {
            return;
        }
        for (TokenListener listner : this.tokenListeners) {
            listner.tokenRefreshed(token);
        }
    }

    @Override
    protected boolean getSendBearerToken() {
        return false;
    }

    protected String getAccessToken() {
        this.lock.writeLock().lock();
        try {
            if (this.token.getAccessToken() == null) {
                if (this.token.getRefreshToken() == null) {
                    this.requestToken();
                } else {
                    this.refreshToken();
                }
            } else if (this.token.isExpired()) {
                this.refreshToken();
            }
            String string = this.token.getAccessToken();
            return string;
        }
        catch (CmisConnectionException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot get OAuth access token: " + e.getMessage(), e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void requestToken() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requesting new OAuth access token.");
        }
        this.makeRequest(false);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.token.toString());
        }
    }

    private void refreshToken() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Refreshing OAuth access token.");
        }
        this.makeRequest(true);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.token.toString());
        }
    }

    private void makeRequest(boolean isRefresh) throws IOException {
        Object clientSecret;
        Object tokenEndpoint = this.getSession().get("org.apache.chemistry.opencmis.oauth.tokenEndpoint");
        if (!(tokenEndpoint instanceof String)) {
            throw new CmisConnectionException("Token endpoint not set!");
        }
        if (isRefresh && this.token.getRefreshToken() == null) {
            throw new CmisConnectionException("No refresh token!");
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(tokenEndpoint.toString()).openConnection();
        conn.setRequestMethod("POST");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        conn.setRequestProperty("User-Agent", ClientVersion.OPENCMIS_CLIENT);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
        if (isRefresh) {
            writer.write("grant_type=refresh_token");
            writer.write("&refresh_token=");
            writer.write(IOUtils.encodeURL(this.token.getRefreshToken()));
        } else {
            Object redirectUri;
            writer.write("grant_type=authorization_code");
            Object code = this.getSession().get("org.apache.chemistry.opencmis.oauth.code");
            if (code != null) {
                writer.write("&code=");
                writer.write(IOUtils.encodeURL(code.toString()));
            }
            if ((redirectUri = this.getSession().get("org.apache.chemistry.opencmis.oauth.redirectUri")) != null) {
                writer.write("&redirect_uri=");
                writer.write(IOUtils.encodeURL(redirectUri.toString()));
            }
        }
        Object clientId = this.getSession().get("org.apache.chemistry.opencmis.oauth.clientId");
        if (clientId != null) {
            writer.write("&client_id=");
            writer.write(IOUtils.encodeURL(clientId.toString()));
        }
        if ((clientSecret = this.getSession().get("org.apache.chemistry.opencmis.oauth.clientSecret")) != null) {
            writer.write("&client_secret=");
            writer.write(IOUtils.encodeURL(clientSecret.toString()));
        }
        ((Writer)writer).flush();
        conn.connect();
        if (conn.getResponseCode() != 200) {
            String uriStr;
            JSONObject jsonResponse = this.parseResponse(conn);
            Object error = jsonResponse.get("error");
            String errorStr = error == null ? null : error.toString();
            Object description = jsonResponse.get("error_description");
            String descriptionStr = description == null ? null : description.toString();
            Object uri = jsonResponse.get("error_uri");
            String string = uriStr = uri == null ? null : uri.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("OAuth token request failed: {}", (Object)jsonResponse.toJSONString());
            }
            throw new CmisOAuthException("OAuth token request failed" + (errorStr == null ? "" : ": " + errorStr) + (descriptionStr == null ? "" : ": " + descriptionStr), errorStr, descriptionStr, uriStr);
        }
        JSONObject jsonResponse = this.parseResponse(conn);
        Object tokenType = jsonResponse.get("token_type");
        if (!(tokenType instanceof String) || !"bearer".equalsIgnoreCase((String)tokenType)) {
            throw new CmisOAuthException("Unsupported OAuth token type: " + tokenType);
        }
        Object jsonAccessToken = jsonResponse.get("access_token");
        if (!(jsonAccessToken instanceof String)) {
            throw new CmisOAuthException("Invalid OAuth access_token!");
        }
        Object jsonRefreshToken = jsonResponse.get("refresh_token");
        if (jsonRefreshToken != null && !(jsonRefreshToken instanceof String)) {
            throw new CmisOAuthException("Invalid OAuth refresh_token!");
        }
        long expiresIn = this.defaultTokenLifetime;
        Object jsonExpiresIn = jsonResponse.get("expires_in");
        if (jsonExpiresIn != null) {
            if (jsonExpiresIn instanceof Number) {
                expiresIn = ((Number)jsonExpiresIn).longValue();
            } else if (jsonExpiresIn instanceof String) {
                try {
                    expiresIn = Long.parseLong((String)jsonExpiresIn);
                }
                catch (NumberFormatException nfe) {
                    throw new CmisOAuthException("Invalid OAuth expires_in value!");
                }
            } else {
                throw new CmisOAuthException("Invalid OAuth expires_in value!");
            }
            if (expiresIn <= 0L) {
                expiresIn = this.defaultTokenLifetime;
            }
        }
        this.token = new Token(jsonAccessToken.toString(), jsonRefreshToken == null ? null : jsonRefreshToken.toString(), expiresIn * 1000L + System.currentTimeMillis());
        this.fireTokenListner(this.token);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject parseResponse(HttpURLConnection conn) {
        JSONObject jSONObject;
        InputStreamReader reader = null;
        try {
            InputStream stream = null;
            int respCode = conn.getResponseCode();
            if (respCode == 401) {
                String string;
                Map<String, Map<String, String>> challenges = MimeHelper.getChallengesFromAuthenticateHeader(conn.getHeaderField("WWW-Authenticate"));
                if (challenges == null) throw new CmisOAuthException("Unauthorized!");
                if (!challenges.containsKey("bearer")) throw new CmisOAuthException("Unauthorized!");
                Map<String, String> params = challenges.get("bearer");
                String errorStr = params.get("error");
                String descriptionStr = params.get("error_description");
                String uriStr = params.get("error_uri");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalid OAuth token: {}", (Object)params.toString());
                }
                StringBuilder stringBuilder = new StringBuilder().append("Unauthorized").append(errorStr == null ? "" : ": " + errorStr);
                if (descriptionStr == null) {
                    string = "";
                    throw new CmisOAuthException(stringBuilder.append(string).toString(), errorStr, descriptionStr, uriStr);
                }
                string = ": " + descriptionStr;
                throw new CmisOAuthException(stringBuilder.append(string).toString(), errorStr, descriptionStr, uriStr);
            }
            stream = respCode >= 200 && respCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            if (stream == null) {
                throw new CmisOAuthException("Invalid OAuth token response!");
            }
            JSONParser parser = new JSONParser();
            reader = new InputStreamReader(stream, this.extractCharset(conn));
            Object response = parser.parse(reader);
            if (!(response instanceof JSONObject)) {
                throw new CmisOAuthException("Invalid OAuth token response!");
            }
            jSONObject = (JSONObject)response;
        }
        catch (CmisConnectionException ce) {
            try {
                throw ce;
                catch (Exception pe) {
                    throw new CmisOAuthException("Parsing the OAuth token response failed: " + pe.getMessage(), pe);
                }
            }
            catch (Throwable throwable) {
                IOUtils.consumeAndClose(reader);
                throw throwable;
            }
        }
        IOUtils.consumeAndClose(reader);
        return jSONObject;
    }

    private String extractCharset(HttpURLConnection conn) {
        String charset = "UTF-8";
        String contentType = conn.getContentType();
        if (contentType != null) {
            String[] parts = contentType.split(";");
            for (int i = 1; i < parts.length; ++i) {
                String part = parts[i].trim().toLowerCase(Locale.ENGLISH);
                if (!part.startsWith("charset")) continue;
                int x = part.indexOf(61);
                charset = part.substring(x + 1).trim();
                break;
            }
        }
        return charset;
    }

    public static class CmisOAuthException
    extends CmisConnectionException {
        private static final long serialVersionUID = 1L;
        public static final String ERROR_INVALID_REQUEST = "invalid_request";
        public static final String ERROR_INVALID_CLIENT = "invalid_client";
        public static final String ERROR_INVALID_GRANT = "invalid_grant";
        public static final String ERROR_UNAUTHORIZED_CLIENT = "unauthorized_client";
        public static final String ERROR_UNSUPPORTED_GRANT_TYPE = "unsupported_grant_type";
        public static final String ERROR_INVALID_SCOPE = "invalid_scope";
        public static final String ERROR_INVALID_TOKEN = "invalid_token";
        private String error;
        private String errorDescription;
        private String errorUri;

        public CmisOAuthException() {
        }

        public CmisOAuthException(String message) {
            super(message);
        }

        public CmisOAuthException(String message, Throwable cause) {
            super(message, cause);
        }

        public CmisOAuthException(String message, String error, String errorDescription, String errorUri) {
            super(message);
            this.error = error;
            this.errorDescription = errorDescription;
            this.errorUri = errorUri;
        }

        public String getError() {
            return this.error;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }

        public String getErrorUri() {
            return this.errorUri;
        }
    }

    public static interface TokenListener {
        public void tokenRefreshed(Token var1);
    }

    public static class Token {
        private String accessToken;
        private String refreshToken;
        private long expirationTimestamp;

        public Token(String accessToken, String refreshToken, long expirationTimestamp) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expirationTimestamp = expirationTimestamp;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public long getExpirationTimestamp() {
            return this.expirationTimestamp;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expirationTimestamp;
        }

        public String toString() {
            return "Access token: " + this.accessToken + " / Refresh token: " + this.refreshToken + " / Expires : " + this.expirationTimestamp;
        }
    }
}

