/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.cookies.CmisCookieManager;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StandardAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    protected static final String WSSE_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    protected static final String WSU_NAMESPACE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private CmisCookieManager cookieManager;
    private Map<String, List<String>> fixedHeaders = new HashMap<String, List<String>>();

    @Override
    public void setSession(BindingSession session) {
        String token;
        boolean sendBearerToken;
        super.setSession(session);
        boolean sendBasicAuth = this.getSendBasicAuth();
        if (this.getHandleCookies() && this.cookieManager == null) {
            this.cookieManager = new CmisCookieManager(session.getSessionId());
        }
        if (sendBasicAuth) {
            String user = this.getUser();
            String password = this.getPassword();
            if (user != null) {
                this.fixedHeaders.put("Authorization", this.createBasicAuthHeaderValue(user, password));
            }
        }
        if ((sendBearerToken = this.getSendBearerToken()) && (token = this.getBearerToken()) != null) {
            this.fixedHeaders.put("Authorization", Collections.singletonList("Bearer " + token));
        }
        if (this.getProxyUser() != null) {
            String proxyUser = this.getProxyUser();
            String proxyPassword = this.getProxyPassword();
            this.fixedHeaders.put("Proxy-Authorization", this.createBasicAuthHeaderValue(proxyUser, proxyPassword));
        }
        this.addSessionParameterHeadersToFixedHeaders();
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders(String url) {
        Map<String, List<String>> cookies;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(this.fixedHeaders);
        if (this.cookieManager != null && !(cookies = this.cookieManager.get(url, result)).isEmpty()) {
            result.putAll(cookies);
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public void putResponseHeaders(String url, int statusCode, Map<String, List<String>> headers) {
        if (this.cookieManager != null) {
            this.cookieManager.put(url, headers);
        }
    }

    @Override
    public Element getSOAPHeaders(Object portObject) {
        if (!this.getSendUsernameToken()) {
            return null;
        }
        String user = this.getUser();
        String password = this.getPassword();
        if (user == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        long created = System.currentTimeMillis();
        long expires = created + 86400000L;
        try {
            Document document = XMLUtils.newDomDocument();
            Element wsseSecurityElement = document.createElementNS(WSSE_NAMESPACE, "Security");
            Element wsuTimestampElement = document.createElementNS(WSU_NAMESPACE, "Timestamp");
            wsseSecurityElement.appendChild(wsuTimestampElement);
            Element tsCreatedElement = document.createElementNS(WSU_NAMESPACE, "Created");
            tsCreatedElement.appendChild(document.createTextNode(DateTimeHelper.formatXmlDateTime(created)));
            wsuTimestampElement.appendChild(tsCreatedElement);
            Element tsExpiresElement = document.createElementNS(WSU_NAMESPACE, "Expires");
            tsExpiresElement.appendChild(document.createTextNode(DateTimeHelper.formatXmlDateTime(expires)));
            wsuTimestampElement.appendChild(tsExpiresElement);
            Element usernameTokenElement = document.createElementNS(WSSE_NAMESPACE, "UsernameToken");
            wsseSecurityElement.appendChild(usernameTokenElement);
            Element usernameElement = document.createElementNS(WSSE_NAMESPACE, "Username");
            usernameElement.appendChild(document.createTextNode(user));
            usernameTokenElement.appendChild(usernameElement);
            Element passwordElement = document.createElementNS(WSSE_NAMESPACE, "Password");
            passwordElement.appendChild(document.createTextNode(password));
            passwordElement.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            usernameTokenElement.appendChild(passwordElement);
            Element createdElement = document.createElementNS(WSU_NAMESPACE, "Created");
            createdElement.appendChild(document.createTextNode(DateTimeHelper.formatXmlDateTime(created)));
            usernameTokenElement.appendChild(createdElement);
            return wsseSecurityElement;
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Could not build SOAP header: " + e.getMessage(), e);
        }
    }

    protected Map<String, List<String>> getFixedHeaders() {
        return this.fixedHeaders;
    }

    protected void addSessionParameterHeadersToFixedHeaders() {
        Object headerParam;
        int x = 0;
        while ((headerParam = this.getSession().get("org.apache.chemistry.opencmis.binding.header." + x)) != null) {
            String key;
            String header = headerParam.toString();
            int colon = header.indexOf(58);
            if (colon > -1 && (key = header.substring(0, colon).trim()).length() > 0) {
                String value = header.substring(colon + 1).trim();
                List<String> values = this.fixedHeaders.get(key);
                if (values == null) {
                    this.fixedHeaders.put(key, Collections.singletonList(value));
                } else {
                    ArrayList<String> newValues = new ArrayList<String>(values);
                    newValues.add(value);
                    this.fixedHeaders.put(key, newValues);
                }
            }
            ++x;
        }
    }

    protected List<String> createBasicAuthHeaderValue(String username, String password) {
        byte[] usernamePassword;
        Object charset;
        if (password == null) {
            password = "";
        }
        charset = (charset = this.getSession().get("org.apache.chemistry.opencmis.binding.auth.http.basic.charset")) instanceof String ? ((String)charset).trim() : "UTF-8";
        try {
            usernamePassword = (username + ":" + password).getBytes((String)charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new CmisRuntimeException("Unsupported encoding '" + charset + "'!", e);
        }
        return Collections.singletonList("Basic " + Base64.encodeBytes(usernamePassword));
    }

    protected boolean getSendBasicAuth() {
        return this.getSession().get("org.apache.chemistry.opencmis.binding.auth.http.basic", false);
    }

    protected boolean getSendBearerToken() {
        return this.getSession().get("org.apache.chemistry.opencmis.binding.auth.http.oauth.bearer", false);
    }

    protected boolean getSendUsernameToken() {
        return this.getSession().get("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", false);
    }

    protected boolean getHandleCookies() {
        return this.getSession().get("org.apache.chemistry.opencmis.binding.cookies", false);
    }
}

