/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomBase;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;

public class NavigationServiceImpl
extends AbstractAtomPubService
implements NavigationService {
    public NavigationServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        String link = this.loadLink(repositoryId, folderId, "down", "application/atom+xml;type=feed");
        if (link == null) {
            this.throwLinkException(repositoryId, folderId, "down", "application/atom+xml;type=feed");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("filter", filter);
        url.addParameter("orderBy", orderBy);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includePathSegment", includePathSegment);
        url.addParameter("maxItems", maxItems);
        url.addParameter("skipCount", skipCount);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                continue;
            }
            if (!this.isInt("numItems", element)) continue;
            result.setNumItems((BigInteger)element.getObject());
        }
        if (!feed.getEntries().isEmpty()) {
            result.setObjects(new ArrayList<ObjectInFolderData>(feed.getEntries().size()));
            for (AtomEntry entry : feed.getEntries()) {
                ObjectInFolderDataImpl child = null;
                String pathSegment = null;
                this.lockLinks();
                try {
                    this.removeLinks(repositoryId, entry.getId());
                    for (AtomElement element : entry.getElements()) {
                        if (element.getObject() instanceof AtomLink) {
                            this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                            continue;
                        }
                        if (this.isStr("pathSegment", element)) {
                            pathSegment = (String)element.getObject();
                            continue;
                        }
                        if (!(element.getObject() instanceof ObjectData)) continue;
                        child = new ObjectInFolderDataImpl();
                        child.setObject((ObjectData)element.getObject());
                    }
                }
                finally {
                    this.unlockLinks();
                }
                if (child == null) continue;
                child.setPathSegment(pathSegment);
                result.getObjects().add(child);
            }
        }
        return result;
    }

    @Override
    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        String link = this.loadLink(repositoryId, folderId, "down", "application/cmistree+xml");
        if (link == null) {
            this.throwLinkException(repositoryId, folderId, "down", "application/cmistree+xml");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("depth", depth);
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includePathSegment", includePathSegment);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        this.addDescendantsLevel(repositoryId, feed, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        ObjectData result = null;
        String link = this.loadLink(repositoryId, folderId, "up", "application/atom+xml;type=entry");
        if (link == null) {
            this.throwLinkException(repositoryId, folderId, "up", "application/atom+xml;type=entry");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("filter", filter);
        Response resp = this.read(url);
        AtomBase base = this.parse(resp.getStream(), AtomBase.class);
        AtomEntry entry = null;
        if (base instanceof AtomFeed) {
            AtomFeed feed = (AtomFeed)base;
            if (feed.getEntries().isEmpty()) {
                throw new CmisRuntimeException("Parent feed is empty!");
            }
            entry = feed.getEntries().get(0);
        } else if (base instanceof AtomEntry) {
            entry = (AtomEntry)base;
        } else {
            throw new CmisRuntimeException("Unexpected document!");
        }
        this.lockLinks();
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (element.getObject() instanceof AtomLink) {
                    this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof ObjectData)) continue;
                result = (ObjectData)element.getObject();
            }
        }
        finally {
            this.unlockLinks();
        }
        return result;
    }

    @Override
    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
        String link = this.loadLink(repositoryId, folderId, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/cmistree+xml");
        if (link == null) {
            this.throwLinkException(repositoryId, folderId, "http://docs.oasis-open.org/ns/cmis/link/200908/foldertree", "application/cmistree+xml");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("depth", depth);
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includePathSegment", includePathSegment);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        this.addDescendantsLevel(repositoryId, feed, result);
        return result;
    }

    @Override
    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        AtomEntry entry;
        ObjectParentDataImpl objectParent;
        ArrayList<ObjectParentData> result = new ArrayList<ObjectParentData>();
        String link = this.loadLink(repositoryId, objectId, "up", "application/atom+xml;type=feed");
        if (link == null) {
            return result;
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("filter", filter);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("includeRelativePathSegment", includeRelativePathSegment);
        Response resp = this.read(url);
        AtomBase base = this.parse(resp.getStream(), AtomBase.class);
        if (base instanceof AtomFeed) {
            AtomFeed feed = (AtomFeed)base;
            for (AtomEntry entry2 : feed.getEntries()) {
                ObjectParentDataImpl objectParent2 = this.processParentEntry(entry2, repositoryId);
                if (objectParent2 == null) continue;
                result.add(objectParent2);
            }
        } else if (base instanceof AtomEntry && (objectParent = this.processParentEntry(entry = (AtomEntry)base, repositoryId)) != null) {
            result.add(objectParent);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectParentDataImpl processParentEntry(AtomEntry entry, String repositoryId) {
        ObjectParentDataImpl result = null;
        String relativePathSegment = null;
        this.lockLinks();
        try {
            this.removeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (element.getObject() instanceof AtomLink) {
                    this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (element.getObject() instanceof ObjectData) {
                    result = new ObjectParentDataImpl((ObjectData)element.getObject());
                    continue;
                }
                if (!this.is("relativePathSegment", element)) continue;
                relativePathSegment = (String)element.getObject();
            }
        }
        finally {
            this.unlockLinks();
        }
        if (result != null) {
            result.setRelativePathSegment(relativePathSegment);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectListImpl result = new ObjectListImpl();
        String link = this.loadCollection(repositoryId, "checkedout");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or checkedout collection not supported!");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("folderId", folderId);
        url.addParameter("filter", filter);
        url.addParameter("orderBy", orderBy);
        url.addParameter("includeAllowableActions", includeAllowableActions);
        url.addParameter("includeRelationships", (Object)includeRelationships);
        url.addParameter("renditionFilter", renditionFilter);
        url.addParameter("maxItems", maxItems);
        url.addParameter("skipCount", skipCount);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                continue;
            }
            if (!this.isInt("numItems", element)) continue;
            result.setNumItems((BigInteger)element.getObject());
        }
        if (!feed.getEntries().isEmpty()) {
            result.setObjects(new ArrayList<ObjectData>(feed.getEntries().size()));
            for (AtomEntry entry : feed.getEntries()) {
                ObjectData child = null;
                this.lockLinks();
                try {
                    this.removeLinks(repositoryId, entry.getId());
                    for (AtomElement element : entry.getElements()) {
                        if (element.getObject() instanceof AtomLink) {
                            this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                            continue;
                        }
                        if (!(element.getObject() instanceof ObjectData)) continue;
                        child = (ObjectData)element.getObject();
                    }
                }
                finally {
                    this.unlockLinks();
                }
                if (child == null) continue;
                result.getObjects().add(child);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDescendantsLevel(String repositoryId, AtomFeed feed, List<ObjectInFolderContainer> containerList) {
        if (feed == null || feed.getEntries().isEmpty()) {
            return;
        }
        for (AtomEntry entry : feed.getEntries()) {
            ObjectInFolderDataImpl objectInFolder = null;
            String pathSegment = null;
            ArrayList<ObjectInFolderContainer> childContainerList = new ArrayList<ObjectInFolderContainer>();
            this.lockLinks();
            try {
                this.removeLinks(repositoryId, entry.getId());
                for (AtomElement element : entry.getElements()) {
                    if (element.getObject() instanceof AtomLink) {
                        this.addLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                        continue;
                    }
                    if (element.getObject() instanceof ObjectData) {
                        objectInFolder = new ObjectInFolderDataImpl((ObjectData)element.getObject());
                        continue;
                    }
                    if (this.is("pathSegment", element)) {
                        pathSegment = (String)element.getObject();
                        continue;
                    }
                    if (!(element.getObject() instanceof AtomFeed)) continue;
                    this.addDescendantsLevel(repositoryId, (AtomFeed)element.getObject(), childContainerList);
                }
            }
            finally {
                this.unlockLinks();
            }
            if (objectInFolder == null) continue;
            objectInFolder.setPathSegment(pathSegment);
            ObjectInFolderContainerImpl childContainer = new ObjectInFolderContainerImpl(objectInFolder);
            childContainer.setChildren(childContainerList);
            containerList.add(childContainer);
        }
    }
}

