/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.DateTimeFormat;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeHelper;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public final class FormDataWriter {
    private static final String CONTENT_TYPE_URLENCODED = "application/x-www-form-urlencoded;charset=utf-8";
    private static final String CONTENT_TYPE_FORMDATA = "multipart/form-data; boundary=";
    private static final String CRLF = "\r\n";
    private static final int BUFFER_SIZE = 65536;
    private final String boundary;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private ContentStream contentStream;

    public FormDataWriter(String action) {
        this(action, null);
    }

    public FormDataWriter(String action, ContentStream contentStream) {
        this.addParameter("cmisaction", action);
        this.contentStream = contentStream;
        this.boundary = "aPacHeCheMIStryoPEncmiS" + Long.toHexString(action.hashCode()) + action + Long.toHexString(System.currentTimeMillis()) + Long.toHexString(this.hashCode());
    }

    public void addParameter(String name, Object value) {
        if (name == null || value == null) {
            return;
        }
        this.parameters.put(name, UrlBuilder.normalizeParameter(value));
    }

    public void addPropertiesParameters(Properties properties, DateTimeFormat dateTimeFormat) {
        if (properties == null) {
            return;
        }
        int idx = 0;
        for (PropertyData<?> prop : properties.getPropertyList()) {
            if (prop == null) continue;
            String idxStr = "[" + idx + "]";
            this.addParameter("propertyId" + idxStr, prop.getId());
            if (CollectionsHelper.isNotEmpty(prop.getValues())) {
                if (prop.getValues().size() == 1) {
                    this.addParameter("propertyValue" + idxStr, this.convertPropertyValue(prop.getFirstValue(), dateTimeFormat));
                } else {
                    int vidx = 0;
                    for (Object obj : prop.getValues()) {
                        String vidxStr = "[" + vidx + "]";
                        this.addParameter("propertyValue" + idxStr + vidxStr, this.convertPropertyValue(obj, dateTimeFormat));
                        ++vidx;
                    }
                }
            }
            ++idx;
        }
    }

    public void addSuccinctFlag(boolean succinct) {
        if (succinct) {
            this.addParameter("succinct", "true");
        }
    }

    public void addPoliciesParameters(List<String> policies) {
        if (policies == null) {
            return;
        }
        int idx = 0;
        for (String policy : policies) {
            if (policy == null) continue;
            String idxStr = "[" + idx + "]";
            this.addParameter("policy" + idxStr, policy);
            ++idx;
        }
    }

    public void addAddAcesParameters(Acl acl) {
        this.addAcesParameters(acl, "addACEPrincipal", "addACEPermission");
    }

    public void addRemoveAcesParameters(Acl acl) {
        this.addAcesParameters(acl, "removeACEPrincipal", "removeACEPermission");
    }

    private void addAcesParameters(Acl acl, String principalControl, String permissionControl) {
        if (acl == null || acl.getAces() == null) {
            return;
        }
        int idx = 0;
        for (Ace ace : acl.getAces()) {
            if (ace.getPrincipalId() == null || !CollectionsHelper.isNotEmpty(ace.getPermissions())) continue;
            String idxStr = "[" + idx + "]";
            this.addParameter(principalControl + idxStr, ace.getPrincipalId());
            int permIdx = 0;
            for (String perm : ace.getPermissions()) {
                if (perm == null) continue;
                String permIdxStr = "[" + permIdx + "]";
                this.addParameter(permissionControl + idxStr + permIdxStr, perm);
                ++permIdx;
            }
            ++idx;
        }
    }

    public void addObjectIdsAndChangeTokens(List<BulkUpdateObjectIdAndChangeToken> objectIdsAndChangeTokens) {
        if (CollectionsHelper.isNullOrEmpty(objectIdsAndChangeTokens)) {
            return;
        }
        int idx = 0;
        for (BulkUpdateObjectIdAndChangeToken oc : objectIdsAndChangeTokens) {
            if (oc == null || oc.getId() == null || oc.getId().length() == 0) continue;
            String idxStr = "[" + idx + "]";
            this.addParameter("objectId" + idxStr, oc.getId());
            this.addParameter("changeToken" + idxStr, oc.getChangeToken() == null ? "" : oc.getChangeToken());
            ++idx;
        }
    }

    public void addSecondaryTypeIds(List<String> secondaryTypeIds) {
        this.addSecondaryTypeIdParameters(secondaryTypeIds, "addSecondaryTypeId");
    }

    public void removeSecondaryTypeIds(List<String> secondaryTypeIds) {
        this.addSecondaryTypeIdParameters(secondaryTypeIds, "removeSecondaryTypeId");
    }

    private void addSecondaryTypeIdParameters(List<String> secondaryTypeIds, String secondaryTypeIdControl) {
        if (CollectionsHelper.isNullOrEmpty(secondaryTypeIds)) {
            return;
        }
        int idx = 0;
        for (String typeId : secondaryTypeIds) {
            if (typeId == null || typeId.length() == 0) continue;
            String idxStr = "[" + idx + "]";
            this.addParameter(secondaryTypeIdControl + idxStr, typeId);
            ++idx;
        }
    }

    private String convertPropertyValue(Object value, DateTimeFormat dateTimeFormat) {
        if (value == null) {
            return null;
        }
        if (value instanceof GregorianCalendar) {
            if (dateTimeFormat == DateTimeFormat.EXTENDED) {
                return DateTimeHelper.formatXmlDateTime((GregorianCalendar)value);
            }
            return String.valueOf(((GregorianCalendar)value).getTimeInMillis());
        }
        return value.toString();
    }

    public String getContentType() {
        return this.contentStream == null ? CONTENT_TYPE_URLENCODED : CONTENT_TYPE_FORMDATA + this.boundary;
    }

    public void write(OutputStream out) throws IOException {
        InputStream stream;
        InputStream inputStream = stream = this.contentStream == null ? null : this.contentStream.getStream();
        if (stream == null) {
            boolean first = true;
            byte[] amp = IOUtils.toUTF8Bytes("&");
            for (Map.Entry<String, String> param : this.parameters.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    out.write(amp);
                }
                out.write(IOUtils.toUTF8Bytes(param.getKey() + "=" + URLEncoder.encode(param.getValue(), "UTF-8")));
            }
        } else {
            String mediaType;
            this.writeLine(out);
            for (Map.Entry<String, String> param : this.parameters.entrySet()) {
                this.writeLine(out, "--" + this.boundary);
                this.writeLine(out, "Content-Disposition: form-data; name=\"" + param.getKey() + "\"");
                this.writeLine(out, "Content-Type: text/plain; charset=utf-8");
                this.writeLine(out);
                this.writeLine(out, param.getValue());
            }
            String filename = this.contentStream.getFileName();
            if (filename == null || filename.length() == 0) {
                filename = "content";
            }
            if ((mediaType = this.contentStream.getMimeType()) == null || mediaType.indexOf(47) < 1 || mediaType.indexOf(10) > -1 || mediaType.indexOf(13) > -1) {
                mediaType = "application/octet-stream";
            }
            this.writeLine(out, "--" + this.boundary);
            this.writeLine(out, "Content-Disposition: " + MimeHelper.encodeContentDisposition("form-data; name=\"content\"", filename));
            this.writeLine(out, "Content-Type: " + mediaType);
            this.writeLine(out, "Content-Transfer-Encoding: binary");
            this.writeLine(out);
            IOUtils.copy(stream, out, 65536);
            this.writeLine(out);
            this.writeLine(out, "--" + this.boundary + "--");
        }
    }

    private void writeLine(OutputStream out) throws IOException {
        this.writeLine(out, null);
    }

    private void writeLine(OutputStream out, String s) throws IOException {
        s = s == null ? CRLF : s + CRLF;
        out.write(IOUtils.toUTF8Bytes(s));
    }
}

