/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public abstract class AbstractCmisObject
implements CmisObject,
Serializable {
    private static final long serialVersionUID = 1L;
    private SessionImpl session;
    private ObjectType objectType;
    private List<SecondaryType> secondaryTypes;
    private Map<String, Property<?>> properties;
    private AllowableActions allowableActions;
    private List<Rendition> renditions;
    private Acl acl;
    private List<Policy> policies;
    private List<Relationship> relationships;
    private Map<ExtensionLevel, List<CmisExtensionElement>> extensions;
    private OperationContext creationContext;
    private long refreshTimestamp;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    protected void initialize(SessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        if (session == null) {
            throw new IllegalArgumentException("Session must be set!");
        }
        if (objectType == null) {
            throw new IllegalArgumentException("Object type must be set!");
        }
        if (objectType.getPropertyDefinitions() == null || objectType.getPropertyDefinitions().size() < 9) {
            throw new IllegalArgumentException("Object type must have property definitions!");
        }
        this.session = session;
        this.objectType = objectType;
        this.secondaryTypes = null;
        this.extensions = new EnumMap<ExtensionLevel, List<CmisExtensionElement>>(ExtensionLevel.class);
        this.creationContext = new OperationContextImpl(context);
        this.refreshTimestamp = System.currentTimeMillis();
        ObjectFactory of = this.getObjectFactory();
        if (objectData != null) {
            if (objectData.getProperties() != null) {
                List<?> stids;
                if (objectData.getProperties().getProperties() != null && objectData.getProperties().getProperties().containsKey("cmis:secondaryObjectTypeIds") && CollectionsHelper.isNotEmpty(stids = objectData.getProperties().getProperties().get("cmis:secondaryObjectTypeIds").getValues())) {
                    this.secondaryTypes = new ArrayList<SecondaryType>();
                    for (String stid : stids) {
                        ObjectType type;
                        if (stid == null || !((type = session.getTypeDefinition(stid)) instanceof SecondaryType)) continue;
                        this.secondaryTypes.add((SecondaryType)type);
                    }
                }
                this.properties = of.convertProperties(objectType, this.secondaryTypes, objectData.getProperties());
                this.extensions.put(ExtensionLevel.PROPERTIES, objectData.getProperties().getExtensions());
            }
            if (objectData.getAllowableActions() != null) {
                this.allowableActions = objectData.getAllowableActions();
                this.extensions.put(ExtensionLevel.ALLOWABLE_ACTIONS, objectData.getAllowableActions().getExtensions());
            }
            if (objectData.getRenditions() != null) {
                this.renditions = new ArrayList<Rendition>();
                for (RenditionData rd : objectData.getRenditions()) {
                    this.renditions.add(of.convertRendition(this.getId(), rd));
                }
            }
            if (objectData.getAcl() != null) {
                this.acl = objectData.getAcl();
                this.extensions.put(ExtensionLevel.ACL, objectData.getAcl().getExtensions());
                if (objectData.isExactAcl() != null) {
                    final Acl objectAcl = objectData.getAcl();
                    final Boolean isExact = objectData.isExactAcl();
                    this.acl = new Acl(){

                        @Override
                        public void setExtensions(List<CmisExtensionElement> extensions) {
                            objectAcl.setExtensions(extensions);
                        }

                        @Override
                        public List<CmisExtensionElement> getExtensions() {
                            return objectAcl.getExtensions();
                        }

                        @Override
                        public Boolean isExact() {
                            return isExact;
                        }

                        @Override
                        public List<Ace> getAces() {
                            return objectAcl.getAces();
                        }
                    };
                }
            }
            if (objectData.getPolicyIds() != null && objectData.getPolicyIds().getPolicyIds() != null) {
                this.policies = new ArrayList<Policy>();
                for (String pid : objectData.getPolicyIds().getPolicyIds()) {
                    CmisObject policy = session.getObject(pid);
                    if (!(policy instanceof Policy)) continue;
                    this.policies.add((Policy)policy);
                }
                this.extensions.put(ExtensionLevel.POLICIES, objectData.getPolicyIds().getExtensions());
            }
            if (objectData.getRelationships() != null) {
                this.relationships = new ArrayList<Relationship>();
                for (ObjectData rod : objectData.getRelationships()) {
                    CmisObject relationship = of.convertObject(rod, this.creationContext);
                    if (!(relationship instanceof Relationship)) continue;
                    this.relationships.add((Relationship)relationship);
                }
            }
            this.extensions.put(ExtensionLevel.OBJECT, objectData.getExtensions());
        }
    }

    protected void writeLock() {
        this.lock.writeLock().lock();
    }

    protected void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    protected void readLock() {
        this.lock.readLock().lock();
    }

    protected void readUnlock() {
        this.lock.readLock().unlock();
    }

    protected SessionImpl getSession() {
        return this.session;
    }

    protected String getRepositoryId() {
        return this.getSession().getRepositoryId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectType getObjectType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    protected CmisBinding getBinding() {
        return this.getSession().getBinding();
    }

    protected ObjectFactory getObjectFactory() {
        return this.getSession().getObjectFactory();
    }

    protected String getObjectId() {
        String objectId = this.getId();
        if (objectId == null) {
            throw new IllegalStateException("Object Id is unknown!");
        }
        return objectId;
    }

    protected OperationContext getCreationContext() {
        return this.creationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getPropertyQueryName(String propertyId) {
        this.readLock();
        try {
            PropertyDefinition<?> propDef = this.objectType.getPropertyDefinitions().get(propertyId);
            if (propDef == null) {
                String string = null;
                return string;
            }
            String string = propDef.getQueryName();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void delete() {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(boolean allVersions) {
        this.readLock();
        try {
            this.getSession().delete(this, allVersions);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public CmisObject updateProperties(Map<String, ?> properties) {
        ObjectId objectId = this.updateProperties(properties, true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectId updateProperties(Map<String, ?> properties, boolean refresh) {
        if (CollectionsHelper.isNullOrEmpty(properties)) {
            throw new IllegalArgumentException("Properties must not be empty!");
        }
        this.readLock();
        String newObjectId = null;
        try {
            String objectId = this.getObjectId();
            Holder<String> objectIdHolder = new Holder<String>(objectId);
            String changeToken = this.getChangeToken();
            Holder<String> changeTokenHolder = new Holder<String>(changeToken);
            EnumSet<Updatability> updatebility = EnumSet.noneOf(Updatability.class);
            updatebility.add(Updatability.READWRITE);
            Boolean isCheckedOut = (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
            if (Boolean.TRUE.equals(isCheckedOut)) {
                updatebility.add(Updatability.WHENCHECKEDOUT);
            }
            this.getBinding().getObjectService().updateProperties(this.getRepositoryId(), objectIdHolder, changeTokenHolder, this.getObjectFactory().convertProperties(properties, this.objectType, this.secondaryTypes, updatebility), null);
            newObjectId = objectIdHolder.getValue();
            this.getSession().removeObjectFromCache(objectId);
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    @Override
    public CmisObject rename(String newName) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("New name must not be empty!");
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("cmis:name", newName);
        return this.updateProperties(prop);
    }

    @Override
    public ObjectId rename(String newName, boolean refresh) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("New name must not be empty!");
        }
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("cmis:name", newName);
        return this.updateProperties(prop, refresh);
    }

    @Override
    public ObjectType getBaseType() {
        BaseTypeId baseTypeId = this.getBaseTypeId();
        if (baseTypeId == null) {
            return null;
        }
        return this.getSession().getTypeDefinition(baseTypeId.value());
    }

    @Override
    public BaseTypeId getBaseTypeId() {
        String baseType = (String)this.getPropertyValue("cmis:baseTypeId");
        if (baseType == null) {
            return null;
        }
        return BaseTypeId.fromValue(baseType);
    }

    @Override
    public String getChangeToken() {
        return (String)this.getPropertyValue("cmis:changeToken");
    }

    @Override
    public String getCreatedBy() {
        return (String)this.getPropertyValue("cmis:createdBy");
    }

    @Override
    public GregorianCalendar getCreationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:creationDate");
    }

    @Override
    public String getId() {
        return (String)this.getPropertyValue("cmis:objectId");
    }

    @Override
    public GregorianCalendar getLastModificationDate() {
        return (GregorianCalendar)this.getPropertyValue("cmis:lastModificationDate");
    }

    @Override
    public String getLastModifiedBy() {
        return (String)this.getPropertyValue("cmis:lastModifiedBy");
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue("cmis:name");
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue("cmis:description");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Property<?>> getProperties() {
        this.readLock();
        try {
            List<Property<?>> list = Collections.unmodifiableList(new ArrayList(this.properties.values()));
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Property<T> getProperty(String id) {
        this.readLock();
        try {
            Property<?> property = this.properties.get(id);
            return property;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public <T> T getPropertyValue(String id) {
        Property<T> property = this.getProperty(id);
        if (property == null) {
            return null;
        }
        return (T)property.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectType getType() {
        this.readLock();
        try {
            ObjectType objectType = this.objectType;
            return objectType;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SecondaryType> getSecondaryTypes() {
        this.readLock();
        try {
            List<SecondaryType> list = this.secondaryTypes;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectType> findObjectType(String id) {
        ArrayList<ObjectType> result = null;
        this.readLock();
        try {
            if (this.objectType.getPropertyDefinitions().containsKey(id)) {
                result = new ArrayList<ObjectType>();
                result.add(this.objectType);
            }
            if (this.secondaryTypes != null) {
                for (SecondaryType secondaryType : this.secondaryTypes) {
                    if (secondaryType.getPropertyDefinitions() == null || !secondaryType.getPropertyDefinitions().containsKey(id)) continue;
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add(secondaryType);
                }
            }
        }
        finally {
            this.readUnlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllowableActions getAllowableActions() {
        this.readLock();
        try {
            AllowableActions allowableActions = this.allowableActions;
            return allowableActions;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public boolean hasAllowableAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Action must be set!");
        }
        AllowableActions currentAllowableActions = this.getAllowableActions();
        if (currentAllowableActions == null || currentAllowableActions.getAllowableActions() == null) {
            throw new IllegalStateException("Allowable Actions are not available!");
        }
        return currentAllowableActions.getAllowableActions().contains((Object)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Rendition> getRenditions() {
        this.readLock();
        try {
            List<Rendition> list = this.renditions;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public Acl getAcl(boolean onlyBasicPermissions) {
        String objectId = this.getObjectId();
        return this.getBinding().getAclService().getAcl(this.getRepositoryId(), objectId, onlyBasicPermissions, null);
    }

    @Override
    public Acl applyAcl(List<Ace> addAces, List<Ace> removeAces, AclPropagation aclPropagation) {
        Acl result = this.getSession().applyAcl(this, addAces, removeAces, aclPropagation);
        this.refresh();
        return result;
    }

    @Override
    public Acl addAcl(List<Ace> addAces, AclPropagation aclPropagation) {
        return this.applyAcl(addAces, null, aclPropagation);
    }

    @Override
    public Acl removeAcl(List<Ace> removeAces, AclPropagation aclPropagation) {
        return this.applyAcl(null, removeAces, aclPropagation);
    }

    @Override
    public Acl setAcl(List<Ace> aces) {
        Acl result = this.getSession().setAcl(this, aces);
        this.refresh();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Acl getAcl() {
        this.readLock();
        try {
            Acl acl = this.acl;
            return acl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Set<String> getPermissionsForPrincipal(String principalId) {
        if (principalId == null) {
            throw new IllegalArgumentException("Principal must be set!");
        }
        Acl currentAcl = this.getAcl();
        if (currentAcl == null) {
            throw new IllegalStateException("ACLs are not available!");
        }
        if (CollectionsHelper.isNullOrEmpty(this.acl.getAces())) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Ace ace : this.acl.getAces()) {
            if (!principalId.equals(ace.getPrincipalId()) || ace.getPermissions() == null) continue;
            result.addAll(ace.getPermissions());
        }
        return result;
    }

    @Override
    public Set<String> getPermissonsForPrincipal(String principalId) {
        return this.getPermissionsForPrincipal(principalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyPolicy(ObjectId ... policyIds) {
        this.readLock();
        try {
            this.getSession().applyPolicy(this, policyIds);
        }
        finally {
            this.readUnlock();
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePolicy(ObjectId ... policyIds) {
        this.readLock();
        try {
            this.getSession().removePolicy(this, policyIds);
        }
        finally {
            this.readUnlock();
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Policy> getPolicies() {
        this.readLock();
        try {
            List<Policy> list = this.policies;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Relationship> getRelationships() {
        this.readLock();
        try {
            List<Relationship> list = this.relationships;
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public List<CmisExtensionElement> getExtensions(ExtensionLevel level) {
        List<CmisExtensionElement> ext = this.extensions.get((Object)level);
        if (ext == null) {
            return null;
        }
        return Collections.unmodifiableList(ext);
    }

    @Override
    public <T> T getAdapter(Class<T> adapterInterface) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRefreshTimestamp() {
        this.readLock();
        try {
            long l = this.refreshTimestamp;
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        this.writeLock();
        try {
            String objectId = this.getObjectId();
            OperationContext oc = this.getCreationContext();
            ObjectData objectData = this.getSession().getBinding().getObjectService().getObject(this.getRepositoryId(), objectId, oc.getFilterString(), oc.isIncludeAllowableActions(), oc.getIncludeRelationships(), oc.getRenditionFilterString(), oc.isIncludePolicies(), oc.isIncludeAcls(), null);
            this.initialize(this.session, this.session.getTypeDefinition(this.objectType.getId()), objectData, this.creationContext);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshIfOld(long durationInMillis) {
        this.writeLock();
        try {
            if (this.refreshTimestamp < System.currentTimeMillis() - durationInMillis) {
                this.refresh();
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.readLock();
        try {
            if (this.objectType == null) {
                String string = "<unknown>";
                return string;
            }
            String string = (Object)((Object)this.objectType.getBaseTypeId()) + " (" + this.objectType.getId() + "): " + this.getId();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }
}

