/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.HashMap;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;

public final class FileUtils {
    private FileUtils() {
    }

    public static CmisObject getObject(String pathOrIdOfObject, Session session) {
        if (session == null) {
            throw new IllegalArgumentException("session must be set!");
        }
        if (pathOrIdOfObject == null || pathOrIdOfObject.length() == 0) {
            throw new IllegalArgumentException("pathOrIdOfObject must be set!");
        }
        CmisObject result = null;
        result = pathOrIdOfObject.charAt(0) == '/' ? session.getObjectByPath(pathOrIdOfObject) : session.getObject(pathOrIdOfObject);
        return result;
    }

    public static Folder getFolder(String pathOrIdOfObject, Session session) {
        CmisObject folder = FileUtils.getObject(pathOrIdOfObject, session);
        if (folder instanceof Folder) {
            return (Folder)folder;
        }
        throw new IllegalArgumentException("Object is not a folder!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocumentFromFile(String parentIdOrPath, File file, String type, VersioningState versioningState, Session session) throws FileNotFoundException {
        if (type == null) {
            type = BaseTypeId.CMIS_DOCUMENT.value();
        }
        Folder parentFolder = FileUtils.getFolder(parentIdOrPath, session);
        String name = file.getName();
        String mimetype = MimeTypes.getMIMEType(file);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        FileInputStream stream = new FileInputStream(file);
        ContentStreamImpl contentStream = new ContentStreamImpl(name, BigInteger.valueOf(file.length()), mimetype, stream);
        try {
            Document document = parentFolder.createDocument(properties, contentStream, versioningState);
            return document;
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException ioe) {
                    throw new CmisRuntimeException("Cannot close source stream!", ioe);
                }
            }
        }
    }

    public static Document createTextDocument(String parentIdOrPath, String name, String content, String type, VersioningState versioningState, Session session) {
        if (type == null) {
            type = BaseTypeId.CMIS_DOCUMENT.value();
        }
        Folder parentFolder = FileUtils.getFolder(parentIdOrPath, session);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        byte[] contentBytes = new byte[]{};
        if (content != null) {
            contentBytes = IOUtils.toUTF8Bytes(content);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(contentBytes);
        ContentStreamImpl contentStream = new ContentStreamImpl(name, BigInteger.valueOf(contentBytes.length), "text/plain", bais);
        return parentFolder.createDocument(properties, contentStream, versioningState);
    }

    public static Folder createFolder(Folder parentFolder, String name, String type) {
        if (type == null) {
            type = BaseTypeId.CMIS_FOLDER.value();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        return parentFolder.createFolder(properties);
    }

    public static Folder createFolder(String parentIdOrPath, String name, String type, Session session) {
        Folder parentFolder = FileUtils.getFolder(parentIdOrPath, session);
        if (type == null) {
            type = BaseTypeId.CMIS_FOLDER.value();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", type);
        properties.put("cmis:name", name);
        return parentFolder.createFolder(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(Document doc, String destinationPath) throws IOException {
        FileOutputStream out = new FileOutputStream(destinationPath);
        try {
            IOUtils.copy(doc.getContentStream().getStream(), out, 65536);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public static void download(String docIdOrPath, String destinationPath, Session session) throws IOException {
        CmisObject doc = FileUtils.getObject(docIdOrPath, session);
        if (!(doc instanceof Document)) {
            throw new IllegalArgumentException("Object is not a document!");
        }
        FileUtils.download((Document)doc, destinationPath);
    }

    public static void delete(String pathOrIdOfObject, Session session) {
        CmisObject object = FileUtils.getObject(pathOrIdOfObject, session);
        if (object instanceof Folder) {
            ((Folder)object).deleteTree(true, UnfileObject.DELETE, true);
        } else {
            object.delete(true);
        }
    }

    public static void printProperties(CmisObject object) {
        FileUtils.printProperties(object, System.out);
    }

    public static void printProperties(CmisObject object, PrintStream out) {
        for (Property<?> prop : object.getProperties()) {
            FileUtils.printProperty(prop, out);
        }
    }

    public static void printProperty(Property<?> prop) {
        FileUtils.printProperty(prop, System.out);
    }

    public static void printProperty(Property<?> prop, PrintStream out) {
        out.println(prop.getId() + ": " + prop.getValuesAsString());
    }
}

