/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;

public final class OperationContextUtils {
    public static final String PROPERTIES_STAR = "*";
    public static final String RENDITION_NONE = "cmis:none";

    private OperationContextUtils() {
    }

    public static OperationContext createOperationContext() {
        return new OperationContextImpl();
    }

    public static OperationContext copyOperationContext(OperationContext context) {
        return new OperationContextImpl(context);
    }

    public static OperationContext createOperationContext(Set<String> filter, boolean includeAcls, boolean includeAllowableActions, boolean includePolicies, IncludeRelationships includeRelationships, Set<String> renditionFilter, boolean includePathSegments, String orderBy, boolean cacheEnabled, int maxItemsPerPage) {
        return new OperationContextImpl(filter, includeAcls, includeAllowableActions, includePolicies, includeRelationships, renditionFilter, includePathSegments, orderBy, cacheEnabled, maxItemsPerPage);
    }

    public static OperationContext createMinimumOperationContext() {
        HashSet<String> filter = new HashSet<String>();
        filter.add("cmis:objectId");
        filter.add("cmis:objectTypeId");
        filter.add("cmis:baseTypeId");
        return new OperationContextImpl(filter, false, false, false, IncludeRelationships.NONE, Collections.singleton(RENDITION_NONE), false, null, true, 100);
    }

    public static OperationContext createMaximumOperationContext() {
        return new OperationContextImpl(Collections.singleton(PROPERTIES_STAR), true, true, true, IncludeRelationships.BOTH, Collections.singleton(PROPERTIES_STAR), false, null, true, 100);
    }

    public static OperationContext unmodifiableOperationContext(final OperationContext context) {
        return new OperationContext(){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<String> getFilter() {
                return Collections.unmodifiableSet(context.getFilter());
            }

            @Override
            public void setFilter(Set<String> propertyFilter) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setFilterString(String propertyFilter) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getFilterString() {
                return context.getFilterString();
            }

            @Override
            public void setLoadSecondaryTypeProperties(boolean load) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean loadSecondaryTypeProperties() {
                return context.loadSecondaryTypeProperties();
            }

            @Override
            public boolean isIncludeAllowableActions() {
                return context.isIncludeAllowableActions();
            }

            @Override
            public void setIncludeAllowableActions(boolean include) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isIncludeAcls() {
                return context.isIncludeAcls();
            }

            @Override
            public void setIncludeAcls(boolean include) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IncludeRelationships getIncludeRelationships() {
                return context.getIncludeRelationships();
            }

            @Override
            public void setIncludeRelationships(IncludeRelationships include) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isIncludePolicies() {
                return context.isIncludePolicies();
            }

            @Override
            public void setIncludePolicies(boolean include) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<String> getRenditionFilter() {
                return Collections.unmodifiableSet(context.getRenditionFilter());
            }

            @Override
            public void setRenditionFilter(Set<String> renditionFilter) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setRenditionFilterString(String renditionFilter) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getRenditionFilterString() {
                return context.getRenditionFilterString();
            }

            @Override
            public boolean isIncludePathSegments() {
                return context.isIncludePathSegments();
            }

            @Override
            public void setIncludePathSegments(boolean include) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getOrderBy() {
                return context.getOrderBy();
            }

            @Override
            public void setOrderBy(String orderBy) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isCacheEnabled() {
                return context.isCacheEnabled();
            }

            @Override
            public void setCacheEnabled(boolean cacheEnabled) {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getCacheKey() {
                return context.getCacheKey();
            }

            @Override
            public void setMaxItemsPerPage(int maxItemsPerPage) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getMaxItemsPerPage() {
                return context.getMaxItemsPerPage();
            }

            public String toString() {
                return context.toString();
            }
        };
    }
}

