/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import com.ctc.wstx.api.InvalidCharHandler;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.codehaus.stax2.XMLStreamProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XMLUtils {
    private static final Logger LOG;
    private static final XMLInputFactory XML_INPUT_FACTORY;
    private static final XMLOutputFactory XML_OUTPUT_FACTORY;

    private XMLUtils() {
    }

    public static XMLStreamWriter createWriter(OutputStream out) throws XMLStreamException {
        assert (out != null);
        return XML_OUTPUT_FACTORY.createXMLStreamWriter(out, "UTF-8");
    }

    public static void startXmlDocument(XMLStreamWriter writer) throws XMLStreamException {
        assert (writer != null);
        writer.setPrefix("atom", "http://www.w3.org/2005/Atom");
        writer.setPrefix("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        writer.setPrefix("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        writer.setPrefix("chemistry", "http://chemistry.apache.org/");
        writer.writeStartDocument();
    }

    public static void endXmlDocument(XMLStreamWriter writer) throws XMLStreamException {
        assert (writer != null);
        writer.writeEndDocument();
        writer.close();
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, String value) throws XMLStreamException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        if (namespace == null) {
            writer.writeStartElement(tag);
        } else {
            writer.writeStartElement(prefix, tag, namespace);
        }
        writer.writeCharacters(value);
        writer.writeEndElement();
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, BigInteger value) throws XMLStreamException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value.toString());
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, BigDecimal value) throws XMLStreamException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value.toPlainString());
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, GregorianCalendar value) throws XMLStreamException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, DateTimeHelper.formatXmlDateTime(value));
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, Boolean value) throws XMLStreamException {
        assert (writer != null);
        if (value == null) {
            return;
        }
        XMLUtils.write(writer, prefix, namespace, tag, value != false ? "true" : "false");
    }

    public static void write(XMLStreamWriter writer, String prefix, String namespace, String tag, Enum<?> value) throws XMLStreamException {
        Object enumValue;
        assert (writer != null);
        if (value == null) {
            return;
        }
        try {
            enumValue = value.getClass().getMethod("value", new Class[0]).invoke(value, new Object[0]);
        }
        catch (Exception e) {
            throw new XMLStreamException("Cannot get enum value", e);
        }
        XMLUtils.write(writer, prefix, namespace, tag, enumValue.toString());
    }

    public static XMLStreamReader createParser(InputStream stream) throws XMLStreamException {
        return XML_INPUT_FACTORY.createXMLStreamReader(stream);
    }

    public static boolean next(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        if (parser.hasNext()) {
            parser.next();
            return true;
        }
        return false;
    }

    public static void skip(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        int level = 1;
        while (XMLUtils.next(parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                ++level;
                continue;
            }
            if (event != 2 || --level != 0) continue;
            break;
        }
        XMLUtils.next(parser);
    }

    public static boolean findNextStartElemenet(XMLStreamReader parser) throws XMLStreamException {
        assert (parser != null);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                return true;
            }
            if (!parser.hasNext()) break;
            parser.next();
        }
        return false;
    }

    public static String readText(XMLStreamReader parser, int maxLength) throws XMLStreamException {
        int event;
        assert (parser != null);
        assert (maxLength >= 0);
        StringBuilder sb = new StringBuilder();
        XMLUtils.next(parser);
        while ((event = parser.getEventType()) != 2) {
            if (event == 4 || event == 12) {
                int len = parser.getTextLength();
                if (len > 0) {
                    if (sb.length() + len > maxLength) {
                        throw new CmisInvalidArgumentException("String limit exceeded!");
                    }
                    char[] chars = parser.getTextCharacters();
                    int offset = parser.getTextStart();
                    sb.append(chars, offset, len);
                }
            } else if (event == 1) {
                throw new XMLStreamException("Unexpected tag: " + parser.getName());
            }
            if (XMLUtils.next(parser)) continue;
            break;
        }
        XMLUtils.next(parser);
        return sb.toString();
    }

    private static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        factory.setExpandEntityReferences(false);
        factory.setCoalescing(false);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory.newDocumentBuilder();
    }

    public static Document newDomDocument() throws ParserConfigurationException {
        return XMLUtils.newDocumentBuilder().newDocument();
    }

    public static Document parseDomDocument(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocumentBuilder().parse(stream);
    }

    static {
        Object factory;
        XMLStreamProperties wstxFactory;
        LOG = LoggerFactory.getLogger(XMLUtils.class);
        try {
            wstxFactory = (WstxInputFactory)ClassLoaderUtil.loadClass("com.ctc.wstx.stax.WstxInputFactory").newInstance();
            ((WstxInputFactory)wstxFactory).configureForSpeed();
            factory = wstxFactory;
        }
        catch (Exception e) {
            factory = XMLInputFactory.newInstance();
            try {
                ((XMLInputFactory)factory).setProperty("reuse-instance", Boolean.FALSE);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            LOG.warn("Unsupported StAX parser: " + factory.getClass().getName() + " (Exception: " + e.toString() + ")", (Throwable)e);
        }
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        ((XMLInputFactory)factory).setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        XML_INPUT_FACTORY = factory;
        try {
            wstxFactory = (WstxOutputFactory)ClassLoaderUtil.loadClass("com.ctc.wstx.stax.WstxOutputFactory").newInstance();
            ((WstxOutputFactory)wstxFactory).configureForSpeed();
            ((WstxOutputFactory)wstxFactory).setProperty("com.ctc.wstx.outputInvalidCharHandler", new InvalidCharHandler.ReplacingHandler(' '));
            factory = wstxFactory;
        }
        catch (Exception e) {
            factory = XMLOutputFactory.newInstance();
            try {
                ((XMLOutputFactory)factory).setProperty("reuse-instance", Boolean.FALSE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            LOG.warn("Unsupported StAX parser: " + factory.getClass().getName() + " (Exception: " + e.toString() + ")", (Throwable)e);
        }
        ((XMLOutputFactory)factory).setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        XML_OUTPUT_FACTORY = factory;
    }
}

