/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.chemistry.opencmis.commons.data.ContentStreamHash;

public class ContentStreamHashImpl
implements ContentStreamHash {
    public static final String ALGORITHM_MD5 = "md5";
    public static final String ALGORITHM_SHA1 = "sha-1";
    public static final String ALGORITHM_SHA224 = "sha-224";
    public static final String ALGORITHM_SHA256 = "sha-256";
    public static final String ALGORITHM_SHA384 = "sha-384";
    public static final String ALGORITHM_SHA512 = "sha-512";
    public static final String ALGORITHM_SHA3 = "sha-3";
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private String propertyValue;
    private String algorithm = null;
    private String hash = null;

    public ContentStreamHashImpl(String propertyValue) {
        this.propertyValue = propertyValue;
        if (propertyValue == null) {
            return;
        }
        String pv = propertyValue.trim();
        int algEnd = pv.indexOf(125);
        if (pv.charAt(0) != '{' || algEnd < 1) {
            return;
        }
        this.algorithm = pv.substring(1, algEnd).toLowerCase(Locale.ENGLISH);
        this.hash = pv.substring(algEnd + 1).replaceAll("\\s", "").toLowerCase(Locale.ENGLISH);
    }

    public ContentStreamHashImpl(String algorithm, String hashStr) {
        if (algorithm == null || algorithm.trim().length() == 0) {
            throw new IllegalArgumentException("Algorithm must be set!");
        }
        if (hashStr == null || hashStr.trim().length() == 0) {
            throw new IllegalArgumentException("Hash must be set!");
        }
        this.algorithm = algorithm.toLowerCase(Locale.ENGLISH);
        this.hash = hashStr.replaceAll("\\s", "").toLowerCase(Locale.ENGLISH);
        this.propertyValue = "{" + this.algorithm + "}" + this.hash;
    }

    public ContentStreamHashImpl(String algorithm, byte[] hashBytes) {
        if (algorithm == null || algorithm.trim().length() == 0) {
            throw new IllegalArgumentException("Algorithm must be set!");
        }
        if (hashBytes == null || hashBytes.length == 0) {
            throw new IllegalArgumentException("Hash must be set!");
        }
        this.algorithm = algorithm.toLowerCase(Locale.ENGLISH);
        this.hash = ContentStreamHashImpl.byteArrayToHexString(hashBytes);
        this.propertyValue = "{" + this.algorithm + "}" + this.hash;
    }

    @Override
    public String getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public int hashCode() {
        return this.propertyValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentStreamHashImpl other = (ContentStreamHashImpl)obj;
        return !(this.propertyValue == null ? other.propertyValue != null : !this.propertyValue.equals(other.propertyValue));
    }

    public String toString() {
        return this.propertyValue;
    }

    public static List<ContentStreamHash> createContentStreamHashes(InputStream stream, String ... algorithm) throws IOException, NoSuchAlgorithmException {
        int b;
        if (stream == null) {
            throw new IllegalArgumentException("Stream must be set!");
        }
        if (algorithm == null || algorithm.length == 0) {
            throw new IllegalArgumentException("Algorithm must be set!");
        }
        MessageDigest[] md = new MessageDigest[algorithm.length];
        for (int i = 0; i < algorithm.length; ++i) {
            md[i] = MessageDigest.getInstance(algorithm[i]);
        }
        byte[] buffer = new byte[65536];
        while ((b = stream.read(buffer)) > -1) {
            for (int j = 0; j < md.length; ++j) {
                md[j].update(buffer, 0, b);
            }
        }
        ArrayList<ContentStreamHash> result = new ArrayList<ContentStreamHash>();
        for (int i = 0; i < md.length; ++i) {
            result.add(new ContentStreamHashImpl(algorithm[i], md[i].digest()));
        }
        return result;
    }

    protected static String byteArrayToHexString(byte[] bytes) {
        int n = bytes.length;
        char[] hashHex = new char[n * 2];
        for (int i = 0; i < n; ++i) {
            hashHex[i * 2] = HEX_DIGITS[(0xF0 & bytes[i]) >>> 4];
            hashHex[i * 2 + 1] = HEX_DIGITS[0xF & bytes[i]];
        }
        return new String(hashHex);
    }
}

