/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import org.apache.chemistry.opencmis.commons.data.MutableContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractExtensionData;

public class ContentStreamImpl
extends AbstractExtensionData
implements MutableContentStream {
    private static final long serialVersionUID = 1L;
    private String filename;
    private BigInteger length;
    private String mimetype;
    private transient InputStream stream;

    public ContentStreamImpl() {
    }

    public ContentStreamImpl(String filename, BigInteger length, String mimetype, InputStream stream) {
        this.filename = filename;
        this.length = length;
        this.mimetype = mimetype;
        this.stream = stream;
    }

    public ContentStreamImpl(String filename, String mimetype, String string) {
        if (string == null) {
            throw new IllegalArgumentException("String must be set!");
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CmisRuntimeException("Unsupported encoding 'UTF-8'!", e);
        }
        this.filename = filename;
        this.length = BigInteger.valueOf(bytes.length);
        this.mimetype = mimetype;
        this.stream = new ByteArrayInputStream(bytes);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public void setFileName(String filename) {
        this.filename = filename;
    }

    @Override
    public long getLength() {
        return this.length == null ? -1L : this.length.longValue();
    }

    @Override
    public BigInteger getBigLength() {
        return this.length;
    }

    @Override
    public void setLength(BigInteger length) {
        this.length = length;
    }

    @Override
    public String getMimeType() {
        return this.mimetype;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimetype = mimeType;
    }

    @Override
    public InputStream getStream() {
        return this.stream;
    }

    @Override
    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public String toString() {
        return "ContentStream [filename=" + this.filename + ", length=" + this.length + ", MIME type=" + this.mimetype + ", has stream=" + (this.stream != null) + "]" + super.toString();
    }
}

