/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyBoolean;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyDateTime;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.data.PropertyInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyString;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityAcl;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.impl.server.RenditionInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.server.RenditionInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCmisService
implements CmisService,
ObjectInfoHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCmisService.class);
    private Map<String, ObjectInfo> objectInfoMap;
    private boolean addObjectInfos = true;

    @Override
    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        RepositoryInfo result = null;
        List<RepositoryInfo> repositories = this.getRepositoryInfos(extension);
        if (repositories != null) {
            for (RepositoryInfo ri : repositories) {
                if (!ri.getId().equals(repositoryId)) continue;
                result = ri;
                break;
            }
        }
        if (result == null) {
            throw new CmisObjectNotFoundException("Repository '" + repositoryId + "' does not exist!");
        }
        return result;
    }

    @Override
    public abstract List<RepositoryInfo> getRepositoryInfos(ExtensionsData var1);

    @Override
    public abstract TypeDefinitionList getTypeChildren(String var1, String var2, Boolean var3, BigInteger var4, BigInteger var5, ExtensionsData var6);

    @Override
    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        int d;
        int n = d = depth == null ? -1 : depth.intValue();
        if (d == 0) {
            throw new CmisInvalidArgumentException("Depth must not be 0!");
        }
        if (typeId == null) {
            d = -1;
        }
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        TypeDefinitionList children = this.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.ZERO, null);
        if (children != null && CollectionsHelper.isNotEmpty(children.getList())) {
            for (TypeDefinition td : children.getList()) {
                TypeDefinitionContainerImpl tdc = new TypeDefinitionContainerImpl(td);
                this.addTypeChildren(repositoryId, includePropertyDefinitions, d > 0 ? d - 1 : -1, tdc);
                result.add(tdc);
            }
        }
        return result;
    }

    private void addTypeChildren(String repositoryId, Boolean includePropertyDefinitions, int depth, TypeDefinitionContainerImpl container) {
        if (depth == 0) {
            return;
        }
        TypeDefinitionList children = this.getTypeChildren(repositoryId, container.getTypeDefinition().getId(), includePropertyDefinitions, BigInteger.valueOf(Integer.MAX_VALUE), BigInteger.ZERO, null);
        if (children != null && CollectionsHelper.isNotEmpty(children.getList())) {
            ArrayList<TypeDefinitionContainer> list = new ArrayList<TypeDefinitionContainer>();
            container.setChildren(list);
            for (TypeDefinition td : children.getList()) {
                TypeDefinitionContainerImpl tdc = new TypeDefinitionContainerImpl(td);
                this.addTypeChildren(repositoryId, includePropertyDefinitions, depth > 0 ? depth - 1 : -1, tdc);
                list.add(tdc);
            }
        }
    }

    @Override
    public abstract TypeDefinition getTypeDefinition(String var1, String var2, ExtensionsData var3);

    @Override
    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public abstract ObjectInFolderList getChildren(String var1, String var2, String var3, String var4, Boolean var5, IncludeRelationships var6, String var7, Boolean var8, BigInteger var9, BigInteger var10, ExtensionsData var11);

    @Override
    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public abstract List<ObjectParentData> getObjectParents(String var1, String var2, String var3, Boolean var4, IncludeRelationships var5, String var6, Boolean var7, ExtensionsData var8);

    @Override
    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        String newId;
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Properties must be set!");
        }
        PropertyData<?> obbjectTypeIdProperty = properties.getProperties().get("cmis:objectTypeId");
        if (obbjectTypeIdProperty == null || !(obbjectTypeIdProperty.getFirstValue() instanceof String)) {
            throw new CmisInvalidArgumentException("Property 'cmis:objectTypeId' must be set!");
        }
        String objectTypeId = obbjectTypeIdProperty.getFirstValue().toString();
        TypeDefinition type = this.getTypeDefinition(repositoryId, objectTypeId, null);
        switch (type.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                newId = this.createDocument(repositoryId, properties, folderId, contentStream, versioningState, policies, null, null, extension);
                break;
            }
            case CMIS_FOLDER: {
                newId = this.createFolder(repositoryId, properties, folderId, policies, null, null, extension);
                break;
            }
            case CMIS_POLICY: {
                newId = this.createPolicy(repositoryId, properties, folderId, policies, null, null, extension);
                break;
            }
            case CMIS_ITEM: {
                newId = this.createItem(repositoryId, properties, folderId, policies, null, null, extension);
                break;
            }
            default: {
                newId = null;
            }
        }
        if (newId == null) {
            throw new CmisRuntimeException("Creation failed!");
        }
        return newId;
    }

    @Override
    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public String createItem(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        return this.getObject(repositoryId, objectId, "cmis:objectId", true, IncludeRelationships.NONE, "cmis:none", false, false, extension).getAllowableActions();
    }

    @Override
    public abstract ObjectData getObject(String var1, String var2, String var3, Boolean var4, IncludeRelationships var5, String var6, Boolean var7, Boolean var8, ExtensionsData var9);

    @Override
    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return this.getObject(repositoryId, objectId, filter, false, IncludeRelationships.NONE, "cmis:none", false, false, extension).getProperties();
    }

    @Override
    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, extension);
    }

    @Override
    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void appendContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ContentStream contentStream, boolean isLastChunk, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void checkOut(String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void checkIn(String repositoryId, Holder<String> objectId, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public ObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        return this.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, false, IncludeRelationships.NONE, "cmis:none", false, false, extension).getProperties();
    }

    @Override
    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    @Override
    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        throw new CmisNotSupportedException("Not supported!");
    }

    private Map<String, ObjectInfo> getObjectInfoMap() {
        if (this.objectInfoMap == null) {
            this.objectInfoMap = new HashMap<String, ObjectInfo>();
        }
        return this.objectInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        Map<String, ObjectInfo> oim = this.getObjectInfoMap();
        ObjectInfo info = oim.get(objectId);
        if (info == null) {
            try {
                this.addObjectInfos = false;
                ObjectData object = this.getObject(repositoryId, objectId, null, Boolean.TRUE, IncludeRelationships.BOTH, "*", Boolean.TRUE, Boolean.FALSE, null);
                info = this.getObjectInfoIntern(repositoryId, object);
                this.addObjectInfos = true;
                this.addObjectInfo(info);
            }
            catch (Exception e) {
                info = null;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Getting the object info for object {} in repository {}  failed: {}", new Object[]{objectId, repositoryId, e.toString(), e});
                }
            }
            finally {
                this.addObjectInfos = true;
            }
        }
        return info;
    }

    protected ObjectInfo getObjectInfoIntern(String repositoryId, ObjectData object) {
        RepositoryInfo repositoryInfo;
        ObjectInfoImpl info;
        block32: {
            block31: {
                boolean hasContent;
                block30: {
                    if (object.getProperties() == null || object.getProperties().getProperties() == null) {
                        throw new CmisRuntimeException("No properties!");
                    }
                    info = new ObjectInfoImpl();
                    repositoryInfo = null;
                    try {
                        repositoryInfo = this.getRepositoryInfo(repositoryId, null);
                    }
                    catch (CmisRuntimeException e) {
                        LOG.error("getRepositoryInfo returned an error while compiling object info for object {}.", (Object)object.getId(), (Object)e);
                        throw e;
                    }
                    info.setObject(object);
                    info.setId(object.getId());
                    info.setName(this.getStringProperty(object, "cmis:name"));
                    info.setCreatedBy(this.getStringProperty(object, "cmis:createdBy"));
                    info.setCreationDate(this.getDateTimeProperty(object, "cmis:createdBy"));
                    info.setLastModificationDate(this.getDateTimeProperty(object, "cmis:lastModificationDate"));
                    info.setTypeId(this.getIdProperty(object, "cmis:objectTypeId"));
                    info.setBaseType(object.getBaseTypeId());
                    info.setIsCurrentVersion(object.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT);
                    info.setWorkingCopyId(null);
                    info.setWorkingCopyOriginalId(null);
                    info.setVersionSeriesId(this.getIdProperty(object, "cmis:versionSeriesId"));
                    if (info.getVersionSeriesId() != null) {
                        Boolean isLatest = this.getBooleanProperty(object, "cmis:isLatestVersion");
                        info.setIsCurrentVersion(isLatest == null ? true : isLatest);
                        Boolean isCheckedOut = this.getBooleanProperty(object, "cmis:isVersionSeriesCheckedOut");
                        if (isCheckedOut != null && isCheckedOut.booleanValue()) {
                            info.setWorkingCopyId(this.getIdProperty(object, "cmis:versionSeriesCheckedOutId"));
                            try {
                                List<ObjectData> versions = this.getAllVersions(repositoryId, object.getId(), info.getVersionSeriesId(), null, Boolean.FALSE, null);
                                if (CollectionsHelper.isNotEmpty(versions)) {
                                    info.setWorkingCopyOriginalId(versions.get(0).getId());
                                }
                            }
                            catch (CmisNotSupportedException nse) {
                                if (!LOG.isWarnEnabled()) break block30;
                                LOG.warn("getAllVersions is not implemented! Object info for object {} might be incorrect.", (Object)info.getId(), (Object)nse);
                            }
                        }
                    }
                }
                String fileName = this.getStringProperty(object, "cmis:contentStreamFileName");
                String mimeType = this.getStringProperty(object, "cmis:contentStreamMimeType");
                String streamId = this.getIdProperty(object, "cmis:contentStreamId");
                BigInteger length = this.getIntegerProperty(object, "cmis:contentStreamLength");
                boolean bl = hasContent = fileName != null || mimeType != null || streamId != null || length != null;
                if (hasContent) {
                    info.setHasContent(hasContent);
                    info.setContentType(mimeType);
                    info.setFileName(fileName);
                } else {
                    info.setHasContent(false);
                    info.setContentType(null);
                    info.setFileName(null);
                }
                if (object.getBaseTypeId() == BaseTypeId.CMIS_RELATIONSHIP) {
                    info.setHasParent(false);
                } else if (object.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
                    info.setHasParent(!object.getId().equals(repositoryInfo.getRootFolderId()));
                } else {
                    try {
                        List<ObjectParentData> parents = this.getObjectParents(repositoryId, object.getId(), null, Boolean.FALSE, IncludeRelationships.NONE, "cmis:none", Boolean.FALSE, null);
                        info.setHasParent(CollectionsHelper.isNotEmpty(parents));
                    }
                    catch (CmisInvalidArgumentException e) {
                        info.setHasParent(false);
                    }
                    catch (CmisNotSupportedException nse) {
                        if (!LOG.isWarnEnabled()) break block31;
                        LOG.warn("getObjectParents is not implemented! Object info for object {} might be incorrect.", (Object)info.getId(), (Object)nse);
                    }
                }
            }
            info.setSupportsRelationships(false);
            info.setSupportsPolicies(false);
            try {
                TypeDefinitionList baseTypesList = this.getTypeChildren(repositoryId, null, Boolean.FALSE, BigInteger.valueOf(6L), BigInteger.ZERO, null);
                for (TypeDefinition type : baseTypesList.getList()) {
                    if (BaseTypeId.CMIS_RELATIONSHIP.value().equals(type.getId())) {
                        info.setSupportsRelationships(true);
                        continue;
                    }
                    if (!BaseTypeId.CMIS_POLICY.value().equals(type.getId())) continue;
                    info.setSupportsPolicies(true);
                }
            }
            catch (CmisNotSupportedException nse) {
                if (!LOG.isWarnEnabled()) break block32;
                LOG.warn("getTypeChildren is not implemented! Object info for object {} might be incorrect.", (Object)info.getId(), (Object)nse);
            }
        }
        info.setRenditionInfos(null);
        List<RenditionData> renditions = object.getRenditions();
        if (CollectionsHelper.isNotEmpty(renditions)) {
            ArrayList<RenditionInfo> renditionInfos = new ArrayList<RenditionInfo>();
            for (RenditionData rendition : renditions) {
                RenditionInfoImpl renditionInfo = new RenditionInfoImpl();
                renditionInfo.setId(rendition.getStreamId());
                renditionInfo.setKind(rendition.getKind());
                renditionInfo.setContentType(rendition.getMimeType());
                renditionInfo.setTitle(rendition.getTitle());
                renditionInfo.setLength(rendition.getBigLength());
                renditionInfos.add(renditionInfo);
            }
            info.setRenditionInfos(renditionInfos);
        }
        info.setRelationshipSourceIds(null);
        info.setRelationshipTargetIds(null);
        List<ObjectData> relationships = object.getRelationships();
        if (CollectionsHelper.isNotEmpty(relationships)) {
            ArrayList<String> sourceIds = new ArrayList<String>();
            ArrayList<String> targetIds = new ArrayList<String>();
            for (ObjectData relationship : relationships) {
                String sourceId = this.getIdProperty(relationship, "cmis:sourceId");
                String targetId = this.getIdProperty(relationship, "cmis:targetId");
                if (object.getId().equals(sourceId)) {
                    sourceIds.add(relationship.getId());
                }
                if (!object.getId().equals(targetId)) continue;
                targetIds.add(relationship.getId());
            }
            if (CollectionsHelper.isNotEmpty(sourceIds)) {
                info.setRelationshipSourceIds(sourceIds);
            }
            if (CollectionsHelper.isNotEmpty(targetIds)) {
                info.setRelationshipTargetIds(targetIds);
            }
        }
        info.setHasAcl(false);
        info.setSupportsDescendants(false);
        info.setSupportsFolderTree(false);
        RepositoryCapabilities capabilities = repositoryInfo.getCapabilities();
        if (capabilities != null) {
            info.setHasAcl(capabilities.getAclCapability() == CapabilityAcl.DISCOVER || capabilities.getAclCapability() == CapabilityAcl.MANAGE);
            if (object.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
                info.setSupportsDescendants(Boolean.TRUE.equals(capabilities.isGetDescendantsSupported()));
                info.setSupportsFolderTree(Boolean.TRUE.equals(capabilities.isGetFolderTreeSupported()));
            }
        }
        return info;
    }

    @Override
    public void addObjectInfo(ObjectInfo objectInfo) {
        if (!this.addObjectInfos) {
            return;
        }
        if (objectInfo != null && objectInfo.getId() != null) {
            this.getObjectInfoMap().put(objectInfo.getId(), objectInfo);
        }
    }

    public void clearObjectInfos() {
        this.objectInfoMap = null;
    }

    @Override
    public void close() {
        this.clearObjectInfos();
    }

    protected String getStringProperty(ObjectData object, String name) {
        PropertyData<?> property = object.getProperties().getProperties().get(name);
        if (property instanceof PropertyString) {
            return (String)((PropertyString)property).getFirstValue();
        }
        return null;
    }

    protected String getIdProperty(ObjectData object, String name) {
        PropertyData<?> property = object.getProperties().getProperties().get(name);
        if (property instanceof PropertyId) {
            return (String)((PropertyId)property).getFirstValue();
        }
        return null;
    }

    protected GregorianCalendar getDateTimeProperty(ObjectData object, String name) {
        PropertyData<?> property = object.getProperties().getProperties().get(name);
        if (property instanceof PropertyDateTime) {
            return (GregorianCalendar)((PropertyDateTime)property).getFirstValue();
        }
        return null;
    }

    protected Boolean getBooleanProperty(ObjectData object, String name) {
        PropertyData<?> property = object.getProperties().getProperties().get(name);
        if (property instanceof PropertyBoolean) {
            return (Boolean)((PropertyBoolean)property).getFirstValue();
        }
        return null;
    }

    protected BigInteger getIntegerProperty(ObjectData object, String name) {
        PropertyData<?> property = object.getProperties().getProperties().get(name);
        if (property instanceof PropertyInteger) {
            return (BigInteger)((PropertyInteger)property).getFirstValue();
        }
        return null;
    }
}

