/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.eclipse.jetty.util.ajax.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapMessage
extends HashMap<String, Object>
implements Message.Mutable,
JSON.Generator,
Serializable {
    private static final long serialVersionUID = 4318697940670212190L;
    protected static JSON jsonParser = new JSON();
    private static JSON _messageParser = new JSON(){

        @Override
        protected Map<String, Object> newMap() {
            return new HashMapMessage();
        }

        @Override
        protected JSON contextFor(String field) {
            return jsonParser;
        }
    };
    private static JSON messagesParser = new JSON(){

        @Override
        protected Map<String, Object> newMap() {
            return new HashMapMessage();
        }

        @Override
        protected Object[] newArray(int size) {
            return new Message.Mutable[size];
        }

        @Override
        protected JSON contextFor(String field) {
            return jsonParser;
        }

        @Override
        protected JSON contextForArray() {
            return _messageParser;
        }
    };

    public HashMapMessage() {
    }

    public HashMapMessage(Message message) {
        this.putAll(message);
    }

    @Override
    public void addJSON(Appendable buffer) {
        try {
            buffer.append(this.getJSON());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> getAdvice() {
        Object advice = this.get("advice");
        if (advice instanceof JSON.Literal) {
            advice = JSON.parse(advice.toString());
            this.put("advice", advice);
        }
        return (Map)advice;
    }

    @Override
    public String getChannel() {
        return (String)this.get("channel");
    }

    @Override
    public ChannelId getChannelId() {
        return new ChannelId(this.getChannel());
    }

    @Override
    public String getClientId() {
        return (String)this.get("clientId");
    }

    @Override
    public Object getData() {
        return this.get("data");
    }

    @Override
    public Map<String, Object> getDataAsMap() {
        Object data = this.get("data");
        if (data instanceof JSON.Literal) {
            data = JSON.parse(data.toString());
            this.put("data", data);
        }
        return (Map)data;
    }

    @Override
    public Map<String, Object> getExt() {
        Object ext = this.get("ext");
        if (ext instanceof JSON.Literal) {
            ext = JSON.parse(ext.toString());
            this.put("ext", ext);
        }
        return (Map)ext;
    }

    @Override
    public String getId() {
        Object id = this.get("id");
        return id == null ? null : String.valueOf(id);
    }

    @Override
    public String getJSON() {
        StringBuilder buf = new StringBuilder(jsonParser.getStringBufferSize());
        jsonParser.appendMap(buf, this);
        return ((Object)buf).toString();
    }

    @Override
    public Map<String, Object> getAdvice(boolean create) {
        Map<String, Object> advice = this.getAdvice();
        if (create && advice == null) {
            advice = new HashMap<String, Object>();
            this.put("advice", advice);
        }
        return advice;
    }

    @Override
    public Map<String, Object> getDataAsMap(boolean create) {
        Map<String, Object> data = this.getDataAsMap();
        if (create && data == null) {
            data = new HashMap<String, Object>();
            this.put("data", data);
        }
        return data;
    }

    @Override
    public Map<String, Object> getExt(boolean create) {
        Map<String, Object> ext = this.getExt();
        if (create && ext == null) {
            ext = new HashMap<String, Object>();
            this.put("ext", ext);
        }
        return ext;
    }

    @Override
    public boolean isMeta() {
        return ChannelId.isMeta(this.getChannel());
    }

    @Override
    public boolean isSuccessful() {
        Boolean value = (Boolean)this.get("successful");
        return value != null && value != false;
    }

    @Override
    public String toString() {
        return this.getJSON();
    }

    @Override
    public void setChannel(String channel) {
        if (channel == null) {
            this.remove("channel");
        } else {
            this.put("channel", channel);
        }
    }

    @Override
    public void setClientId(String clientId) {
        if (clientId == null) {
            this.remove("clientId");
        } else {
            this.put("clientId", clientId);
        }
    }

    @Override
    public void setData(Object data) {
        if (data == null) {
            this.remove("data");
        } else {
            this.put("data", data);
        }
    }

    @Override
    public void setId(String id) {
        if (id == null) {
            this.remove("id");
        } else {
            this.put("id", id);
        }
    }

    @Override
    public void setSuccessful(boolean successful) {
        this.put("successful", successful);
    }

    public static List<Message.Mutable> parseMessages(String content) {
        Object object = messagesParser.parse(new JSON.StringSource(content));
        if (object instanceof Message.Mutable) {
            return Collections.singletonList((Message.Mutable)object);
        }
        return Arrays.asList((Message.Mutable[])object);
    }
}

