/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.HashMapMessage;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.LocalSessionImpl;
import org.cometd.server.ServerChannelImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSessionImpl
implements ServerSession {
    private static final AtomicLong _idCount = new AtomicLong();
    private final BayeuxServerImpl _bayeux;
    private final Logger _logger;
    private final String _id;
    private final List<ServerSession.ServerSessionListener> _listeners = new CopyOnWriteArrayList<ServerSession.ServerSessionListener>();
    private final List<ServerSession.Extension> _extensions = new CopyOnWriteArrayList<ServerSession.Extension>();
    private final ArrayQueue<ServerMessage> _queue = new ArrayQueue(8, 16, this);
    private final LocalSessionImpl _localSession;
    private final AttributesMap _attributes = new AttributesMap();
    private final AtomicBoolean _connected = new AtomicBoolean();
    private final AtomicBoolean _handshook = new AtomicBoolean();
    private final Map<ServerChannelImpl, Boolean> _subscribedTo = new ConcurrentHashMap<ServerChannelImpl, Boolean>();
    private AbstractServerTransport.Scheduler _scheduler;
    private ServerTransport _advisedTransport;
    private int _maxQueue = -1;
    private long _transientTimeout = -1L;
    private long _transientInterval = -1L;
    private long _timeout = -1L;
    private long _interval = -1L;
    private long _maxInterval = -1L;
    private long _maxLazy = -1L;
    private long _maxConnectDelay = -1L;
    private boolean _metaConnectDelivery;
    private int _batch;
    private String _userAgent;
    private long _connectTimestamp = -1L;
    private long _intervalTimestamp;
    private long _lastInterval;
    private long _lastConnect;
    private volatile boolean _lazyDispatch;
    private Timeout.Task _lazyTask;

    protected ServerSessionImpl(BayeuxServerImpl bayeux) {
        this(bayeux, null, null);
    }

    protected ServerSessionImpl(BayeuxServerImpl bayeux, LocalSessionImpl localSession, String idHint) {
        this._bayeux = bayeux;
        this._logger = bayeux.getLogger();
        this._localSession = localSession;
        StringBuilder id = new StringBuilder(30);
        int len = 20;
        if (idHint != null) {
            len += idHint.length() + 1;
            id.append(idHint);
            id.append('_');
        }
        int index = id.length();
        while (id.length() < len) {
            long random = this._bayeux.randomLong();
            id.append(Long.toString(random < 0L ? -random : random, 36));
        }
        id.insert(index, Long.toString(_idCount.incrementAndGet(), 36));
        this._id = id.toString();
        HttpTransport transport = (HttpTransport)this._bayeux.getCurrentTransport();
        if (transport != null) {
            this._intervalTimestamp = System.currentTimeMillis() + transport.getMaxInterval();
        }
    }

    @Override
    public String getUserAgent() {
        return this._userAgent;
    }

    public void setUserAgent(String userAgent) {
        this._userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sweep(long now) {
        boolean remove = false;
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (this._intervalTimestamp == 0L) {
                if (this._maxConnectDelay > 0L && now > this._connectTimestamp + this._maxConnectDelay) {
                    this._logger.info("Emergency sweeping session {}", this);
                    remove = true;
                }
            } else if (now > this._intervalTimestamp) {
                this._logger.debug("Sweeping session {}", this);
                remove = true;
            }
            if (remove && this._scheduler != null) {
                this._scheduler.cancel();
            }
        }
        if (remove) {
            this._bayeux.removeServerSession(this, true);
        }
    }

    protected List<ServerSession.Extension> getExtensions() {
        return Collections.unmodifiableList(this._extensions);
    }

    @Override
    public Set<ServerChannel> getSubscriptions() {
        return Collections.unmodifiableSet(this._subscribedTo.keySet());
    }

    @Override
    public void addExtension(ServerSession.Extension extension) {
        this._extensions.add(extension);
    }

    @Override
    public void removeExtension(ServerSession.Extension extension) {
        this._extensions.remove(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batch(Runnable batch) {
        this.startBatch();
        try {
            batch.run();
        }
        finally {
            this.endBatch();
        }
    }

    @Override
    public void deliver(Session from, ServerMessage.Mutable message) {
        ServerSession session = from instanceof ServerSession ? (ServerSession)from : ((LocalSession)from).getServerSession();
        if (!this._bayeux.extendSend(session, this, message)) {
            return;
        }
        this.doDeliver(session, message);
    }

    @Override
    public void deliver(Session from, String channelId, Object data, String id) {
        ServerMessage.Mutable message = this._bayeux.newMessage();
        message.setChannel(channelId);
        message.setData(data);
        message.setId(id);
        this.deliver(from, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDeliver(ServerSession from, ServerMessage.Mutable mutable) {
        boolean wakeup;
        ServerMessage message = null;
        if (mutable.isMeta()) {
            if (this.extendSendMeta(mutable)) {
                message = mutable;
            }
        } else {
            message = this.extendSendMessage(mutable);
        }
        if (message == null) {
            return;
        }
        for (ServerSession.ServerSessionListener listener : this._listeners) {
            if (listener instanceof ServerSession.MaxQueueListener && this._maxQueue >= 0 && this._queue.size() >= this._maxQueue && !this.notifyQueueMaxed((ServerSession.MaxQueueListener)listener, from, message)) {
                return;
            }
            if (!(listener instanceof ServerSession.MessageListener) || this.notifyOnMessage((ServerSession.MessageListener)listener, from, message)) continue;
            return;
        }
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            this._queue.add(message);
            wakeup = this._batch == 0;
        }
        if (wakeup) {
            if (message.isLazy()) {
                this.flushLazy();
            } else {
                this.flush();
            }
        }
    }

    private boolean notifyQueueMaxed(ServerSession.MaxQueueListener listener, ServerSession from, ServerMessage message) {
        try {
            return listener.queueMaxed(this, from, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, x);
            return true;
        }
    }

    private boolean notifyOnMessage(ServerSession.MessageListener listener, ServerSession from, ServerMessage message) {
        try {
            return listener.onMessage(this, from, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, x);
            return true;
        }
    }

    protected void handshake() {
        this._handshook.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() {
        this._connected.set(true);
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            HttpTransport transport;
            if (this._connectTimestamp == -1L && (transport = (HttpTransport)this._bayeux.getCurrentTransport()) != null) {
                this._maxQueue = transport.getOption("maxQueue", -1);
                this._maxInterval = this._interval >= 0L ? this._interval + transport.getMaxInterval() - transport.getInterval() : transport.getMaxInterval();
                this._maxLazy = transport.getMaxLazyTimeout();
                this._maxConnectDelay = transport.getOption("maxConnectDelay", 960000L);
                if (this._maxLazy > 0L) {
                    this._lazyTask = new Timeout.Task(){

                        public void expired() {
                            ServerSessionImpl.this._lazyDispatch = false;
                            ServerSessionImpl.this.flush();
                        }

                        public String toString() {
                            return "LazyTask@" + ServerSessionImpl.this.getId();
                        }
                    };
                }
            }
            this.cancelIntervalTimeout();
        }
    }

    @Override
    public void disconnect() {
        boolean connected = this._bayeux.removeServerSession(this, false);
        if (connected) {
            ServerMessage.Mutable message = this._bayeux.newMessage();
            message.setChannel("/meta/disconnect");
            message.setSuccessful(true);
            this.deliver(this, message);
            if (this._queue.size() > 0) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean endBatch() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (--this._batch == 0 && this._queue.size() > 0) {
                this.flush();
                return true;
            }
        }
        return false;
    }

    @Override
    public LocalSession getLocalSession() {
        return this._localSession;
    }

    @Override
    public boolean isLocalSession() {
        return this._localSession != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startBatch() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            ++this._batch;
        }
    }

    @Override
    public void addListener(ServerSession.ServerSessionListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public String getId() {
        return this._id;
    }

    public Object getLock() {
        return this._queue;
    }

    public Queue<ServerMessage> getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueEmpty() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            return this._queue.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueue(ServerMessage message) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            this._queue.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceQueue(List<ServerMessage> queue) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            this._queue.clear();
            this._queue.addAll(queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerMessage> takeQueue() {
        ArrayList<ServerMessage> copy = new ArrayList<ServerMessage>();
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (!this._queue.isEmpty()) {
                for (ServerSession.ServerSessionListener listener : this._listeners) {
                    if (!(listener instanceof ServerSession.DeQueueListener)) continue;
                    this.notifyDeQueue((ServerSession.DeQueueListener)listener, this, this._queue);
                }
                copy.addAll(this._queue);
                this._queue.clear();
            }
        }
        return copy;
    }

    private void notifyDeQueue(ServerSession.DeQueueListener listener, ServerSession serverSession, Queue<ServerMessage> queue) {
        try {
            listener.deQueue(serverSession, queue);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    @Override
    public void removeListener(ServerSession.ServerSessionListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduler(AbstractServerTransport.Scheduler scheduler) {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (scheduler == null) {
                if (this._scheduler != null) {
                    this._scheduler.cancel();
                    this._scheduler = null;
                }
            } else {
                if (this._scheduler != null && this._scheduler != scheduler) {
                    this._scheduler.cancel();
                }
                this._scheduler = scheduler;
                if (this._queue.size() > 0 && this._batch == 0) {
                    this._scheduler.schedule();
                    if (this._scheduler instanceof AbstractServerTransport.OneTimeScheduler) {
                        this._scheduler = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            AbstractServerTransport.Scheduler scheduler;
            if (this._lazyDispatch && this._lazyTask != null) {
                this._bayeux.cancelTimeout(this._lazyTask);
            }
            if ((scheduler = this._scheduler) != null) {
                if (this._scheduler instanceof AbstractServerTransport.OneTimeScheduler) {
                    this._scheduler = null;
                }
                scheduler.schedule();
                return;
            }
        }
        if (this._localSession != null && this._queue.size() > 0) {
            for (ServerMessage msg : this.takeQueue()) {
                if (msg instanceof Message.Mutable) {
                    this._localSession.receive((Message.Mutable)((Object)msg));
                    continue;
                }
                this._localSession.receive(new HashMapMessage(msg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushLazy() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            if (this._maxLazy == 0L) {
                this.flush();
            } else if (this._maxLazy > 0L && !this._lazyDispatch) {
                this._lazyDispatch = true;
                this._bayeux.startTimeout(this._lazyTask, this._connectTimestamp % this._maxLazy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSchedule() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            AbstractServerTransport.Scheduler scheduler = this._scheduler;
            if (scheduler != null) {
                this._scheduler = null;
                scheduler.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelIntervalTimeout() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            long now = System.currentTimeMillis();
            if (this._intervalTimestamp > 0L) {
                this._lastInterval = now - (this._intervalTimestamp - this._maxInterval);
            }
            this._connectTimestamp = now;
            this._intervalTimestamp = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startIntervalTimeout() {
        ArrayQueue<ServerMessage> arrayQueue = this._queue;
        synchronized (arrayQueue) {
            long now = System.currentTimeMillis();
            this._lastConnect = now - this._connectTimestamp;
            this._intervalTimestamp = now + this._maxInterval;
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this._attributes.getAttributeNameSet();
    }

    @Override
    public Object removeAttribute(String name) {
        Object old = this.getAttribute(name);
        this._attributes.removeAttribute(name);
        return old;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._attributes.setAttribute(name, value);
    }

    @Override
    public boolean isConnected() {
        return this._connected.get();
    }

    @Override
    public boolean isHandshook() {
        return this._handshook.get();
    }

    protected boolean extendRecv(ServerMessage.Mutable message) {
        if (message.isMeta()) {
            for (ServerSession.Extension extension : this._extensions) {
                if (this.notifyRcvMeta(extension, message)) continue;
                return false;
            }
        } else {
            for (ServerSession.Extension extension : this._extensions) {
                if (this.notifyRcv(extension, message)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean notifyRcvMeta(ServerSession.Extension extension, ServerMessage.Mutable message) {
        try {
            return extension.rcvMeta(this, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    private boolean notifyRcv(ServerSession.Extension extension, ServerMessage.Mutable message) {
        try {
            return extension.rcv(this, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    protected boolean extendSendMeta(ServerMessage.Mutable message) {
        if (!message.isMeta()) {
            throw new IllegalStateException();
        }
        for (ServerSession.Extension extension : this._extensions) {
            if (this.notifySendMeta(extension, message)) continue;
            return false;
        }
        return true;
    }

    private boolean notifySendMeta(ServerSession.Extension extension, ServerMessage.Mutable message) {
        try {
            return extension.sendMeta(this, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return true;
        }
    }

    protected ServerMessage extendSendMessage(ServerMessage message) {
        if (message.isMeta()) {
            throw new IllegalStateException();
        }
        for (ServerSession.Extension extension : this._extensions) {
            message = this.notifySend(extension, message);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    private ServerMessage notifySend(ServerSession.Extension extension, ServerMessage message) {
        try {
            return extension.send(this, message);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking extension " + extension, x);
            return message;
        }
    }

    public Object getAdvice() {
        ServerTransport transport = this._bayeux.getCurrentTransport();
        if (transport == null) {
            return null;
        }
        long timeout = this.getTimeout() < 0L ? transport.getTimeout() : this.getTimeout();
        long interval = this.getInterval() < 0L ? transport.getInterval() : this.getInterval();
        return new JSON.Literal("{\"reconnect\":\"retry\",\"interval\":" + interval + "," + "\"timeout\":" + timeout + "}");
    }

    public void reAdvise() {
        this._advisedTransport = null;
    }

    public Object takeAdvice() {
        ServerTransport transport = this._bayeux.getCurrentTransport();
        if (transport != null && transport != this._advisedTransport) {
            this._advisedTransport = transport;
            return this.getAdvice();
        }
        return null;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public long getInterval() {
        return this._interval;
    }

    public void setTimeout(long timeoutMS) {
        this._timeout = timeoutMS;
        this._advisedTransport = null;
    }

    public void setInterval(long intervalMS) {
        this._interval = intervalMS;
        this._advisedTransport = null;
    }

    protected boolean removed(boolean timedout) {
        boolean connected = this._connected.getAndSet(false);
        boolean handshook = this._handshook.getAndSet(false);
        if (connected || handshook) {
            for (ServerChannelImpl channel : this._subscribedTo.keySet()) {
                channel.unsubscribe((ServerSession)this);
            }
            for (ServerSession.ServerSessionListener listener : this._listeners) {
                if (!(listener instanceof ServerSession.RemoveListener)) continue;
                this.notifyRemoved((ServerSession.RemoveListener)listener, this, timedout);
            }
        }
        return connected;
    }

    private void notifyRemoved(ServerSession.RemoveListener listener, ServerSession serverSession, boolean timedout) {
        try {
            listener.removed(serverSession, timedout);
        }
        catch (Exception x) {
            this._logger.info("Exception while invoking listener " + listener, x);
        }
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDelivery = meta;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDelivery;
    }

    protected void subscribedTo(ServerChannelImpl channel) {
        this._subscribedTo.put(channel, Boolean.TRUE);
    }

    protected void unsubscribedFrom(ServerChannelImpl channel) {
        this._subscribedTo.remove(channel);
    }

    protected void dump(StringBuilder b, String indent) {
        b.append(this.toString());
        b.append('\n');
        for (ServerSession.ServerSessionListener child : this._listeners) {
            b.append(indent);
            b.append(" +-");
            b.append(child);
            b.append('\n');
        }
        if (this.isLocalSession()) {
            b.append(indent);
            b.append(" +-");
            this._localSession.dump(b, indent + "   ");
        }
    }

    public String toDetailString() {
        return this._id + ",lc=" + this._lastConnect + ",li=" + this._lastInterval;
    }

    public String toString() {
        return this._id;
    }

    public long calculateTimeout(long defaultTimeout) {
        if (this._transientTimeout >= 0L) {
            return this._transientTimeout;
        }
        if (this._timeout >= 0L) {
            return this._timeout;
        }
        return defaultTimeout;
    }

    public long calculateInterval(long defaultInterval) {
        if (this._transientInterval >= 0L) {
            return this._transientInterval;
        }
        if (this._interval >= 0L) {
            return this._interval;
        }
        return defaultInterval;
    }

    public void updateTransientTimeout(long timeout) {
        this._transientTimeout = timeout;
    }

    public void updateTransientInterval(long interval) {
        this._transientInterval = interval;
    }
}

