/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import org.eclipse.jetty.util.ArrayQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIdQueue<E>
extends ArrayQueue<E> {
    private int[] _ids;
    private int _currentId;

    public ArrayIdQueue() {
        this._ids = new int[64];
    }

    public ArrayIdQueue(int capacity) {
        super(capacity);
        this._ids = new int[capacity];
    }

    public ArrayIdQueue(int initCapacity, int growBy) {
        super(initCapacity, growBy);
        this._ids = new int[initCapacity];
    }

    public ArrayIdQueue(int initCapacity, int growBy, Object lock) {
        super(initCapacity, growBy, lock);
        this._ids = new int[initCapacity];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentId() {
        Object object = this._lock;
        synchronized (object) {
            return this._currentId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentId(int currentId) {
        Object object = this._lock;
        synchronized (object) {
            this._currentId = currentId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCurrentId() {
        Object object = this._lock;
        synchronized (object) {
            ++this._currentId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        Object object = this._lock;
        synchronized (object) {
            int nextSlot = this._nextSlot;
            super.add(e);
            this._ids[nextSlot] = this._currentId;
        }
        return true;
    }

    @Override
    public void addUnsafe(E e) {
        int nextSlot = this._nextSlot;
        super.addUnsafe(e);
        this._ids[nextSlot] = this._currentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        Object object = this._lock;
        synchronized (object) {
            int nextSlot = this._nextSlot;
            super.offer(e);
            this._ids[nextSlot] = this._currentId;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssociatedId(int index) {
        Object object = this._lock;
        synchronized (object) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("!(0<" + index + "<=" + this._size + ")");
            }
            int i = (this._nextE + index) % this._ids.length;
            return this._ids[i];
        }
    }

    public long getAssociatedIdUnsafe(int index) {
        int i = (this._nextE + index) % this._ids.length;
        return this._ids[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Object object = this._lock;
        synchronized (object) {
            int nextSlot = this._nextSlot;
            Object e = super.remove(index);
            int i = this._nextE + index;
            if (i >= this._ids.length) {
                i -= this._ids.length;
            }
            if (i < nextSlot) {
                System.arraycopy(this._ids, i + 1, this._ids, i, nextSlot - i);
                --nextSlot;
            } else {
                System.arraycopy(this._ids, i + 1, this._ids, i, this._ids.length - i - 1);
                if (nextSlot > 0) {
                    this._ids[this._ids.length - 1] = this._ids[0];
                    System.arraycopy(this._ids, 1, this._ids, 0, nextSlot - 1);
                    --nextSlot;
                } else {
                    nextSlot = this._ids.length - 1;
                }
            }
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        Object object = this._lock;
        synchronized (object) {
            E old = super.set(index, element);
            int i = this._nextE + index;
            if (i >= this._ids.length) {
                i -= this._ids.length;
            }
            this._ids[i] = this._currentId;
            return old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E element) {
        Object object = this._lock;
        synchronized (object) {
            int nextSlot = this._nextSlot;
            super.add(index, element);
            if (index == this._size) {
                this._ids[index] = this._currentId;
            } else {
                int i = this._nextE + index;
                if (i >= this._ids.length) {
                    i -= this._ids.length;
                }
                if (i < nextSlot) {
                    System.arraycopy(this._ids, i, this._ids, i + 1, nextSlot - i);
                    this._ids[i] = this._currentId;
                } else {
                    if (nextSlot > 0) {
                        System.arraycopy(this._ids, 0, this._ids, 1, nextSlot);
                        this._ids[0] = this._ids[this._ids.length - 1];
                    }
                    System.arraycopy(this._ids, i, this._ids, i + 1, this._ids.length - i - 1);
                    this._ids[i] = this._currentId;
                }
            }
        }
    }

    @Override
    protected boolean grow() {
        int nextE = this._nextE;
        int nextSlot = this._nextSlot;
        if (!super.grow()) {
            return false;
        }
        int[] Ids = new int[this._elements.length];
        int split = this._ids.length - nextE;
        if (split > 0) {
            System.arraycopy(this._ids, nextE, Ids, 0, split);
        }
        if (nextE != 0) {
            System.arraycopy(this._ids, 0, Ids, split, nextSlot);
        }
        this._ids = Ids;
        return true;
    }
}

