/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.nio.charset.StandardCharsets;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.HashMapMessage;

public class ServerMessageImpl
extends HashMapMessage
implements ServerMessage.Mutable {
    private static final long serialVersionUID = 6412048662640296067L;
    private boolean _lazy;
    private String _json;
    private transient ServerMessage.Mutable _associated;
    private transient boolean _handled;
    private transient byte[] _jsonBytes;
    private transient BayeuxContext _context;
    private transient ServerTransport _transport;

    @Override
    public ServerMessage.Mutable getAssociated() {
        return this._associated;
    }

    @Override
    public void setAssociated(ServerMessage.Mutable associated) {
        this._associated = associated;
    }

    @Override
    public boolean isLazy() {
        return this._lazy;
    }

    public boolean isHandled() {
        return this._handled;
    }

    @Override
    public BayeuxContext getBayeuxContext() {
        return this._context;
    }

    public void setBayeuxContext(BayeuxContext context) {
        this._context = context;
    }

    @Override
    public ServerTransport getServerTransport() {
        return this._transport;
    }

    public void setServerTransport(ServerTransport transport) {
        this._transport = transport;
    }

    @Override
    public void setLazy(boolean lazy) {
        this._lazy = lazy;
    }

    public void setHandled(boolean handled) {
        this._handled = handled;
    }

    protected void freeze(String json) {
        this._json = json;
        this._jsonBytes = json.getBytes(StandardCharsets.UTF_8);
    }

    protected boolean isFrozen() {
        return this._json != null;
    }

    @Override
    public String getJSON() {
        return this._json;
    }

    public byte[] getJSONBytes() {
        return this._jsonBytes;
    }

    @Override
    public Object getData() {
        Object data = super.getData();
        if (this.isFrozen() && data instanceof Map) {
            Map map = (Map)data;
            return Collections.unmodifiableMap(map);
        }
        return data;
    }

    @Override
    public Object put(String key, Object value) {
        if (this.isFrozen()) {
            throw new UnsupportedOperationException();
        }
        return super.put(key, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.isFrozen()) {
            return new ImmutableEntrySet(super.entrySet());
        }
        return super.entrySet();
    }

    @Override
    public Map<String, Object> getDataAsMap() {
        Map<String, Object> data = super.getDataAsMap();
        if (this.isFrozen() && data != null) {
            return Collections.unmodifiableMap(data);
        }
        return data;
    }

    @Override
    public Map<String, Object> getExt() {
        Map<String, Object> ext = super.getExt();
        if (this.isFrozen() && ext != null) {
            return Collections.unmodifiableMap(ext);
        }
        return ext;
    }

    @Override
    public Map<String, Object> getAdvice() {
        Map<String, Object> advice = super.getAdvice();
        if (this.isFrozen() && advice != null) {
            return Collections.unmodifiableMap(advice);
        }
        return advice;
    }

    private static class ImmutableEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private final Set<Map.Entry<String, Object>> delegate;

        private ImmutableEntrySet(Set<Map.Entry<String, Object>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new ImmutableEntryIterator(this.delegate.iterator());
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        private static class ImmutableEntryIterator
        implements Iterator<Map.Entry<String, Object>> {
            private final Iterator<Map.Entry<String, Object>> delegate;

            private ImmutableEntryIterator(Iterator<Map.Entry<String, Object>> delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Map.Entry<String, Object> next() {
                return new ImmutableEntry(this.delegate.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private static class ImmutableEntry
            implements Map.Entry<String, Object> {
                private final Map.Entry<String, Object> delegate;

                private ImmutableEntry(Map.Entry<String, Object> delegate) {
                    this.delegate = delegate;
                }

                @Override
                public String getKey() {
                    return this.delegate.getKey();
                }

                @Override
                public Object getValue() {
                    return this.delegate.getValue();
                }

                @Override
                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

