/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.jmx;

import java.util.Set;
import java.util.TreeSet;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class BayeuxServerImplMBean
extends ObjectMBean {
    private final BayeuxServerImpl bayeux;

    public BayeuxServerImplMBean(Object managedObject) {
        super(managedObject);
        this.bayeux = (BayeuxServerImpl)managedObject;
    }

    @ManagedAttribute(value="The number of sessions", readonly=true)
    public int getSessions() {
        return this.bayeux.getSessions().size();
    }

    @ManagedAttribute(value="The channel names of this server", readonly=true)
    public Set<String> getChannels() {
        TreeSet<String> channels = new TreeSet<String>();
        for (ServerChannel channel : this.bayeux.getChannels()) {
            channels.add(channel.getId());
        }
        return channels;
    }

    @ManagedAttribute(value="The transports known by this server", readonly=true)
    public Set<String> getKnownTransportNames() {
        return new TreeSet<String>(this.bayeux.getKnownTransportNames());
    }

    @ManagedAttribute(value="The configuration option names", readonly=true)
    public Set<String> getOptionNames() {
        return new TreeSet<String>(this.bayeux.getOptionNames());
    }
}

