/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.CouchbaseConnectionFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.couchbase.CouchbaseComponent;
import org.apache.camel.component.couchbase.CouchbaseConsumer;
import org.apache.camel.component.couchbase.CouchbaseProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.19.0", scheme="couchbase", title="Couchbase", syntax="couchbase:protocol:hostname:port", consumerClass=CouchbaseConsumer.class, label="database,nosql")
public class CouchbaseEndpoint
extends ScheduledPollEndpoint {
    @UriPath
    @Metadata(required="true")
    private String protocol;
    @UriPath
    @Metadata(required="true")
    private String hostname;
    @UriPath(defaultValue="8091")
    private int port;
    @UriParam
    private String bucket;
    @UriParam
    private String key;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="advanced")
    private String additionalHosts;
    @UriParam(label="producer", defaultValue="0")
    private int persistTo;
    @UriParam(label="producer", defaultValue="0")
    private int replicateTo;
    @UriParam(label="producer", defaultValue="CCB_PUT")
    private String operation = "CCB_PUT";
    @UriParam(label="producer", defaultValue="false")
    private boolean autoStartIdForInserts;
    @UriParam(label="producer", defaultValue="2")
    private int producerRetryAttempts = 2;
    @UriParam(label="producer", defaultValue="5000")
    private int producerRetryPause = 5000;
    @UriParam(label="producer")
    private long startingIdForInsertsFrom;
    @UriParam(label="consumer", defaultValue="beer")
    private String designDocumentName = "beer";
    @UriParam(label="consumer", defaultValue="brewery_beers")
    private String viewName = "brewery_beers";
    @UriParam(label="consumer", defaultValue="-1")
    private int limit = -1;
    @UriParam(label="consumer", defaultValue="false")
    private boolean descending;
    @UriParam(label="consumer", defaultValue="-1")
    private int skip = -1;
    @UriParam(label="consumer")
    private String rangeStartKey;
    @UriParam(label="consumer")
    private String rangeEndKey = "";
    @UriParam(label="consumer", defaultValue="none")
    private String consumerProcessedStrategy = "none";
    @UriParam(label="advanced", defaultValue="2500")
    private long opTimeOut = 2500L;
    @UriParam(label="advanced", defaultValue="998")
    private int timeoutExceptionThreshold = 998;
    @UriParam(label="advanced", defaultValue="16384")
    private int readBufferSize = 16384;
    @UriParam(label="advanced", defaultValue="false")
    private boolean shouldOptimize;
    @UriParam(label="advanced", defaultValue="30000")
    private long maxReconnectDelay = 30000L;
    @UriParam(label="advanced", defaultValue="10000")
    private long opQueueMaxBlockTime = 10000L;
    @UriParam(label="advanced", defaultValue="400")
    private long obsPollInterval = 400L;
    @UriParam(label="advanced", defaultValue="-1")
    private long obsTimeout = -1L;

    public CouchbaseEndpoint() {
    }

    public CouchbaseEndpoint(String uri, String remaining, CouchbaseComponent component) throws URISyntaxException {
        super(uri, (Component)component);
        URI remainingUri = new URI(remaining);
        this.protocol = remainingUri.getScheme();
        if (this.protocol == null) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form couchbase:http[s]://hostname[:port]/bucket?[options...]");
        }
        int n = this.port = remainingUri.getPort() == -1 ? 8091 : remainingUri.getPort();
        if (remainingUri.getPath() == null || remainingUri.getPath().trim().length() == 0) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form couchbase:http[s]://hostname[:port]/bucket?[options...]");
        }
        this.bucket = remainingUri.getPath().substring(1);
        this.hostname = remainingUri.getHost();
        if (this.hostname == null) {
            throw new IllegalArgumentException("Invalid URI. Format must be of the form couchbase:http[s]://hostname[:port]/bucket?[options...]");
        }
    }

    public CouchbaseEndpoint(String endpointUri, CouchbaseComponent component) {
        super(endpointUri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new CouchbaseProducer(this, this.createClient(), this.persistTo, this.replicateTo);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new CouchbaseConsumer(this, this.createClient(), processor);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAdditionalHosts() {
        return this.additionalHosts;
    }

    public void setAdditionalHosts(String additionalHosts) {
        this.additionalHosts = additionalHosts;
    }

    public int getPersistTo() {
        return this.persistTo;
    }

    public void setPersistTo(int persistTo) {
        this.persistTo = persistTo;
    }

    public int getReplicateTo() {
        return this.replicateTo;
    }

    public void setReplicateTo(int replicateTo) {
        this.replicateTo = replicateTo;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean isAutoStartIdForInserts() {
        return this.autoStartIdForInserts;
    }

    public void setAutoStartIdForInserts(boolean autoStartIdForInserts) {
        this.autoStartIdForInserts = autoStartIdForInserts;
    }

    public long getStartingIdForInsertsFrom() {
        return this.startingIdForInsertsFrom;
    }

    public void setStartingIdForInsertsFrom(long startingIdForInsertsFrom) {
        this.startingIdForInsertsFrom = startingIdForInsertsFrom;
    }

    public int getProducerRetryAttempts() {
        return this.producerRetryAttempts;
    }

    public void setProducerRetryAttempts(int producerRetryAttempts) {
        this.producerRetryAttempts = producerRetryAttempts;
    }

    public int getProducerRetryPause() {
        return this.producerRetryPause;
    }

    public void setProducerRetryPause(int producerRetryPause) {
        this.producerRetryPause = producerRetryPause;
    }

    public String getDesignDocumentName() {
        return this.designDocumentName;
    }

    public void setDesignDocumentName(String designDocumentName) {
        this.designDocumentName = designDocumentName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public String getRangeStartKey() {
        return this.rangeStartKey;
    }

    public void setRangeStartKey(String rangeStartKey) {
        this.rangeStartKey = rangeStartKey;
    }

    public String getRangeEndKey() {
        return this.rangeEndKey;
    }

    public void setRangeEndKey(String rangeEndKey) {
        this.rangeEndKey = rangeEndKey;
    }

    public String getConsumerProcessedStrategy() {
        return this.consumerProcessedStrategy;
    }

    public void setConsumerProcessedStrategy(String consumerProcessedStrategy) {
        this.consumerProcessedStrategy = consumerProcessedStrategy;
    }

    public long getOpTimeOut() {
        return this.opTimeOut;
    }

    public void setOpTimeOut(long opTimeOut) {
        this.opTimeOut = opTimeOut;
    }

    public int getTimeoutExceptionThreshold() {
        return this.timeoutExceptionThreshold;
    }

    public void setTimeoutExceptionThreshold(int timeoutExceptionThreshold) {
        this.timeoutExceptionThreshold = timeoutExceptionThreshold;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public boolean isShouldOptimize() {
        return this.shouldOptimize;
    }

    public void setShouldOptimize(boolean shouldOptimize) {
        this.shouldOptimize = shouldOptimize;
    }

    public long getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(long maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public long getOpQueueMaxBlockTime() {
        return this.opQueueMaxBlockTime;
    }

    public void setOpQueueMaxBlockTime(long opQueueMaxBlockTime) {
        this.opQueueMaxBlockTime = opQueueMaxBlockTime;
    }

    public long getObsPollInterval() {
        return this.obsPollInterval;
    }

    public void setObsPollInterval(long obsPollInterval) {
        this.obsPollInterval = obsPollInterval;
    }

    public long getObsTimeout() {
        return this.obsTimeout;
    }

    public void setObsTimeout(long obsTimeout) {
        this.obsTimeout = obsTimeout;
    }

    public URI[] makeBootstrapURI() throws URISyntaxException {
        if (this.additionalHosts == null || "".equals(this.additionalHosts)) {
            return new URI[]{new URI(this.protocol + "://" + this.hostname + ":" + this.port + "/pools")};
        }
        return this.getAllUris();
    }

    private URI[] getAllUris() throws URISyntaxException {
        String[] hosts = this.additionalHosts.split(",");
        for (int i = 0; i < hosts.length; ++i) {
            hosts[i] = hosts[i].trim();
        }
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.add(this.hostname);
        hostList.addAll(Arrays.asList(hosts));
        LinkedHashSet hostSet = new LinkedHashSet(hostList);
        hosts = hostSet.toArray(new String[hostSet.size()]);
        URI[] uriArray = new URI[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            uriArray[i] = new URI(this.protocol + "://" + hosts[i] + ":" + this.port + "/pools");
        }
        return uriArray;
    }

    private CouchbaseClient createClient() throws IOException, URISyntaxException {
        List<URI> hosts = Arrays.asList(this.makeBootstrapURI());
        CouchbaseConnectionFactoryBuilder cfb = new CouchbaseConnectionFactoryBuilder();
        if (this.opTimeOut != 2500L) {
            cfb.setOpTimeout(this.opTimeOut);
        }
        if (this.timeoutExceptionThreshold != 998) {
            cfb.setTimeoutExceptionThreshold(this.timeoutExceptionThreshold);
        }
        if (this.readBufferSize != 16384) {
            cfb.setReadBufferSize(this.readBufferSize);
        }
        if (this.shouldOptimize) {
            cfb.setShouldOptimize(true);
        }
        if (this.maxReconnectDelay != 30000L) {
            cfb.setMaxReconnectDelay(this.maxReconnectDelay);
        }
        if (this.opQueueMaxBlockTime != 10000L) {
            cfb.setOpQueueMaxBlockTime(this.opQueueMaxBlockTime);
        }
        if (this.obsPollInterval != 400L) {
            cfb.setObsPollInterval(this.obsPollInterval);
        }
        if (this.obsTimeout != -1L) {
            cfb.setObsTimeout(this.obsTimeout);
        }
        return new CouchbaseClient(cfb.buildCouchbaseConnection(hosts, this.bucket, this.username, this.password));
    }
}

