/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import org.jboss.netty.channel.socket.nio.NioAcceptedSocketChannel;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.internal.DeadLockProofWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioServerSocketPipelineSink
extends AbstractNioChannelSink {
    private static final AtomicInteger nextId = new AtomicInteger();
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketPipelineSink.class);
    final int id = nextId.incrementAndGet();
    private final WorkerPool<NioWorker> workerPool;

    NioServerSocketPipelineSink(WorkerPool<NioWorker> workerPool) {
        this.workerPool = workerPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof NioServerSocketChannel) {
            this.handleServerSocket(e);
        } else if (channel instanceof NioSocketChannel) {
            NioServerSocketPipelineSink.handleAcceptedSocket(e);
        }
    }

    private void handleServerSocket(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        NioServerSocketChannel channel = (NioServerSocketChannel)event.getChannel();
        ChannelFuture future = event.getFuture();
        ChannelState state = event.getState();
        Object value = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value)) break;
                NioServerSocketPipelineSink.close(channel, future);
                break;
            }
            case BOUND: {
                if (value != null) {
                    this.bind(channel, future, (SocketAddress)value);
                    break;
                }
                NioServerSocketPipelineSink.close(channel, future);
                break;
            }
        }
    }

    private static void handleAcceptedSocket(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value != null) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bind(NioServerSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean bossStarted = false;
        try {
            try {
                channel.socket.socket().bind(localAddress, channel.getConfig().getBacklog());
                bound = true;
                future.setSuccess();
                Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
                Executor bossExecutor = ((NioServerSocketChannelFactory)channel.getFactory()).bossExecutor;
                DeadLockProofWorker.start(bossExecutor, new ThreadRenamingRunnable(new Boss(channel), "New I/O server boss #" + this.id + " (" + channel + ')'));
                return;
            }
            catch (Throwable t) {
                future.setFailure(t);
                Channels.fireExceptionCaught(channel, t);
                Object var8_9 = null;
                if (bossStarted) return;
                if (!bound) return;
                NioServerSocketPipelineSink.close(channel, future);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (bossStarted || !bound) throw throwable;
            NioServerSocketPipelineSink.close(channel, future);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void close(NioServerSocketChannel channel, ChannelFuture future) {
        boolean bound = channel.isBound();
        try {
            if (channel.socket.isOpen()) {
                channel.socket.close();
                Selector selector = channel.selector;
                if (selector != null) {
                    selector.wakeup();
                }
            }
            channel.shutdownLock.lock();
            try {
                if (channel.setClosed()) {
                    future.setSuccess();
                    if (bound) {
                        Channels.fireChannelUnbound(channel);
                    }
                    Channels.fireChannelClosed(channel);
                } else {
                    future.setSuccess();
                }
                Object var5_5 = null;
                channel.shutdownLock.unlock();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                channel.shutdownLock.unlock();
                throw throwable;
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    NioWorker nextWorker() {
        return this.workerPool.nextWorker();
    }

    private final class Boss
    implements Runnable {
        private final Selector selector;
        private final NioServerSocketChannel channel;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Boss(NioServerSocketChannel channel) throws IOException {
            this.channel = channel;
            this.selector = Selector.open();
            boolean registered = false;
            try {
                channel.socket.register(this.selector, 16);
                registered = true;
                Object var5_4 = null;
                if (!registered) {
                    this.closeSelector();
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!registered) {
                    this.closeSelector();
                }
                throw throwable;
            }
            channel.selector = this.selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Thread currentThread = Thread.currentThread();
            this.channel.shutdownLock.lock();
            try {
                while (true) {
                    try {
                        block11: while (true) {
                            if (this.selector.select(1000L) > 0) {
                                this.selector.selectedKeys().clear();
                            }
                            while (true) {
                                SocketChannel acceptedSocket;
                                if ((acceptedSocket = this.channel.socket.accept()) == null) continue block11;
                                this.registerAcceptedChannel(acceptedSocket, currentThread);
                            }
                            break;
                        }
                    }
                    catch (SocketTimeoutException e) {
                        continue;
                    }
                    catch (CancelledKeyException e) {
                        continue;
                    }
                    catch (ClosedSelectorException e) {
                        continue;
                    }
                    catch (ClosedChannelException e) {
                    }
                    catch (Throwable e) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Failed to accept a connection.", e);
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                    }
                    break;
                }
                Object var5_9 = null;
                this.channel.shutdownLock.unlock();
                this.closeSelector();
                return;
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                this.channel.shutdownLock.unlock();
                this.closeSelector();
                throw throwable;
            }
        }

        private void registerAcceptedChannel(SocketChannel acceptedSocket, Thread currentThread) {
            block5: {
                try {
                    ChannelPipeline pipeline = this.channel.getConfig().getPipelineFactory().getPipeline();
                    NioWorker worker = NioServerSocketPipelineSink.this.nextWorker();
                    worker.register(new NioAcceptedSocketChannel(this.channel.getFactory(), pipeline, this.channel, NioServerSocketPipelineSink.this, acceptedSocket, worker, currentThread), null);
                }
                catch (Exception e) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Failed to initialize an accepted socket.", e);
                    }
                    try {
                        acceptedSocket.close();
                    }
                    catch (IOException e2) {
                        if (!logger.isWarnEnabled()) break block5;
                        logger.warn("Failed to close a partially accepted socket.", e2);
                    }
                }
            }
        }

        private void closeSelector() {
            block2: {
                this.channel.selector = null;
                try {
                    this.selector.close();
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block2;
                    logger.warn("Failed to close a selector.", e);
                }
            }
        }
    }
}

