/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.util.Validators;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class SeedNode {
    public static final Set<SeedNode> LOCALHOST = Collections.singleton(SeedNode.create("127.0.0.1"));
    private final String address;
    private final Optional<Integer> kvPort;
    private final Optional<Integer> clusterManagerPort;

    public static SeedNode create(String address) {
        return SeedNode.create(address, Optional.empty(), Optional.empty());
    }

    public static SeedNode create(String address, Optional<Integer> kvPort, Optional<Integer> clusterManagerPort) {
        return new SeedNode(address, kvPort, clusterManagerPort);
    }

    private SeedNode(String address, Optional<Integer> kvPort, Optional<Integer> clusterManagerPort) {
        this.address = Validators.notNullOrEmpty(address, "Address");
        this.kvPort = Validators.notNull(kvPort, "KvPort");
        this.clusterManagerPort = Validators.notNull(clusterManagerPort, "ClusterManagerPort");
    }

    public SeedNode withKvPort(@Nullable Integer port) {
        return SeedNode.create(this.address(), Optional.ofNullable(port), this.clusterManagerPort());
    }

    public SeedNode withManagerPort(@Nullable Integer port) {
        return SeedNode.create(this.address(), this.kvPort(), Optional.ofNullable(port));
    }

    public String address() {
        return this.address;
    }

    public Optional<Integer> kvPort() {
        return this.kvPort;
    }

    public Optional<Integer> clusterManagerPort() {
        return this.clusterManagerPort;
    }

    public String toString() {
        return "SeedNode{address='" + this.address + '\'' + ", kvPort=" + this.kvPort + ", mgmtPort=" + this.clusterManagerPort + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeedNode seedNode = (SeedNode)o;
        return Objects.equals(this.address, seedNode.address) && Objects.equals(this.kvPort, seedNode.kvPort) && Objects.equals(this.clusterManagerPort, seedNode.clusterManagerPort);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.kvPort, this.clusterManagerPort);
    }
}

