/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class ScopeExistsException
extends CouchbaseException {
    private final String scopeName;

    public ScopeExistsException(String scopeName) {
        super("Scope [" + RedactableArgument.redactMeta(scopeName) + "] already exists.");
        this.scopeName = Objects.requireNonNull(scopeName);
    }

    public static ScopeExistsException forScope(String scopeName) {
        return new ScopeExistsException(scopeName);
    }

    public String scopeName() {
        return this.scopeName;
    }
}

