/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.EnumLookupTable;

@Stability.Internal
public enum ServerFeature {
    DATATYPE(1),
    TLS(2),
    TCPNODELAY(3),
    MUTATION_SEQNO(4),
    TCPDELAY(5),
    XATTR(6),
    XERROR(7),
    SELECT_BUCKET(8),
    SNAPPY(10),
    JSON(11),
    DUPLEX(12),
    CLUSTERMAP_CHANGE_NOTIFICATION(13),
    UNORDERED_EXECUTION(14),
    TRACING(15),
    ALT_REQUEST(16),
    SYNC_REPLICATION(17),
    COLLECTIONS(18),
    PRESERVE_TTL(20),
    VATTR(21),
    CREATE_AS_DELETED(23),
    REPORT_UNIT_USAGE(26);

    private static final EnumLookupTable<ServerFeature> lookupTable;
    private final short value;

    private ServerFeature(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    static ServerFeature from(short input) {
        return lookupTable.getOrDefault(Short.toUnsignedInt(input), null);
    }

    static {
        lookupTable = EnumLookupTable.create(ServerFeature.class, e -> Short.toUnsignedInt(e.value()));
    }
}

