/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.BucketExistsException;
import com.couchbase.client.core.error.BucketNotFlushableException;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@Stability.Internal
public class CoreBucketManager {
    private final Core core;
    private final CoreHttpClient httpClient;

    public CoreBucketManager(Core core) {
        this.core = core;
        this.httpClient = core.httpClient(RequestTarget.manager());
    }

    private static CoreHttpPath pathForBuckets() {
        return CoreHttpPath.path("/pools/default/buckets/");
    }

    private static CoreHttpPath pathForBucket(String bucketName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}", CbCollections.mapOf("bucketName", bucketName));
    }

    private static CoreHttpPath pathForBucketFlush(String bucketName) {
        return CoreHttpPath.path("/pools/default/buckets/{bucketName}/controller/doFlush", CbCollections.mapOf("bucketName", bucketName));
    }

    private static String getBucketName(Map<String, String> settings) {
        return Objects.requireNonNull(settings.get("name"), "Missing required 'name' parameter");
    }

    public CompletableFuture<Void> createBucket(Map<String, String> settings, CoreCommonOptions options) {
        String bucketName = CoreBucketManager.getBucketName(settings);
        return ((CompletableFuture)this.httpClient.post(CoreBucketManager.pathForBuckets(), options).trace("manager_buckets_create_bucket").traceBucket(bucketName).form(this.convertSettingsToParams(settings, false)).exec(this.core).exceptionally(t -> {
            throw HttpStatusCodeException.httpResponseBody(t).contains("Bucket with given name already exists") ? BucketExistsException.forBucket(bucketName) : CbThrowables.propagate(t);
        })).thenApply(response -> null);
    }

    public CompletableFuture<Void> updateBucket(Map<String, String> settings, CoreCommonOptions options) {
        String bucketName = CoreBucketManager.getBucketName(settings);
        RequestSpan span = CbTracing.newSpan(this.core.context(), "manager_buckets_update_bucket", (RequestSpan)options.parentSpan().orElse(null));
        span.attribute("db.name", bucketName);
        CoreCommonOptions getAllBucketOptions = options.withParentSpan(span);
        return Mono.fromFuture(() -> this.getAllBuckets(getAllBucketOptions)).map(buckets -> buckets.containsKey(bucketName)).flatMap(bucketExists -> {
            if (!bucketExists.booleanValue()) {
                return Mono.error(BucketNotFoundException.forBucket(bucketName));
            }
            return Mono.fromFuture(this.httpClient.post(CoreBucketManager.pathForBucket(bucketName), options).form(this.convertSettingsToParams(settings, true)).exec(this.core).thenApply(response -> null));
        }).then().doOnTerminate(span::end).toFuture();
    }

    private UrlQueryStringBuilder convertSettingsToParams(Map<String, String> settings, boolean update) {
        HashMap<String, String> params = new HashMap<String, String>(settings);
        if (update) {
            params.remove("name");
            params.remove("bucketType");
            params.remove("conflictResolutionType");
            params.remove("replicaIndex");
            params.remove("storageBackend");
        }
        UrlQueryStringBuilder form = UrlQueryStringBuilder.createForUrlSafeNames();
        params.forEach(form::set);
        return form;
    }

    public CompletableFuture<Void> dropBucket(String bucketName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.delete(CoreBucketManager.pathForBucket(bucketName), options).trace("manager_buckets_drop_bucket").traceBucket(bucketName).exec(this.core).exceptionally((Function)CoreBucketManager.translateBucketNotFound(bucketName))).thenApply(response -> null);
    }

    public CompletableFuture<byte[]> getBucket(String bucketName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.get(CoreBucketManager.pathForBucket(bucketName), options).trace("manager_buckets_get_bucket").traceBucket(bucketName).exec(this.core).exceptionally((Function)CoreBucketManager.translateBucketNotFound(bucketName))).thenApply(CoreHttpResponse::content);
    }

    private static Function<Throwable, CoreHttpResponse> translateBucketNotFound(String bucketName) {
        return t -> {
            throw HttpStatusCodeException.couchbaseResponseStatus(t) == ResponseStatus.NOT_FOUND ? BucketNotFoundException.forBucket(bucketName) : CbThrowables.propagate(t);
        };
    }

    public CompletableFuture<Map<String, byte[]>> getAllBuckets(CoreCommonOptions options) {
        return this.httpClient.get(CoreBucketManager.pathForBuckets(), options).trace("manager_buckets_get_all_buckets").exec(this.core).thenApply(response -> {
            JsonNode tree = Mapper.decodeIntoTree(response.content());
            HashMap<String, byte[]> out = new HashMap<String, byte[]>();
            for (JsonNode bucket : tree) {
                String bucketName = Objects.requireNonNull(bucket.get("name").textValue(), "Bucket json is missing 'name' field: " + RedactableArgument.redactMeta(bucket));
                out.put(bucketName, Mapper.encodeAsBytes(bucket));
            }
            return out;
        });
    }

    public CompletableFuture<Void> flushBucket(String bucketName, CoreCommonOptions options) {
        return ((CompletableFuture)this.httpClient.post(CoreBucketManager.pathForBucketFlush(bucketName), options).trace("manager_buckets_flush_bucket").traceBucket(bucketName).exec(this.core).exceptionally(t -> {
            if (HttpStatusCodeException.couchbaseResponseStatus(t) == ResponseStatus.INVALID_ARGS && HttpStatusCodeException.httpResponseBody(t).contains("Flush is disabled")) {
                throw BucketNotFlushableException.forBucket(bucketName);
            }
            return CoreBucketManager.translateBucketNotFound(bucketName).apply((Throwable)t);
        })).thenApply(response -> null);
    }
}

